/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Group
extends Composite {
    static final int CLIENT_INSET = 3;
    static final int GroupProc;
    static final TCHAR GroupClass;

    static {
        GroupClass = new TCHAR(0, OS.IsWinCE ? "BUTTON" : "SWT_GROUP", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        if (OS.IsWinCE) {
            OS.GetClassInfo(0, GroupClass, lpWndClass);
            GroupProc = lpWndClass.lpfnWndProc;
        } else {
            TCHAR WC_BUTTON = new TCHAR(0, "BUTTON", true);
            OS.GetClassInfo(0, WC_BUTTON, lpWndClass);
            GroupProc = lpWndClass.lpfnWndProc;
            int hInstance = OS.GetModuleHandle(null);
            if (!OS.GetClassInfo(hInstance, GroupClass, lpWndClass)) {
                int hHeap = OS.GetProcessHeap();
                lpWndClass.hInstance = hInstance;
                lpWndClass.style &= 0xFFFFFFFC;
                int byteCount = GroupClass.length() * TCHAR.sizeof;
                int lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
                OS.MoveMemory(lpszClassName, GroupClass, byteCount);
                lpWndClass.lpszClassName = lpszClassName;
                OS.RegisterClass(lpWndClass);
            }
        }
    }

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        switch (msg) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(hwnd, msg, wParam, lParam);
            }
        }
        return OS.CallWindowProc(GroupProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSize(wHint, hHint, changed);
        int length = OS.GetWindowTextLength(this.handle);
        if (length != 0) {
            TCHAR buffer1 = new TCHAR(this.getCodePage(), length + 1);
            OS.GetWindowText(this.handle, buffer1, length + 1);
            int oldFont = 0;
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            RECT rect = new RECT();
            int flags = 1056;
            OS.DrawText(hDC, buffer1, length, rect, flags);
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            size.x = Math.max(size.x, rect.right - rect.left + 18);
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int oldFont = 0;
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        trim.x -= 3;
        trim.y -= tm.tmHeight;
        trim.width += 6;
        trim.height += tm.tmHeight + 3;
        return trim;
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int oldFont = 0;
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        int x = 3;
        int y = tm.tmHeight;
        int width = rect.right - 6;
        int height = rect.bottom - y - 3;
        return new Rectangle(x, y, width, height);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    boolean mnemonicHit(char key) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
    }

    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    TCHAR windowClass() {
        return GroupClass;
    }

    int windowProc() {
        return GroupProc;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
            return result;
        }
        this.drawBackground(wParam);
        return LRESULT.ONE;
    }

    LRESULT WM_NCHITTEST(int wParam, int lParam) {
        LRESULT result = super.WM_NCHITTEST(wParam, lParam);
        if (result != null) {
            return result;
        }
        int code = this.callWindowProc(this.handle, 132, wParam, lParam);
        if (code == -1) {
            code = 1;
        }
        return new LRESULT(code);
    }

    LRESULT WM_MOUSEMOVE(int wParam, int lParam) {
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            int nSavedDC = OS.SaveDC(wParam);
            int code = this.callWindowProc(this.handle, 792, wParam, lParam);
            OS.RestoreDC(wParam, nSavedDC);
            return new LRESULT(code);
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (OS.IsWinCE) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, true);
        return result;
    }

    LRESULT wmColorChild(int wParam, int lParam) {
        Control control;
        LRESULT result = super.wmColorChild(wParam, lParam);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            OS.SetBkMode(wParam, 1);
            RECT rect = new RECT();
            OS.GetClientRect(control.handle, rect);
            OS.MapWindowPoints(control.handle, this.handle, rect, 2);
            control.drawThemeBackground(wParam, rect);
            return new LRESULT(OS.GetStockObject(5));
        }
        return result;
    }
}

