/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVFINDITEM;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    ImageList imageList;
    TableItem currentItem;
    int lastIndexOf;
    int lastWidth;
    boolean customDraw;
    boolean dragStarted;
    boolean fixScrollWidth;
    boolean mouseDown;
    boolean tipRequested;
    boolean ignoreActivate;
    boolean ignoreSelect;
    boolean ignoreShrink;
    boolean ignoreResize;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int HEADER_MARGIN = 10;
    static final int TableProc;
    static final TCHAR TableClass;
    static final char[] BUTTON;

    static {
        TableClass = new TCHAR(0, "SysListView32", true);
        char[] cArray = new char[7];
        cArray[0] = 66;
        cArray[1] = 85;
        cArray[2] = 84;
        cArray[3] = 84;
        cArray[4] = 79;
        cArray[5] = 78;
        BUTTON = cArray;
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, TableClass, lpWndClass);
        TableProc = lpWndClass.lpfnWndProc;
    }

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    TableItem _getItem(int index) {
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, -1, false);
        return this.items[index];
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        switch (msg) {
            case 513: 
            case 516: 
            case 519: 
            case 523: {
                this.display.ignoreMsgFilter = true;
                int code = OS.CallWindowProc(TableProc, hwnd, msg, wParam, lParam);
                this.display.ignoreMsgFilter = false;
                return code;
            }
            case 256: {
                this.ignoreActivate = true;
                int code = OS.CallWindowProc(TableProc, hwnd, msg, wParam, lParam);
                this.ignoreActivate = false;
                return code;
            }
        }
        return OS.CallWindowProc(TableProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    boolean checkData(TableItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item, false)) {
                item.redraw();
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            if (item != this.currentItem) {
                item.clear();
            }
            if ((this.style & 0x10000000) == 0 && item.cached) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 17;
                lvItem.pszText = -1;
                lvItem.iItem = index;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                item.cached = false;
            }
            if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, index, index);
            }
            this.setScrollWidth(item, false);
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.clearAll();
        } else {
            LVITEM lvItem = null;
            boolean cleared = false;
            int i = start;
            while (i <= end) {
                TableItem item = this.items[i];
                if (item != null) {
                    if (item != this.currentItem) {
                        cleared = true;
                        item.clear();
                    }
                    if ((this.style & 0x10000000) == 0 && item.cached) {
                        if (lvItem == null) {
                            lvItem = new LVITEM();
                            lvItem.mask = 17;
                            lvItem.pszText = -1;
                        }
                        lvItem.iItem = i;
                        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                        item.cached = false;
                    }
                }
                ++i;
            }
            if (cleared) {
                if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, start, end);
                }
                TableItem item = start == end ? this.items[start] : null;
                this.setScrollWidth(item, false);
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= count) {
                this.error(6);
            }
            ++i;
        }
        LVITEM lvItem = null;
        boolean cleared = false;
        int i2 = 0;
        while (i2 < indices.length) {
            int index = indices[i2];
            TableItem item = this.items[index];
            if (item != null) {
                if (item != this.currentItem) {
                    cleared = true;
                    item.clear();
                }
                if ((this.style & 0x10000000) == 0 && item.cached) {
                    if (lvItem == null) {
                        lvItem = new LVITEM();
                        lvItem.mask = 17;
                        lvItem.pszText = -1;
                    }
                    lvItem.iItem = i2;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                    item.cached = false;
                }
                if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, index, index);
                }
            }
            ++i2;
        }
        if (cleared) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        LVITEM lvItem = null;
        boolean cleared = false;
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < count) {
            TableItem item = this.items[i];
            if (item != null) {
                if (item != this.currentItem) {
                    cleared = true;
                    item.clear();
                }
                if ((this.style & 0x10000000) == 0 && item.cached) {
                    if (lvItem == null) {
                        lvItem = new LVITEM();
                        lvItem.mask = 17;
                        lvItem.pszText = -1;
                    }
                    lvItem.iItem = i;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                    item.cached = false;
                }
            }
            ++i;
        }
        if (cleared) {
            if (this.currentItem == null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0, count - 1);
            }
            this.setScrollWidth(null, false);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        int bits = 0;
        if (wHint != -1) {
            bits |= wHint & 0xFFFF;
        } else {
            int width = 0;
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
            int i = 0;
            while (i < count) {
                width += OS.SendMessage(this.handle, 4125, i, 0);
                ++i;
            }
            bits |= width & 0xFFFF;
        }
        if (hHint != -1) {
            bits |= hHint << 16;
        }
        int result = OS.SendMessage(this.handle, 4160, -1, bits);
        int width = result & 0xFFFF;
        int height = result >> 16;
        int empty = OS.SendMessage(this.handle, 4160, 0, 0);
        int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
        height -= (oneItem >> 16) - (empty >> 16);
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    void createHandle() {
        int pszText;
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            int width;
            int empty = OS.SendMessage(this.handle, 4160, 0, 0);
            int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
            int height = width = (oneItem >> 16) - (empty >> 16);
            this.setCheckboxImageList(width, height);
            OS.SendMessage(this.handle, 4107, 61440, 0);
        }
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 4;
        int hHeap = OS.GetProcessHeap();
        lvColumn.pszText = pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0, lvColumn);
        OS.HeapFree(hHeap, 0, pszText);
        int bits1 = 16402;
        if ((this.style & 0x10000) != 0) {
            bits1 |= 0x20;
        }
        OS.SendMessage(this.handle, 4150, bits1, bits1);
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        if ((this.style & 0x4000000) != 0) {
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            int bits2 = OS.GetWindowLong(hwndHeader, -20);
            OS.SetWindowLong(hwndHeader, -20, bits2 | 0x400000);
        }
    }

    void createItem(TableColumn column, int index) {
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        int columnCount = count + 1;
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                int[] temp;
                Image[] images;
                String[] strings = item.strings;
                if (strings != null) {
                    String[] temp2 = new String[columnCount];
                    System.arraycopy(strings, 0, temp2, 0, index);
                    System.arraycopy(strings, index, temp2, index + 1, columnCount - index - 1);
                    item.strings = temp2;
                }
                if ((images = item.images) != null) {
                    Image[] temp3 = new Image[columnCount];
                    System.arraycopy(images, 0, temp3, 0, index);
                    System.arraycopy(images, index, temp3, index + 1, columnCount - index - 1);
                    item.images = temp3;
                }
                if (index == 0 && count != 0) {
                    if (strings == null) {
                        item.strings = new String[columnCount];
                        item.strings[1] = item.text;
                    }
                    item.text = "";
                    if (images == null) {
                        item.images = new Image[columnCount];
                        item.images[1] = item.image;
                    }
                    item.image = null;
                }
                if (item.cellBackground != null) {
                    int[] cellBackground = item.cellBackground;
                    temp = new int[columnCount];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index, temp, index + 1, columnCount - index - 1);
                    temp[index] = -1;
                    item.cellBackground = temp;
                }
                if (item.cellForeground != null) {
                    int[] cellForeground = item.cellForeground;
                    temp = new int[columnCount];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index, temp, index + 1, columnCount - index - 1);
                    temp[index] = -1;
                    item.cellForeground = temp;
                }
                if (item.cellFont != null) {
                    int[] cellFont = item.cellFont;
                    temp = new int[columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, columnCount - index - 1);
                    temp[index] = -1;
                    item.cellFont = temp;
                }
            }
            ++i;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, count - index);
        this.columns[index] = column;
        if (index == 0) {
            if (count > 0) {
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1, lvColumn);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lvColumn);
                int width = lvColumn.cx;
                int cchTextMax = 1024;
                int hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * TCHAR.sizeof;
                int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                lvColumn.mask = 23;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0, lvColumn);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1, lvColumn);
                lvColumn.fmt = 2048;
                lvColumn.cx = width;
                lvColumn.iImage = -2;
                lvColumn.cchTextMax = 0;
                lvColumn.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                lvColumn.mask = 1;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0, 0);
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 3;
                lvItem.pszText = -1;
                lvItem.iImage = -1;
                int i2 = 0;
                while (i2 < itemCount) {
                    lvItem.iItem = i2++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                }
            }
        } else {
            int fmt = 0;
            if ((column.style & 0x1000000) == 0x1000000) {
                fmt = 2;
            }
            if ((column.style & 0x20000) == 131072) {
                fmt = 1;
            }
            LVCOLUMN lvColumn = new LVCOLUMN();
            lvColumn.mask = 3;
            lvColumn.fmt = fmt;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, index, lvColumn);
        }
    }

    void createItem(TableItem item, int index) {
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            boolean small = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 3;
        lvItem.iItem = index;
        lvItem.pszText = -1;
        lvItem.iImage = -1;
        this.ignoreSelect = true;
        int result = OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0, lvItem);
        this.ignoreSelect = false;
        if (result == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.stateMask = 2;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, indices[i], lvItem);
                this.ignoreSelect = false;
            }
            ++i;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, index, lvItem);
        this.ignoreSelect = false;
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (start == 0 && end == count - 1) {
            this.deselectAll();
        } else {
            LVITEM lvItem = new LVITEM();
            lvItem.stateMask = 2;
            int i = start = Math.max(0, start);
            while (i <= end) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, i, lvItem);
                this.ignoreSelect = false;
                ++i;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lvItem);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn column) {
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
        int index = 0;
        while (index < columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        boolean first = false;
        if (index == 0) {
            first = true;
            if (columnCount > 1) {
                index = 1;
                int cchTextMax = 1024;
                int hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * TCHAR.sizeof;
                int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 6;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lvColumn);
                lvColumn.mask |= 1;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            } else {
                int hHeap = OS.GetProcessHeap();
                int pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 4;
                lvColumn.pszText = pszText;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 3;
                lvItem.pszText = -1;
                lvItem.iImage = -1;
                int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
                int i = 0;
                while (i < itemCount) {
                    lvItem.iItem = i++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                }
            }
        }
        if (columnCount > 1 && OS.SendMessage(this.handle, 4124, index, 0) == 0) {
            this.error(15);
        }
        if (first) {
            index = 0;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --columnCount - index);
        this.columns[columnCount] = null;
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                if (columnCount == 0) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, columnCount - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, columnCount - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        int[] cellBackground = item.cellBackground;
                        temp = new int[columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, columnCount - index);
                        item.cellBackground = (int[])temp;
                    }
                    if (item.cellForeground != null) {
                        int[] cellForeground = item.cellForeground;
                        temp = new int[columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, columnCount - index);
                        item.cellForeground = (int[])temp;
                    }
                    if (item.cellFont != null) {
                        int[] cellFont = item.cellFont;
                        temp = new int[columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, columnCount - index);
                        item.cellFont = (int[])temp;
                    }
                }
            }
            ++i;
        }
        if (columnCount == 0) {
            this.setScrollWidth(null, true);
        }
    }

    void destroyItem(TableItem item) {
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int code = OS.SendMessage(this.handle, 4104, index, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (code == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.setTableEmpty();
        }
    }

    void fixCheckboxImageList() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int hImageList = OS.SendMessage(this.handle, 4098, 1, 0);
        if (hImageList == 0) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hImageList, cx, cy);
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        if (hOldStateList == 0) {
            return;
        }
        int[] stateCx = new int[1];
        int[] stateCy = new int[1];
        OS.ImageList_GetIconSize(hOldStateList, stateCx, stateCy);
        if (cx[0] == stateCx[0] && cy[0] == stateCy[0]) {
            return;
        }
        this.setCheckboxImageList(cx[0], cy[0]);
    }

    int getBackgroundPixel() {
        return OS.SendMessage(this.handle, 4096, 0, 0);
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        return count;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            return new int[0];
        }
        int[] order = new int[count];
        OS.SendMessage(this.handle, 4155, count, order);
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        TableColumn[] result = new TableColumn[count];
        System.arraycopy(this.columns, 0, result, 0, count);
        return result;
    }

    int getFocusIndex() {
        return OS.SendMessage(this.handle, 4108, -1, 1);
    }

    int getForegroundPixel() {
        int pixel = OS.SendMessage(this.handle, 4131, 0, 0);
        if (pixel == -16777216) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return pixel;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        if (hwndHeader == 0) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x4000) == 0;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = point.x;
        pinfo.y = point.y;
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        if (pinfo.iItem != -1) {
            return this._getItem(pinfo.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4100, 0, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int empty = OS.SendMessage(this.handle, 4160, 0, 0);
        int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
        return (oneItem >> 16) - (empty >> 16);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        TableItem[] result = new TableItem[count];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < count) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, count);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        return (bits & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = OS.SendMessage(this.handle, 4146, 0, 0);
        TableItem[] result = new TableItem[count];
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            result[j++] = this._getItem(i);
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4146, 0, 0);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int focusIndex = OS.SendMessage(this.handle, 4108, -1, 1);
        int selectedIndex = OS.SendMessage(this.handle, 4108, -1, 2);
        if (focusIndex == selectedIndex) {
            return selectedIndex;
        }
        int i = -1;
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            if (i != focusIndex) continue;
            return i;
        }
        return selectedIndex;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = OS.SendMessage(this.handle, 4146, 0, 0);
        int[] result = new int[count];
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            result[j++] = i;
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, OS.SendMessage(this.handle, 4135, 0, 0));
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBounds();
            this.imageList = this.display.getImageList(new Point(bounds.width, bounds.height));
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            int hImageList = this.imageList.getHandle();
            int topIndex = this.getTopIndex();
            this.setRedraw(false);
            this.setTopIndex(0);
            OS.SendMessage(this.handle, 4099, 1, hImageList);
            this.setTopIndex(topIndex);
            this.fixCheckboxImageList();
            this.setRedraw(true);
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (1 <= this.lastIndexOf && this.lastIndexOf < count - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < count / 2) {
            int i = 0;
            while (i < count) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = count - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = index;
        int result = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
        return result != 0 && (lvItem.state & 2) != 0;
    }

    void releaseWidget() {
        int i;
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (columnCount == 1 && this.columns[0] == null) {
            columnCount = 0;
        }
        int i2 = 0;
        while (i2 < columnCount) {
            TableColumn column = this.columns[i2];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i2;
        }
        this.columns = null;
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        if (OS.IsWin95 && columnCount > 1) {
            OS.SendMessage(this.handle, 11, 0, 0);
            i = itemCount - 1;
            while (i >= 0) {
                TableItem item = this.items[i];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4104, i, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                --i;
            }
        } else {
            i = 0;
            while (i < itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                ++i;
            }
        }
        this.customDraw = false;
        this.currentItem = null;
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        int hOldList = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, 0);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
        super.releaseWidget();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                TableItem item = this.items[index];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int code = OS.SendMessage(this.handle, 4104, index, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (code == 0) {
                    this.error(15);
                }
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                System.arraycopy(this.items, index + 1, this.items, index, --count - index);
                this.items[count] = null;
                last = index;
            }
            ++i;
        }
        if (count == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        TableItem item = this.items[index];
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int code = OS.SendMessage(this.handle, 4104, index, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (code == 0) {
            this.error(15);
        }
        if (item != null && !item.isDisposed()) {
            item.releaseResources();
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.removeAll();
        } else {
            int index = start;
            while (index <= end) {
                TableItem item = this.items[index];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int code = OS.SendMessage(this.handle, 4104, start, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (code == 0) break;
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                ++index;
            }
            System.arraycopy(this.items, index, this.items, start, count - index);
            int i = count - (index - start);
            while (i < count) {
                this.items[i] = null;
                ++i;
            }
            if (index <= end) {
                this.error(15);
            }
        }
    }

    public void removeAll() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (columnCount == 1 && this.columns[0] == null) {
            columnCount = 0;
        }
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        if (OS.IsWin95 && columnCount > 1) {
            boolean redraw;
            boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            int index = itemCount - 1;
            while (index >= 0) {
                TableItem item = this.items[index];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int code = OS.SendMessage(this.handle, 4104, index, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (code == 0) break;
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                --index;
            }
            if (redraw) {
                OS.SendMessage(this.handle, 11, 1, 0);
            }
            if (index != -1) {
                this.error(15);
            }
        } else {
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            int code = OS.SendMessage(this.handle, 4105, 0, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (code == 0) {
                this.error(15);
            }
            int i = 0;
            while (i < itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.releaseResources();
                }
                ++i;
            }
        }
        this.setTableEmpty();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 2;
        lvItem.stateMask = 2;
        int i = length - 1;
        while (i >= 0) {
            if (indices[i] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, indices[i], lvItem);
                this.ignoreSelect = false;
            }
            --i;
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 2;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, index, lvItem);
        this.ignoreSelect = false;
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if (start == 0 && end == count - 1) {
            this.selectAll();
        } else {
            LVITEM lvItem = new LVITEM();
            lvItem.state = 2;
            lvItem.stateMask = 2;
            int i = start;
            while (i <= end) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, i, lvItem);
                this.ignoreSelect = false;
                ++i;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lvItem);
        this.ignoreSelect = false;
    }

    LRESULT sendMouseDownEvent(int type, int button, int msg, int wParam, int lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(type, button, this.handle, msg, wParam, lParam);
        OS.SetFocus(this.handle);
        if (pinfo.iItem == -1) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        boolean wasSelected = false;
        int count = OS.SendMessage(this.handle, 4146, 0, 0);
        if (count == 1 && pinfo.iItem != -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = pinfo.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
            boolean bl = wasSelected = (lvItem.state & 2) != 0;
            if (wasSelected) {
                this.ignoreSelect = true;
            }
        }
        this.dragStarted = false;
        int code = this.callWindowProc(this.handle, msg, wParam, lParam);
        if (wasSelected) {
            this.ignoreSelect = false;
            Event event = new Event();
            event.item = this._getItem(pinfo.iItem);
            this.postEvent(13, event);
        }
        if (this.dragStarted) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean fakeMouseUp;
            int flags = 6;
            boolean bl = fakeMouseUp = (pinfo.flags & flags) != 0;
            if (!fakeMouseUp && (this.style & 2) != 0) {
                boolean bl2 = fakeMouseUp = (pinfo.flags & 8) == 0;
            }
            if (fakeMouseUp) {
                this.mouseDown = false;
                this.sendMouseEvent(4, button, this.handle, msg, wParam, lParam);
            }
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if (pixel == -1) {
            pixel = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 4097, 0, pixel);
        OS.SendMessage(this.handle, 4134, 0, pixel);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setColumnOrder(int[] order) {
        int hwndHeader;
        int count;
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if ((count = OS.SendMessage(hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 1 && this.columns[0] == null) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != count) {
            this.error(5);
        }
        int[] oldOrder = new int[count];
        OS.SendMessage(this.handle, 4155, count, oldOrder);
        boolean reorder = false;
        boolean[] seen = new boolean[count];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= count) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (index != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            RECT[] oldRects = new RECT[count];
            int i2 = 0;
            while (i2 < count) {
                oldRects[i2] = new RECT();
                OS.SendMessage(hwndHeader, 4615, i2, oldRects[i2]);
                ++i2;
            }
            OS.SendMessage(this.handle, 4154, order.length, order);
            OS.InvalidateRect(this.handle, null, true);
            TableColumn[] newColumns = new TableColumn[count];
            System.arraycopy(this.columns, 0, newColumns, 0, count);
            int i3 = 0;
            while (i3 < count) {
                TableColumn column = newColumns[oldOrder[i3]];
                if (!column.isDisposed() && order[i3] != oldOrder[i3]) {
                    column.sendEvent(10);
                }
                ++i3;
            }
        }
    }

    void setCheckboxImageListColor() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        if (hOldStateList == 0) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hOldStateList, cx, cy);
        this.setCheckboxImageList(cx[0], cy[0]);
    }

    void setCheckboxImageList(int width, int height) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 4;
        int flags = ImageList.COLOR_FLAGS;
        if ((this.style & 0x4000000) != 0) {
            flags |= 0x2000;
        }
        int hImageList = OS.ImageList_Create(width, height, flags, count, count);
        int hDC = OS.GetDC(this.handle);
        int memDC = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        int hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int hBrush = OS.CreateSolidBrush(this.getBackgroundPixel());
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        int oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left, top, left + itemWidth, top + itemHeight);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int hTheme = OS.OpenThemeData(this.handle, BUTTON);
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 5, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 9, rect, null);
            OS.CloseThemeData(hTheme);
        } else {
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
        }
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        OS.ImageList_Add(hImageList, hBitmap, 0);
        OS.DeleteObject(hBitmap);
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, hImageList);
        if (hOldStateList != 0) {
            OS.ImageList_Destroy(hOldStateList);
        }
    }

    void setFocusIndex(int index) {
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 1;
        lvItem.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, index, lvItem);
        this.ignoreSelect = false;
    }

    public void setFont(Font font) {
        this.checkWidget();
        int topIndex = this.getTopIndex();
        this.setRedraw(false);
        this.setTopIndex(0);
        super.setFont(font);
        this.setTopIndex(topIndex);
        this.setScrollWidth(null, true);
        this.setRedraw(true);
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        OS.InvalidateRect(hwndHeader, null, true);
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((bits & 1) == 0) {
            return;
        }
        bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x4000) != 0) {
            return;
        }
        this.setItemHeight();
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        if (pixel == -1) {
            pixel = -16777216;
        }
        OS.SendMessage(this.handle, 4132, 0, pixel);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setHeaderVisible(boolean show) {
        int bits;
        this.checkWidget();
        int newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFBFFF;
        if (!show) {
            newBits |= 0x4000;
        }
        int topIndex = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, newBits);
        this.setTopIndex(topIndex);
        if (show && ((bits = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
            this.setItemHeight();
        }
    }

    public void setItemCount(int count) {
        boolean isVirtual;
        this.checkWidget();
        count = Math.max(0, count);
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        if (count == itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        int index = count;
        while (index < itemCount) {
            TableItem item = this.items[index];
            if (!isVirtual) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int code = OS.SendMessage(this.handle, 4104, count, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (code == 0) break;
            }
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++index;
        }
        if (index < itemCount) {
            this.error(15);
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(count, itemCount));
        this.items = newItems;
        if (isVirtual) {
            int flags = 3;
            OS.SendMessage(this.handle, 4143, count, flags);
        } else {
            int i = itemCount;
            while (i < count) {
                this.items[i] = new TableItem(this, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
    }

    void setItemHeight() {
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            return;
        }
        int hOldList = OS.SendMessage(this.handle, 4098, 1, 0);
        if (hOldList != 0) {
            return;
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rect = new RECT();
        OS.GetWindowRect(hwndHeader, rect);
        int height = rect.bottom - rect.top - 1;
        int hImageList = OS.ImageList_Create(1, height, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1, hImageList);
        this.fixCheckboxImageList();
        OS.SendMessage(this.handle, 4099, 1, 0);
        OS.ImageList_Destroy(hImageList);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        int newBits = 0;
        if (show) {
            newBits = 1;
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 0x4000) == 0) {
                this.setItemHeight();
            }
        }
        OS.SendMessage(this.handle, 4150, 1, newBits);
    }

    public void setRedraw(boolean redraw) {
        int hwndHeader;
        int bits;
        this.checkWidget();
        if (this.drawCount == 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (redraw) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                OS.SendMessage(this.handle, 11, 1, 0);
                hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
                if (hwndHeader != 0) {
                    OS.SendMessage(hwndHeader, 11, 1, 0);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, false);
                    if (hwndHeader != 0) {
                        OS.InvalidateRect(hwndHeader, null, false);
                    }
                } else {
                    int flags = 1157;
                    OS.RedrawWindow(this.handle, null, 0, flags);
                }
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
            hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            if (hwndHeader != 0) {
                OS.SendMessage(hwndHeader, 11, 0, 0);
            }
        }
    }

    boolean setScrollWidth(TableItem item, boolean force) {
        if (this.currentItem != null) {
            if (this.currentItem != item) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!(force || this.drawCount == 0 && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            int hImageList;
            int newWidth = 0;
            count = OS.SendMessage(this.handle, 4100, 0, 0);
            int index = 0;
            int imageIndent = 0;
            while (index < count) {
                String string = null;
                int font = -1;
                if (item != null) {
                    string = item.text;
                    imageIndent = Math.max(imageIndent, item.imageIndent);
                    if (item.cellFont != null) {
                        font = item.cellFont[0];
                    }
                    if (font == -1) {
                        font = item.font;
                    }
                } else if (this.items[index] != null) {
                    TableItem tableItem = this.items[index];
                    string = tableItem.text;
                    imageIndent = Math.max(imageIndent, tableItem.imageIndent);
                    if (tableItem.cellFont != null) {
                        font = tableItem.cellFont[0];
                    }
                    if (font == -1) {
                        font = tableItem.font;
                    }
                }
                if (string != null && string.length() != 0) {
                    if (font != -1) {
                        int hDC = OS.GetDC(this.handle);
                        int oldFont = OS.SelectObject(hDC, font);
                        int flags = 3104;
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
                        RECT rect = new RECT();
                        OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
                        OS.SelectObject(hDC, oldFont);
                        OS.ReleaseDC(this.handle, hDC);
                        newWidth = Math.max(newWidth, rect.right - rect.left);
                    } else {
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
                        newWidth = Math.max(newWidth, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, buffer));
                    }
                }
                if (item != null) break;
                ++index;
            }
            int hStateList = OS.SendMessage(this.handle, 4098, 2, 0);
            if (hStateList != 0) {
                int[] cx = new int[1];
                int[] cy = new int[1];
                OS.ImageList_GetIconSize(hStateList, cx, cy);
                newWidth += cx[0] + 4;
            }
            if ((hImageList = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
                int[] cx = new int[1];
                int[] cy = new int[1];
                OS.ImageList_GetIconSize(hImageList, cx, cy);
                newWidth += (imageIndent + 1) * cx[0];
            } else {
                ++newWidth;
            }
            int oldWidth = OS.SendMessage(this.handle, 4125, 0, 0);
            if ((newWidth += 8) > oldWidth) {
                OS.SendMessage(this.handle, 4126, 0, newWidth);
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        int focusIndex = indices[0];
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int focusIndex = -1;
        int i = length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                focusIndex = index;
                this.select(focusIndex);
            }
            --i;
        }
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        if (index != -1) {
            this.setFocusIndex(index);
        }
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.select(start, end);
        this.setFocusIndex(start);
        this.showSelection();
    }

    void setTableEmpty() {
        if (this.imageList != null) {
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
            if (columnCount == 1 && this.columns[0] == null) {
                columnCount = 0;
            }
            int i = 0;
            while (i < columnCount) {
                TableColumn column = this.columns[i];
                if (column.getImage() != null) break;
                ++i;
            }
            if (i == columnCount) {
                int hImageList = OS.ImageList_Create(1, 1, 0, 0, 0);
                OS.SendMessage(this.handle, 4099, 1, hImageList);
                OS.SendMessage(this.handle, 4099, 1, 0);
                OS.ImageList_Destroy(hImageList);
                this.display.releaseImageList(this.imageList);
                this.imageList = null;
            }
        }
        this.customDraw = false;
        this.items = new TableItem[4];
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int topIndex = OS.SendMessage(this.handle, 4135, 0, 0);
        if (index == topIndex) {
            return;
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, index, 1);
            if (index != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, index, 1);
            }
            return;
        }
        RECT rect = new RECT();
        rect.left = 0;
        OS.SendMessage(this.handle, 4110, 0, rect);
        int dy = (index - topIndex) * (rect.bottom - rect.top);
        OS.SendMessage(this.handle, 4116, 0, dy);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count <= 1 || index < 0 || index >= count) {
            return;
        }
        RECT rect = new RECT();
        rect.left = 0;
        if (index == 0) {
            rect.top = 1;
            OS.SendMessage(this.handle, 4152, -1, rect);
            rect.right = rect.left;
            int width = OS.SendMessage(this.handle, 4125, 0, 0);
            rect.left = rect.right - width;
        } else {
            rect.top = index;
            OS.SendMessage(this.handle, 4152, -1, rect);
        }
        RECT area = new RECT();
        OS.GetClientRect(this.handle, area);
        if (rect.left < area.left) {
            int dx = rect.left - area.left;
            OS.SendMessage(this.handle, 4116, dx, 0);
        } else {
            int width = Math.min(area.right - area.left, rect.right - rect.left);
            if (rect.left + width > area.right) {
                int dx = rect.left + width - area.right;
                OS.SendMessage(this.handle, 4116, dx, 0);
            }
        }
    }

    void showItem(int index) {
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, index, 1);
            if (index != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, index, 1);
            }
        } else {
            OS.SendMessage(this.handle, 4115, index, 0);
        }
    }

    public void showItem(TableItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((index = this.indexOf(item)) != -1) {
            this.showItem(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = OS.SendMessage(this.handle, 4108, -1, 2);
        if (index != -1) {
            this.showItem(index);
        }
    }

    String toolTipText(NMTTDISPINFO hdr) {
        int hwndToolTip = OS.SendMessage(this.handle, 4174, 0, 0);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        return super.toolTipText(hdr);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40;
        if ((this.style & 0x8000) == 0) {
            bits |= 8;
        }
        if ((this.style & 4) != 0) {
            bits |= 4;
        }
        bits |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            bits |= 0x1000;
        }
        return bits;
    }

    TCHAR windowClass() {
        return TableClass;
    }

    int windowProc() {
        return TableProc;
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 13: {
                int index = OS.SendMessage(this.handle, 4108, -1, 1);
                if (index != -1) {
                    Event event = new Event();
                    event.item = this._getItem(index);
                    this.postEvent(14, event);
                }
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        return result;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        int index;
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0 && wParam == 32 && (index = OS.SendMessage(this.handle, 4108, -1, 1)) != -1) {
            TableItem item;
            item.setChecked(!(item = this._getItem(index)).getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
            }
        }
        return result;
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        this.mouseDown = true;
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        int index = OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
        this.sendMouseEvent(8, 1, this.handle, 515, wParam, lParam);
        if (pinfo.iItem != -1) {
            this.callWindowProc(this.handle, 515, wParam, lParam);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 0x20) != 0 && index != -1 && pinfo.flags == 8) {
            TableItem item;
            item.setChecked(!(item = this._getItem(index)).getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        this.mouseDown = true;
        LRESULT result = this.sendMouseDownEvent(3, 1, 513, wParam, lParam);
        if ((this.style & 0x20) != 0) {
            LVHITTESTINFO pinfo = new LVHITTESTINFO();
            pinfo.x = (short)(lParam & 0xFFFF);
            pinfo.y = (short)(lParam >> 16);
            int index = OS.SendMessage(this.handle, 4114, 0, pinfo);
            if (index != -1 && pinfo.flags == 8) {
                TableItem item;
                item.setChecked(!(item = this._getItem(index)).getChecked(), true);
                if (!OS.IsWinCE) {
                    OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
                }
            }
        }
        return result;
    }

    LRESULT WM_LBUTTONUP(int wParam, int lParam) {
        this.mouseDown = false;
        return super.WM_LBUTTONUP(wParam, lParam);
    }

    LRESULT WM_MOUSEHOVER(int wParam, int lParam) {
        int mask;
        LRESULT result = super.WM_MOUSEHOVER(wParam, lParam);
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((bits & (mask = 200)) != 0) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        if (!this.ignoreShrink) {
            int count = OS.SendMessage(this.handle, 4100, 0, 0);
            if (this.items.length > 4 && this.items.length - count > 3) {
                int length = Math.max(4, (count + 3) / 4 * 4);
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, count);
                this.items = newItems;
            }
        }
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        return super.WM_PAINT(wParam, lParam);
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        LRESULT result;
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        if (hdr.hwndFrom == hwndHeader) {
            switch (hdr.code) {
                case -326: 
                case -325: 
                case -306: 
                case -305: {
                    int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
                    if (count == 1 && this.columns[0] == null) {
                        return LRESULT.ONE;
                    }
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TableColumn column = this.columns[phdn.iItem];
                    if (column == null || column.getResizable()) break;
                    return LRESULT.ONE;
                }
                case -310: {
                    TableColumn column;
                    int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
                    if (count == 1 && this.columns[0] == null) {
                        return LRESULT.ONE;
                    }
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.iItem == -1 || (column = this.columns[phdn.iItem]) == null || column.getMoveable()) break;
                    OS.ReleaseCapture();
                    return LRESULT.ONE;
                }
                case -311: {
                    int count;
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.iItem == -1 || phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 0x80) == 0 || pitem.iOrder == -1 || (count = OS.SendMessage(hwndHeader, 4608, 0, 0)) == 1 && this.columns[0] == null) break;
                    int[] order = new int[count];
                    OS.SendMessage(this.handle, 4155, count, order);
                    int index = 0;
                    while (index < order.length) {
                        if (order[index] == phdn.iItem) break;
                        ++index;
                    }
                    if (index == order.length) {
                        index = 0;
                    }
                    if (index == pitem.iOrder) break;
                    int start = Math.min(index, pitem.iOrder);
                    int end = Math.max(index, pitem.iOrder);
                    int i = start;
                    while (i <= end) {
                        TableColumn column = this.columns[order[i]];
                        if (!column.isDisposed()) {
                            column.postEvent(10);
                        }
                        ++i;
                    }
                    break;
                }
                case -321: 
                case -301: {
                    TableColumn column;
                    int bits;
                    int width = OS.SendMessage(this.handle, 4125, 0, 0);
                    if (this.lastWidth == 0 && width > 0 && ((bits = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
                        RECT rect = new RECT();
                        OS.GetClientRect(this.handle, rect);
                        rect.right = rect.left + width;
                        OS.InvalidateRect(this.handle, rect, true);
                    }
                    this.lastWidth = width;
                    if (this.ignoreResize) break;
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 1) == 0 || (column = this.columns[phdn.iItem]) == null) break;
                    column.sendEvent(11);
                    if (this.isDisposed()) {
                        return LRESULT.ZERO;
                    }
                    int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
                    if (count == 1 && this.columns[0] == null) {
                        count = 0;
                    }
                    TableColumn[] newColumns = new TableColumn[count];
                    System.arraycopy(this.columns, 0, newColumns, 0, count);
                    int[] order = new int[count];
                    OS.SendMessage(this.handle, 4155, count, order);
                    boolean moved = false;
                    int i = 0;
                    while (i < count) {
                        TableColumn nextColumn = newColumns[order[i]];
                        if (moved && !nextColumn.isDisposed()) {
                            nextColumn.sendEvent(10);
                        }
                        if (nextColumn == column) {
                            moved = true;
                        }
                        ++i;
                    }
                    break;
                }
                case -323: 
                case -303: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TableColumn column = this.columns[phdn.iItem];
                    if (column == null) break;
                    column.postEvent(14);
                }
            }
        }
        if ((result = super.WM_NOTIFY(wParam, lParam)) != null) {
            return result;
        }
        switch (hdr.code) {
            case -530: 
            case -520: {
                this.tipRequested = true;
                int code = this.callWindowProc(this.handle, 78, wParam, lParam);
                this.tipRequested = false;
                return new LRESULT(code);
            }
        }
        return result;
    }

    LRESULT WM_RBUTTONDBLCLK(int wParam, int lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(3, 1, this.handle, 516, wParam, lParam);
        this.sendMouseEvent(8, 1, this.handle, 518, wParam, lParam);
        if (pinfo.iItem != -1) {
            this.callWindowProc(this.handle, 518, wParam, lParam);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        return this.sendMouseDownEvent(3, 3, 516, wParam, lParam);
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (count == 0) {
            return result;
        }
        int index = OS.SendMessage(this.handle, 4108, -1, 1);
        if (index == -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.state = 1;
            lvItem.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0, lvItem);
            this.ignoreSelect = false;
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.background == -1) {
            int pixel = this.defaultBackground();
            OS.SendMessage(this.handle, 4097, 0, pixel);
            OS.SendMessage(this.handle, 4134, 0, pixel);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        return result;
    }

    LRESULT WM_VSCROLL(int wParam, int lParam) {
        LRESULT result = super.WM_VSCROLL(wParam, lParam);
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((bits & 1) != 0) {
            int code = wParam & 0xFFFF;
            switch (code) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 0: 
                case 1: {
                    RECT rect;
                    int headerHeight = 0;
                    int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
                    if (hwndHeader != 0) {
                        rect = new RECT();
                        OS.GetWindowRect(hwndHeader, rect);
                        headerHeight = rect.bottom - rect.top;
                    }
                    rect = new RECT();
                    OS.GetClientRect(this.handle, rect);
                    rect.top += headerHeight;
                    int empty = OS.SendMessage(this.handle, 4160, 0, 0);
                    int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
                    int itemHeight = (oneItem >> 16) - (empty >> 16);
                    if (code == 1) {
                        rect.top = rect.bottom - itemHeight - 1;
                    } else {
                        rect.bottom = rect.top + itemHeight + 1;
                    }
                    OS.InvalidateRect(this.handle, rect, true);
                    break;
                }
                case 2: 
                case 3: {
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        }
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGED(int wParam, int lParam) {
        if (this.ignoreResize) {
            return null;
        }
        LRESULT result = super.WM_WINDOWPOSCHANGED(wParam, lParam);
        if (result != null) {
            return result;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, 28);
        if ((lpwp.flags & 1) == 0) {
            this.setResizeChildren(false);
            int code = this.callWindowProc(this.handle, 71, wParam, lParam);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return new LRESULT(code);
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false, false);
            }
            this.setResizeChildren(true);
            return new LRESULT(code);
        }
        return result;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        switch (hdr.code) {
            case -179: 
            case -152: {
                if ((this.style & 0x10000000) == 0) break;
                NMLVFINDITEM pnmfi = new NMLVFINDITEM();
                OS.MoveMemory(pnmfi, lParam, 40);
                int index = Math.max(0, pnmfi.iStart - 1);
                return new LRESULT(index);
            }
            case -177: 
            case -150: {
                NMLVDISPINFO plvfi = new NMLVDISPINFO();
                OS.MoveMemory(plvfi, lParam, 52);
                this.lastIndexOf = plvfi.iItem;
                TableItem item = this._getItem(plvfi.iItem);
                if (!item.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        TableItem newItem;
                        if (!this.checkData(item, false)) break;
                        TableItem tableItem = newItem = this.fixScrollWidth ? null : item;
                        if (this.setScrollWidth(newItem, true)) {
                            OS.InvalidateRect(this.handle, null, true);
                        }
                    }
                    item.cached = true;
                }
                if ((plvfi.mask & 1) != 0) {
                    String string = null;
                    if (plvfi.iSubItem == 0) {
                        string = item.text;
                    } else {
                        String[] strings = item.strings;
                        if (strings != null) {
                            string = strings[plvfi.iSubItem];
                        }
                    }
                    if (string != null) {
                        if (!this.tipRequested && string.length() == 0 && plvfi.iSubItem == 0) {
                            string = " ";
                        }
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
                        int byteCount = Math.min(buffer.length(), plvfi.cchTextMax - 1) * TCHAR.sizeof;
                        OS.MoveMemory(plvfi.pszText, buffer, byteCount);
                        OS.MoveMemory(plvfi.pszText + byteCount, new byte[TCHAR.sizeof], TCHAR.sizeof);
                        plvfi.cchTextMax = Math.min(plvfi.cchTextMax, string.length() + 1);
                    }
                }
                if ((plvfi.mask & 2) != 0) {
                    Image image = null;
                    if (plvfi.iSubItem == 0) {
                        image = item.image;
                    } else {
                        Image[] images = item.images;
                        if (images != null) {
                            image = images[plvfi.iSubItem];
                        }
                    }
                    if (image != null) {
                        plvfi.iImage = this.imageIndex(image);
                    }
                }
                if ((plvfi.mask & 8) != 0 && plvfi.iSubItem == 0) {
                    int state = 1;
                    if (item.checked) {
                        ++state;
                    }
                    if (item.grayed) {
                        state += 2;
                    }
                    plvfi.state = state << 12;
                    plvfi.stateMask = 61440;
                }
                if ((plvfi.mask & 0x10) != 0 && plvfi.iSubItem == 0) {
                    plvfi.iIndent = item.imageIndent;
                }
                OS.MoveMemory(lParam, plvfi, 52);
                break;
            }
            case -12: {
                if (!this.customDraw) break;
                NMLVCUSTOMDRAW nmcd = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, 60);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return new LRESULT(32);
                    }
                    case 65537: {
                        return new LRESULT(32);
                    }
                    case 196609: {
                        int hwndHeader;
                        int count;
                        int clrTextBk;
                        int clrText;
                        int hFont;
                        TableItem item = this._getItem(nmcd.dwItemSpec);
                        int n = hFont = item.cellFont != null ? item.cellFont[nmcd.iSubItem] : -1;
                        if (hFont == -1) {
                            hFont = item.font;
                        }
                        int n2 = clrText = item.cellForeground != null ? item.cellForeground[nmcd.iSubItem] : -1;
                        if (clrText == -1) {
                            clrText = item.foreground;
                        }
                        int n3 = clrTextBk = item.cellBackground != null ? item.cellBackground[nmcd.iSubItem] : -1;
                        if (clrTextBk == -1) {
                            clrTextBk = item.background;
                        }
                        if (hFont == -1 && clrText == -1 && clrTextBk == -1 && item.cellForeground == null && item.cellBackground == null && item.cellFont == null && (count = OS.SendMessage(hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 1) break;
                        if (hFont == -1) {
                            hFont = OS.SendMessage(this.handle, 49, 0, 0);
                        }
                        OS.SelectObject(nmcd.hdc, hFont);
                        if (OS.IsWindowEnabled(this.handle)) {
                            nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                            nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                            OS.MoveMemory(lParam, nmcd, 60);
                        }
                        return new LRESULT(2);
                    }
                }
                break;
            }
            case -156: {
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                this.dragStarted = true;
                if (hdr.code != -109) break;
                int pos = OS.GetMessagePos();
                POINT pt = new POINT();
                pt.x = (short)(pos & 0xFFFF);
                pt.y = (short)(pos >> 16);
                OS.ScreenToClient(this.handle, pt);
                Event event = new Event();
                event.x = pt.x;
                event.y = pt.y;
                this.postEvent(29, event);
                break;
            }
            case -108: {
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                TableColumn column = this.columns[pnmlv.iSubItem];
                if (column == null) break;
                column.postEvent(13);
                break;
            }
            case -114: {
                if (this.ignoreActivate) break;
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(pnmlv.iItem);
                this.postEvent(14, event);
                break;
            }
            case -101: {
                if (this.ignoreSelect) break;
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1 || (pnmlv.uChanged & 8) == 0) break;
                boolean isFocus = (pnmlv.uNewState & 1) != 0;
                int index = OS.SendMessage(this.handle, 4108, -1, 1);
                if ((this.style & 2) != 0 && OS.GetKeyState(17) < 0) {
                    if (!isFocus) {
                        if (index == pnmlv.iItem) {
                            boolean isSelected = (pnmlv.uNewState & 2) != 0;
                            boolean wasSelected = (pnmlv.uOldState & 2) != 0;
                            isFocus = isSelected != wasSelected;
                        }
                    } else {
                        isFocus = this.mouseDown;
                    }
                }
                if (OS.GetKeyState(32) < 0) {
                    isFocus = true;
                }
                if (!isFocus) break;
                Event event = new Event();
                if (index != -1) {
                    event.item = this._getItem(index);
                }
                this.postEvent(13, event);
                break;
            }
            case -16: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (hasMenu || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (!hasMenu && !this.hooks(35)) break;
                NMRGINFO nmrg = new NMRGINFO();
                OS.MoveMemory(nmrg, lParam, NMRGINFO.sizeof);
                this.showMenu(this.menu, nmrg.x, nmrg.y);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

