/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.DemoModule;
import demo.swingset.SwingSet2;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.LayoutManager;
import swingwt.awt.LayoutManager2;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.AbstractAction;
import swingwtx.swing.Action;
import swingwtx.swing.JButton;
import swingwtx.swing.JPanel;
import swingwtx.swing.JProgressBar;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTextArea;
import swingwtx.swing.Timer;
import swingwtx.swing.border.Border;
import swingwtx.swing.border.SoftBevelBorder;

public class ProgressBarDemo
extends DemoModule {
    Timer timer;
    Action loadAction;
    Action stopAction;
    JProgressBar progressBar;
    JTextArea progressTextArea;
    int textLocation = 0;
    String text = this.getString("ProgressBarDemo.text");

    public static void main(String[] stringArray) {
        ProgressBarDemo progressBarDemo = new ProgressBarDemo(null);
        progressBarDemo.mainImpl();
    }

    public ProgressBarDemo(SwingSet2 swingSet2) {
        super(swingSet2, "ProgressBarDemo", "toolbar/JProgressBar.gif");
        this.createProgressPanel();
    }

    public void createProgressPanel() {
        this.getDemoPanel().setLayout((LayoutManager)new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager2)new BorderLayout());
        jPanel.setBorder((Border)new SoftBevelBorder(1));
        jPanel.setAlignmentX(0.0f);
        this.progressTextArea = new MyTextArea();
        jPanel.add((Component)new JScrollPane((Component)this.progressTextArea), (Object)"Center");
        this.getDemoPanel().add((Component)jPanel, (Object)"Center");
        JPanel jPanel2 = new JPanel();
        this.getDemoPanel().add((Component)jPanel2, (Object)"South");
        this.progressBar = new JProgressBar(0, 0, this.text.length()){

            public Dimension getPreferredSize() {
                return new Dimension(300, super.getPreferredSize().height);
            }
        };
        jPanel2.add((Component)this.progressBar);
        jPanel2.add((Component)this.createLoadButton());
        jPanel2.add((Component)this.createStopButton());
    }

    public JButton createLoadButton() {
        this.loadAction = new AbstractAction(this.getString("ProgressBarDemo.start_button")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressBarDemo.this.timer == null) {
                    ProgressBarDemo.this.loadAction.setEnabled(false);
                    ProgressBarDemo.this.stopAction.setEnabled(true);
                    ProgressBarDemo.this.timer = new Timer(18, (ActionListener)ProgressBarDemo.this.createTextLoadAction());
                    ProgressBarDemo.this.timer.start();
                }
            }
        };
        return this.createButton(this.loadAction);
    }

    public JButton createStopButton() {
        this.stopAction = new AbstractAction(this.getString("ProgressBarDemo.stop_button")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressBarDemo.this.timer != null) {
                    ProgressBarDemo.this.timer.stop();
                    ProgressBarDemo.this.timer = null;
                }
                ProgressBarDemo.this.loadAction.setEnabled(true);
                ProgressBarDemo.this.stopAction.setEnabled(false);
            }
        };
        return this.createButton(this.stopAction);
    }

    public JButton createButton(Action action) {
        JButton jButton = new JButton();
        jButton.putClientProperty((Object)"displayActionText", (Object)Boolean.TRUE);
        jButton.setAction(action);
        return jButton;
    }

    public Action createTextLoadAction() {
        return new AbstractAction("text load action"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressBarDemo.this.progressBar.getValue() < ProgressBarDemo.this.progressBar.getMaximum()) {
                    ProgressBarDemo.this.progressBar.setValue(ProgressBarDemo.this.progressBar.getValue() + 1);
                    ProgressBarDemo.this.progressTextArea.append(ProgressBarDemo.this.text.substring(ProgressBarDemo.this.textLocation, ProgressBarDemo.this.textLocation + 1));
                    ++ProgressBarDemo.this.textLocation;
                } else if (ProgressBarDemo.this.timer != null) {
                    ProgressBarDemo.this.timer.stop();
                    ProgressBarDemo.this.timer = null;
                    ProgressBarDemo.this.loadAction.setEnabled(true);
                    ProgressBarDemo.this.stopAction.setEnabled(false);
                }
            }
        };
    }

    class MyTextArea
    extends JTextArea {
        public MyTextArea() {
            super(null, 0, 0);
            this.setEditable(false);
            this.setText("");
        }

        public float getAlignmentX() {
            return 0.0f;
        }

        public float getAlignmentY() {
            return 0.0f;
        }
    }
}

