/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager2;

public class BorderLayout
implements LayoutManager2 {
    private int hgap = 0;
    private int vgap = 0;
    private Component north;
    private Component west;
    private Component east;
    private Component south;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";

    public BorderLayout() {
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name == null) {
            name = CENTER;
        }
        if (CENTER.equals(name)) {
            this.center = comp;
        } else if (NORTH.equals(name)) {
            this.north = comp;
        } else if (SOUTH.equals(name)) {
            this.south = comp;
        } else if (EAST.equals(name)) {
            this.east = comp;
        } else if (WEST.equals(name)) {
            this.west = comp;
        } else if ("First".equals(name)) {
            this.firstLine = comp;
        } else if ("Last".equals(name)) {
            this.lastLine = comp;
        } else if ("Before".equals(name)) {
            this.firstItem = comp;
        } else if ("After".equals(name)) {
            this.lastItem = comp;
        } else {
            throw new IllegalArgumentException("unknown constraint: " + name);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.center) {
            this.center = null;
        } else if (comp == this.north) {
            this.north = null;
        } else if (comp == this.south) {
            this.south = null;
        } else if (comp == this.east) {
            this.east = null;
        } else if (comp == this.west) {
            this.west = null;
        }
        if (comp == this.firstLine) {
            this.firstLine = null;
        } else if (comp == this.lastLine) {
            this.lastLine = null;
        } else if (comp == this.firstItem) {
            this.firstItem = null;
        } else if (comp == this.lastItem) {
            this.lastItem = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension d;
        Dimension dim = new Dimension(0, 0);
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        Component c = null;
        c = this.getChild(EAST, ltr);
        if (c != null) {
            d = c.getMinimumSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(WEST, ltr)) != null) {
            d = c.getMinimumSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(CENTER, ltr)) != null) {
            d = c.getMinimumSize();
            dim.width += d.width;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(NORTH, ltr)) != null) {
            d = c.getMinimumSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        if ((c = this.getChild(SOUTH, ltr)) != null) {
            d = c.getMinimumSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension d;
        Dimension dim = new Dimension(0, 0);
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        Component c = null;
        c = this.getChild(EAST, ltr);
        if (c != null) {
            d = c.getPreferredSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(WEST, ltr)) != null) {
            d = c.getPreferredSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(CENTER, ltr)) != null) {
            d = c.getPreferredSize();
            dim.width += d.width;
            dim.height = Math.max(d.height, dim.height);
        }
        if ((c = this.getChild(NORTH, ltr)) != null) {
            d = c.getPreferredSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        if ((c = this.getChild(SOUTH, ltr)) != null) {
            d = c.getPreferredSize();
            dim.width = Math.max(d.width, dim.width);
            dim.height += d.height + this.vgap;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container target) {
        Dimension d;
        Insets insets = target.getInsets();
        int top = insets.top;
        int bottom = target.getHeight() - insets.bottom;
        int left = insets.left;
        int right = target.getWidth() - insets.right;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        Component c = null;
        c = this.getChild(NORTH, ltr);
        if (c != null) {
            c.setSize(right - left, c.getHeight());
            d = c.getPreferredSize();
            c.setBounds(left, top, right - left, d.height);
            top += d.height + this.vgap;
        }
        if ((c = this.getChild(SOUTH, ltr)) != null) {
            c.setSize(right - left, c.getHeight());
            d = c.getPreferredSize();
            c.setBounds(left, bottom - d.height, right - left, d.height);
            bottom -= d.height + this.vgap;
        }
        if ((c = this.getChild(EAST, ltr)) != null) {
            c.setSize(c.getWidth(), bottom - top);
            d = c.getPreferredSize();
            c.setBounds(right - d.width, top, d.width, bottom - top);
            right -= d.width + this.hgap;
        }
        if ((c = this.getChild(WEST, ltr)) != null) {
            c.setSize(c.getWidth(), bottom - top);
            d = c.getPreferredSize();
            c.setBounds(left, top, d.width, bottom - top);
            left += d.width + this.hgap;
        }
        if ((c = this.getChild(CENTER, ltr)) != null) {
            c.setBounds(left, top, right - left, bottom - top);
        }
    }

    private Component getChild(String key, boolean ltr) {
        Component result = null;
        if (key == NORTH) {
            result = this.firstLine != null ? this.firstLine : this.north;
        } else if (key == SOUTH) {
            result = this.lastLine != null ? this.lastLine : this.south;
        } else if (key == WEST) {
            Component component = result = ltr ? this.firstItem : this.lastItem;
            if (result == null) {
                result = this.west;
            }
        } else if (key == EAST) {
            Component component = result = ltr ? this.lastItem : this.firstItem;
            if (result == null) {
                result = this.east;
            }
        } else if (key == CENTER) {
            result = this.center;
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }
}

