/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import swingwtx.swing.Action;
import swingwtx.swing.Icon;
import swingwtx.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private transient ArrayTable arrayTable;
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String name) {
        this.putValue("Name", name);
    }

    public AbstractAction(String name, Icon icon) {
        this(name);
        this.putValue("SmallIcon", icon);
    }

    public Object getValue(String key) {
        if (this.arrayTable == null) {
            return null;
        }
        return this.arrayTable.get(key);
    }

    public void putValue(String key, Object newValue) {
        Object oldValue = null;
        if (this.arrayTable == null) {
            this.arrayTable = new ArrayTable();
        }
        if (this.arrayTable.containsKey(key)) {
            oldValue = this.arrayTable.get(key);
        }
        if (newValue == null) {
            this.arrayTable.remove(key);
        } else {
            this.arrayTable.put(key, newValue);
        }
        this.firePropertyChange(key, oldValue, newValue);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        if (oldValue != newValue) {
            this.enabled = newValue;
            this.firePropertyChange("enabled", new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public Object[] getKeys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] keys = new Object[this.arrayTable.size()];
        this.arrayTable.getKeys(keys);
        return keys;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        AbstractAction newAction = (AbstractAction)super.clone();
        AbstractAction abstractAction = this;
        synchronized (abstractAction) {
            if (this.arrayTable != null) {
                newAction.arrayTable = (ArrayTable)this.arrayTable.clone();
            }
        }
        return newAction;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ArrayTable.writeArrayTable(s, this.arrayTable);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        for (int counter = s.readInt() - 1; counter >= 0; --counter) {
            this.putValue((String)s.readObject(), s.readObject());
        }
    }

    static class ArrayTable
    implements Cloneable {
        private Object table = null;
        private static final int ARRAY_BOUNDARY = 8;

        ArrayTable() {
        }

        public void put(Object key, Object value) {
            if (this.table == null) {
                this.table = new Object[]{key, value};
            } else {
                int size = this.size();
                if (size < 8) {
                    if (this.containsKey(key)) {
                        Object[] tmp = (Object[])this.table;
                        for (int i = 0; i < tmp.length - 1; i += 2) {
                            if (!tmp[i].equals(key)) continue;
                            tmp[i + 1] = value;
                            break;
                        }
                    } else {
                        Object[] array = (Object[])this.table;
                        int i = array.length;
                        Object[] tmp = new Object[i + 2];
                        System.arraycopy(array, 0, tmp, 0, i);
                        tmp[i] = key;
                        tmp[i + 1] = value;
                        this.table = tmp;
                    }
                } else {
                    if (size == 8 && this.isArray()) {
                        this.grow();
                    }
                    ((Hashtable)this.table).put(key, value);
                }
            }
        }

        public Object get(Object key) {
            Object value = null;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] array = (Object[])this.table;
                    for (int i = 0; i < array.length - 1; i += 2) {
                        if (!array[i].equals(key)) continue;
                        value = array[i + 1];
                        break;
                    }
                } else {
                    value = ((Hashtable)this.table).get(key);
                }
            }
            return value;
        }

        public int size() {
            if (this.table == null) {
                return 0;
            }
            int size = this.isArray() ? ((Object[])this.table).length / 2 : ((Hashtable)this.table).size();
            return size;
        }

        public boolean containsKey(Object key) {
            boolean contains = false;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] array = (Object[])this.table;
                    for (int i = 0; i < array.length - 1; i += 2) {
                        if (!array[i].equals(key)) continue;
                        contains = true;
                        break;
                    }
                } else {
                    contains = ((Hashtable)this.table).containsKey(key);
                }
            }
            return contains;
        }

        public Object remove(Object key) {
            Object value = null;
            if (key == null) {
                return null;
            }
            if (this.table != null) {
                if (this.isArray()) {
                    int index = -1;
                    Object[] array = (Object[])this.table;
                    for (int i = array.length - 2; i >= 0; i -= 2) {
                        if (!array[i].equals(key)) continue;
                        index = i;
                        value = array[i + 1];
                        break;
                    }
                    if (index != -1) {
                        Object[] tmp = new Object[array.length - 2];
                        System.arraycopy(array, 0, tmp, 0, index);
                        if (index < tmp.length) {
                            System.arraycopy(array, index + 2, tmp, index, tmp.length - index);
                        }
                        this.table = tmp.length == 0 ? null : tmp;
                    }
                } else {
                    value = ((Hashtable)this.table).remove(key);
                }
                if (this.size() == 7 && !this.isArray()) {
                    this.shrink();
                }
            }
            return value;
        }

        public void clear() {
            this.table = null;
        }

        public Object clone() {
            ArrayTable newArrayTable = new ArrayTable();
            if (this.isArray()) {
                Object[] array = (Object[])this.table;
                for (int i = 0; i < array.length - 1; i += 2) {
                    newArrayTable.put(array[i], array[i + 1]);
                }
            } else {
                Hashtable tmp = (Hashtable)this.table;
                Enumeration keys = tmp.keys();
                while (keys.hasMoreElements()) {
                    Object o = keys.nextElement();
                    newArrayTable.put(o, tmp.get(o));
                }
            }
            return newArrayTable;
        }

        public Object[] getKeys(Object[] keys) {
            if (this.table == null) {
                return null;
            }
            if (this.isArray()) {
                Object[] array = (Object[])this.table;
                if (keys == null) {
                    keys = new Object[array.length / 2];
                }
                int i = 0;
                int index = 0;
                while (i < array.length - 1) {
                    keys[index] = array[i];
                    i += 2;
                    ++index;
                }
            } else {
                Hashtable tmp = (Hashtable)this.table;
                Enumeration e = tmp.keys();
                int counter = tmp.size();
                if (keys == null) {
                    keys = new Object[counter];
                }
                while (counter > 0) {
                    keys[--counter] = e.nextElement();
                }
            }
            return keys;
        }

        private boolean isArray() {
            return this.table instanceof Object[];
        }

        private void grow() {
            Object[] array = (Object[])this.table;
            Hashtable<Object, Object> tmp = new Hashtable<Object, Object>(array.length / 2);
            for (int i = 0; i < array.length; i += 2) {
                tmp.put(array[i], array[i + 1]);
            }
            this.table = tmp;
        }

        private void shrink() {
            Hashtable tmp = (Hashtable)this.table;
            Object[] array = new Object[tmp.size() * 2];
            Enumeration keys = tmp.keys();
            int j = 0;
            while (keys.hasMoreElements()) {
                Object o = keys.nextElement();
                array[j] = o;
                array[j + 1] = tmp.get(o);
                j += 2;
            }
            this.table = array;
        }

        static void writeArrayTable(ObjectOutputStream s, ArrayTable table) throws IOException {
            Object[] keys;
            if (table == null || (keys = table.getKeys(null)) == null) {
                s.writeInt(0);
            } else {
                int counter;
                int validCount = 0;
                for (counter = 0; counter < keys.length; ++counter) {
                    if (keys[counter] instanceof Serializable && table.get(keys[counter]) instanceof Serializable) {
                        ++validCount;
                        continue;
                    }
                    keys[counter] = null;
                }
                s.writeInt(validCount);
                if (validCount > 0) {
                    for (counter = 0; counter < keys.length; ++counter) {
                        if (keys[counter] == null) continue;
                        s.writeObject(keys[counter]);
                        s.writeObject(table.get(keys[counter]));
                        if (--validCount == 0) break;
                    }
                }
            }
        }
    }
}

