/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.io.BufferedReader;
import swingwt.awt.Color;
import swingwt.awt.Component;
import swingwtx.swing.Icon;
import swingwtx.swing.JEditorPane;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.EditorKit;
import swingwtx.swing.text.Element;
import swingwtx.swing.text.MutableAttributeSet;
import swingwtx.swing.text.Style;
import swingwtx.swing.text.StyledDocument;
import swingwtx.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    public JTextPane() {
        this.loadTextEditorPane();
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JTextPane(StyledDocument doc) {
        this();
        this.setStyledDocument(doc);
    }

    public String getUIClassID() {
        return this.getClass().getName();
    }

    public void setDocument(Document doc) {
        if (!(doc instanceof StyledDocument)) {
            throw new IllegalArgumentException("Model must be StyledDocument");
        }
        super.setDocument(doc);
    }

    public void setStyledDocument(StyledDocument doc) {
        super.setDocument(doc);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    public void replaceSelection(String content) {
        this.replaceSelection(content, null);
    }

    private void replaceSelection(String content, AttributeSet attr) {
        this.setText(this.getText() + content);
    }

    public void insertComponent(Component c) {
    }

    public void insertIcon(Icon g) {
    }

    public Style addStyle(String nm, Style parent) {
        StyledDocument doc = this.getStyledDocument();
        return doc.addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        doc.removeStyle(nm);
    }

    public Style getStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        return doc.getStyle(nm);
    }

    public void setLogicalStyle(Style s) {
        StyledDocument doc = this.getStyledDocument();
        doc.setLogicalStyle(this.getCaretPosition(), s);
    }

    public Style getLogicalStyle() {
        StyledDocument doc = this.getStyledDocument();
        return doc.getLogicalStyle(this.getCaretPosition());
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element run = doc.getCharacterElement(this.getCaretPosition());
        if (run != null) {
            return run.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attr, boolean replace) {
        int p1;
        int p0 = this.getSelectionStart();
        if (p0 != (p1 = this.getSelectionEnd())) {
            StyledDocument doc = this.getStyledDocument();
            doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
        } else {
            MutableAttributeSet inputAttributes = this.getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attr);
        }
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element paragraph = doc.getParagraphElement(this.getCaretPosition());
        if (paragraph != null) {
            return paragraph.getAttributes();
        }
        return null;
    }

    public void setParagraphAttributes(AttributeSet attr, boolean replace) {
        int p0 = this.getSelectionStart();
        int p1 = this.getSelectionEnd();
        StyledDocument doc = this.getStyledDocument();
        doc.setParagraphAttributes(p0, p1 - p0, attr, replace);
    }

    public MutableAttributeSet getInputAttributes() {
        return null;
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit kit) {
    }

    public void setDisabledTextColor(Color c) {
    }

    public void read(BufferedReader fileInput, String string) {
        try {
            StringBuffer sb = new StringBuffer();
            String line = fileInput.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = fileInput.readLine();
            }
            this.setText(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

