/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.editorpanes;

import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.JComponent;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.editorpanes.EditorPane;
import swingwtx.swing.event.DocumentEvent;
import swingwtx.swing.event.DocumentListener;
import swingwtx.swing.event.HyperlinkListener;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.DefaultStyledDocument;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.EditorKit;
import swingwtx.swing.text.Formatting;
import swingwtx.swing.text.JTextComponent;
import swingwtx.swing.text.StyleConstants;
import swingwtx.swing.text.StyledEditorKit;

public class TextEditorPane
extends JTextComponent
implements EditorPane,
DocumentListener {
    protected Document doc = null;
    protected Color selectionColor = Color.BLACK;
    protected StyledText ppeer = null;
    protected EditorKit kit = null;
    protected Object retval = null;
    public static TextEditorPane activePane = null;

    public TextEditorPane() {
        activePane = this;
        this.setEditorKit(new StyledEditorKit());
    }

    public void addHyperlinkListener(HyperlinkListener l) {
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
    }

    public Dimension calculatePreferredSize() {
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        return size;
    }

    public int getCaretPosition() {
        int val = 0;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    TextEditorPane.this.retval = new Integer(((StyledText)TextEditorPane.this.getSWTPeer()).getCaretOffset());
                }
            });
        }
        val = (Integer)this.retval;
        return val;
    }

    public String getContentType() {
        return "text/plain";
    }

    public Document getDocument() {
        return this.doc;
    }

    public EditorKit getEditorKit() {
        return this.kit;
    }

    public JComponent getJComponent() {
        return this;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public int getSelectionEnd() {
        return super.getSelectionEnd();
    }

    public int getSelectionStart() {
        return super.getSelectionStart();
    }

    public Control getSWTPeer() {
        return this.ppeer;
    }

    public String getText() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isEditable() {
        return super.isEditable();
    }

    public void setCaretPosition(final int pos) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    ((StyledText)TextEditorPane.this.getSWTPeer()).setCaretOffset(pos);
                }
            });
        }
    }

    public void setContentType(String contentType) {
    }

    public void setDocument(Document newdoc) {
        this.doc = newdoc;
        this.doc.addDocumentListener(this);
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
    }

    public void setEditorKit(EditorKit k) {
        if (this.doc == null) {
            this.setDocument(k.createDefaultDocument());
        }
    }

    public void setPage(URL url) throws IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }

    public void setPage(String url) throws IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }

    public void setText(String text) {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.updatePeerTextFromDocument();
    }

    public void updatePeerTextFromDocument() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)TextEditorPane.this.ppeer)) {
                    TextEditorPane.this.ppeer.setText(TextEditorPane.this.getDocumentText());
                }
            }
        });
    }

    protected String getDocumentText() {
        try {
            String content = this.doc.getText(0, this.doc.getLength());
            return content;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        int swtFlags = 2048;
        swtFlags |= this.pWordWrap ? 64 : 0;
        if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            boolean useHorizontal = false;
            boolean useVertical = false;
            switch (scrollPane.getHorizontalScrollBarPolicy()) {
                case 3: {
                    useHorizontal = true;
                    break;
                }
                case 4: {
                    useHorizontal = true;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    useHorizontal = false;
                }
            }
            switch (scrollPane.getVerticalScrollBarPolicy()) {
                case 0: {
                    useVertical = true;
                    break;
                }
                case 1: {
                    useVertical = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    useVertical = false;
                }
            }
            swtFlags |= useHorizontal ? 256 : 0;
            swtFlags |= useVertical ? 512 : 0;
        }
        this.ppeer = new StyledText(parent.getComposite(), swtFlags);
        this.peer = this.ppeer;
        this.updatePeerTextFromDocument();
        this.applyAllFormattings();
        this.ppeer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int c = e.keyCode;
                char ch = e.character;
                if (c == 0x1000001 || c == 0x1000002 || c == 0x1000003 || c == 0x1000004 || c == 9 || c == 0x1000006 || c == 0x1000005 || c == 0x1000007 || c == 65536 || c == 262144 || c == 131072 || c == 16777298 || c == 0x1000008) {
                    e.doit = true;
                    return;
                }
                if (e.character == '\u007f') {
                    TextEditorPane.this.handleDelete(false);
                    e.doit = false;
                    return;
                }
                if (e.character == '\b') {
                    TextEditorPane.this.handleDelete(true);
                    e.doit = false;
                    return;
                }
                e.doit = false;
                TextEditorPane.this.addKeyStrokeToDocument(e.character);
            }
        });
    }

    protected void addKeyStrokeToDocument(char c) {
        try {
            int pos = this.getCaretPosition();
            this.extendAttributeSetForCaret(pos);
            if (this.getFormattings() != null) {
                for (int i = 0; i < this.getFormattings().size(); ++i) {
                    Formatting f = (Formatting)this.getFormattings().get(i);
                    if (f == null || f.offset <= pos) continue;
                    ++f.offset;
                }
            }
            this.doc.insertString(pos - 1, new String(new char[]{c}), null);
            this.setCaretPosition(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleDelete(boolean backspace) {
        try {
            int pos = this.getCaretPosition();
            if (this.getFormattings() != null) {
                for (int i = 0; i < this.getFormattings().size(); ++i) {
                    Formatting f = (Formatting)this.getFormattings().get(i);
                    if (f == null) continue;
                    if (pos > f.offset && pos < f.offset + f.length) {
                        --f.length;
                    }
                    if (f.offset > this.doc.getLength() - 1) {
                        --f.length;
                    }
                    if (f.offset <= pos) continue;
                    --f.offset;
                }
            }
            this.doc.remove(pos, 1);
            if (backspace) {
                this.setCaretPosition(pos);
            } else {
                this.setCaretPosition(pos);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void extendAttributeSetForCaret(int caret) {
        if (this.getFormattings() == null) {
            return;
        }
        for (int i = 0; i < this.getFormattings().size(); ++i) {
            Formatting f = (Formatting)this.getFormattings().get(i);
            if (f == null || caret <= f.offset || caret >= f.offset + f.length) continue;
            ++f.length;
        }
    }

    public void setFormattingAttributes(final int offset, final int length, final AttributeSet s) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return;
        }
        if (s == null) {
            return;
        }
        if (this.getFormattings() == null) {
            return;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Color fg;
                StyleRange range = new StyleRange();
                range.start = offset;
                range.length = length;
                if (offset > TextEditorPane.this.doc.getLength()) {
                    return;
                }
                if (offset + length > TextEditorPane.this.doc.getLength()) {
                    return;
                }
                Color bg = (Color)s.getAttribute(StyleConstants.ColorConstants.Background);
                if (bg != null) {
                    range.background = bg.getSWTColor();
                }
                if ((fg = (Color)s.getAttribute(StyleConstants.ColorConstants.Foreground)) != null) {
                    range.foreground = fg.getSWTColor();
                }
                int style = 0;
                Boolean bold = (Boolean)s.getAttribute(StyleConstants.FontConstants.Bold);
                Boolean italic = (Boolean)s.getAttribute(StyleConstants.FontConstants.Italic);
                boolean b = false;
                boolean i = false;
                if (bold != null) {
                    b = bold;
                }
                if (italic != null) {
                    i = italic;
                }
                if (b) {
                    ++style;
                }
                if (i) {
                    style += 2;
                }
                range.fontStyle = style;
                try {
                    TextEditorPane.this.ppeer.setStyleRange(range);
                }
                catch (Exception e) {
                    if (TextEditorPane.this.getFormattings() == null) {
                        return;
                    }
                    System.out.println("Failed applying style to: " + offset + ":" + (offset + length));
                    System.out.println("Current formattings in effect:");
                    for (int z = 0; z < TextEditorPane.this.getFormattings().size(); ++z) {
                        Formatting f = (Formatting)TextEditorPane.this.getFormattings().get(z);
                        System.out.println(f.toString());
                    }
                }
            }
        });
    }

    public void applyAllFormattings() {
        this.clearPeerFormatting();
        for (int i = 0; i < this.getFormattings().size(); ++i) {
            Formatting f = (Formatting)this.getFormattings().get(i);
            this.setFormattingAttributes(f.offset, f.length, f.attrs);
        }
    }

    protected void clearPeerFormatting() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)TextEditorPane.this.ppeer)) {
                    TextEditorPane.this.ppeer.setStyleRanges(new StyleRange[0]);
                }
            }
        });
    }

    public Vector getFormattings() {
        if (this.doc instanceof DefaultStyledDocument) {
            return ((DefaultStyledDocument)this.doc).getFormattings();
        }
        return null;
    }

    public void changedUpdate(DocumentEvent e) {
        this.updatePeer();
    }

    public void insertUpdate(DocumentEvent e) {
        if (e.getLength() > 1) {
            this.updatePeer();
        } else {
            this.applyAllFormattings();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (e.getLength() > 1) {
            this.updatePeer();
        } else {
            this.applyAllFormattings();
        }
    }

    protected void updatePeer() {
        this.updatePeerTextFromDocument();
        this.applyAllFormattings();
    }

    public void scrollToReference(String reference) {
    }
}

