/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.text;

import swingwtx.swing.text.AbstractDocument;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Position;
import swingwtx.swing.text.Segment;
import swingwtx.swing.undo.UndoableEdit;

public class StringContent
implements AbstractDocument.Content {
    private StringBuffer s = null;

    public StringContent() {
        this.s = new StringBuffer();
    }

    public StringContent(int initialSize) {
        this.s = new StringBuffer(initialSize);
    }

    public Position createPosition(final int offset) throws BadLocationException {
        return new Position(){

            public int getOffset() {
                return offset;
            }
        };
    }

    public int length() {
        return this.s.length();
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        if (where < 0 || where > this.s.length() + 1) {
            throw new BadLocationException("Out of bounds", where);
        }
        if (where > this.s.length()) {
            this.s.append(str);
        } else {
            this.s.insert(where, str);
        }
        return null;
    }

    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        if (where < 0 || where > this.s.length() || where + nitems > this.s.length()) {
            throw new BadLocationException("Out of bounds", where);
        }
        this.s.replace(where, where + nitems, "");
        return null;
    }

    public String getString(int where, int len) throws BadLocationException {
        if (where < 0 || where > this.s.length() || where + len > this.s.length()) {
            throw new BadLocationException("Out of bounds", where);
        }
        return this.s.toString().substring(where, where + len);
    }

    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        txt.array = this.getString(where, len).toCharArray();
    }

    public String toString() {
        return this.s.toString();
    }
}

