/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    int labelHandle;
    int imageHandle;
    int pageHandle;
    Control control;
    TabFolder parent;
    String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect((int)this.labelHandle, (byte[])OS.mnemonic_activate, (int)this.display.windowProc3, (int)26);
        }
    }

    void register() {
        super.register();
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.pageHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
    }

    void setForegroundColor(GdkColor color) {
        OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
        OS.gtk_widget_modify_fg((int)this.imageHandle, (int)0, (GdkColor)color);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            int pixbuf = imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf((int)this.imageHandle, (int)pixbuf);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf((int)this.imageHandle, (int)0);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show((int)this.labelHandle);
        } else {
            OS.gtk_widget_hide((int)this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

