/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Dialog.java,v $
   Revision 1.16  2005/01/21 08:22:25  bobintetley
   Patch from Andreas Kiebach to add a new JTable implementation with
   a couple of bug fixes to Text components and for Dialogs to immediately
   grab the focus

   Revision 1.15  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.14  2004/11/01 12:16:44  bobintetley
   Fixed JFileChooser drive box bug, Dialog size/display bug and a bug in the
   classpath file for Eclipse editing

   Revision 1.13  2004/09/08 15:28:41  dannaab
   Add ability to override default Dialog trim with:
   public static void setCustomSWTShellStyle(int style)

   Revision 1.12  2004/05/26 13:46:23  bobintetley
   Fixes to new Windowing code to stop non-modal dialogs failling and
      missing cached items

   Revision 1.11  2004/05/26 04:46:06  dannaab
   Changed how Window/Dialog/Frame are initialized.
   Now, the SWT peer's instantiation is delayed until setVisible(true).  This
   has the benefit of allowing Swing's setter methods that can only be set via
   the SWT Shell peer's construction (ie, setResizable(), setModel())

   Revision 1.10  2004/04/19 15:43:25  bobintetley
   Missing (and incorrect) Dialog/JDialog constructors implemented

   Revision 1.9  2004/04/18 20:07:09  bobintetley
   GTK2 repainting bug fixed

   Revision 1.8  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.7  2004/03/31 08:47:49  bobintetley
   Fixed JFileChooser no border bug (fault with JDialog empty constructor)

   Revision 1.6  2004/03/22 15:10:21  bobintetley
   JRootPane and JLayeredPane implementation

   Revision 1.5  2004/03/18 14:42:10  bobintetley
   Fix to Window hierarchy to match Swing, and fix to allow MDI apps
      to work under SWT 2.x

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import swingwtx.swing.*;

import org.eclipse.swt.*;

public class Dialog extends Window {

    protected boolean isModal = true;
    protected boolean isResizable = true;

    public Dialog() { this((Frame) null, "", true); }
    public Dialog(String title) { this((Frame) null, title, true); }
    public Dialog(swingwt.awt.Dialog owner) { this(owner, "", true); }
    public Dialog(swingwt.awt.Dialog owner, boolean modal) { this(owner, "", modal); }
    public Dialog(swingwt.awt.Dialog owner, String title) { this(owner, title, true); }
    public Dialog(swingwt.awt.Dialog owner, String title, boolean modal) { this(owner, title, true, null); }
    public Dialog(swingwt.awt.Dialog owner, String title, boolean modal, GraphicsConfiguration gc) { super(owner, gc); setModal(modal); setTitle(title); }
    public Dialog(Frame owner) { this(owner, "", true); }
    public Dialog(Frame owner, boolean modal) { this(owner, "", modal); }
    public Dialog(Frame owner, String title) { this(owner, title, true); }
    public Dialog(Frame owner, String title, boolean modal) { this(owner, title, modal, null); }
    public Dialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) { super(owner, gc); setModal(modal); setTitle(title); }

    public void setResizable(boolean b) { this.isResizable = b; }
    public boolean isResizable() { return isResizable; }
    public void setModal(boolean b) { isModal = b; }
    public boolean isModal() { return isModal; }
    
    private static int customStyle = 0;
    public static void setCustomSWTShellStyle(int style) {
        customStyle = style;
    }
    
    protected int getSWTFrameType() {
        int SWTFrameType = SWT.DIALOG_TRIM | customStyle;
        SWTFrameType |= isModal ? SWT.APPLICATION_MODAL : SWT.MODELESS;
        SWTFrameType |= isResizable ? SWT.RESIZE : 0;
        return SWTFrameType;
    }

    /** Just an overridable method allowing subclasses to 
     *  execute code immediately after display.
     */
    protected void initDialog() {
        //override to make initial settings for a modal dialog
    }	

    /** Overridden from Window to force private events dispatching for modality */
    public void setVisible(final boolean b) {
        final Dialog me = this;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (b) {
                    if (!SwingWTUtils.isSWTControlAvailable(peer))
                        create();
                    
                    // Display the peer
                    peer.open();

		    // Assign focus
		    peer.setFocus();
                    
                    // Make sure it displays ok
                    repaintFix();
                    
		    // Overridable initial settings
		    initDialog();
		    
                    // If it's a modal dialog, run an event loop
                    // to cause blocking. The nice thing is this works
                    // even if you're called on the existing dispatch thread.
                    if (isModal) dispatchEvents();
                    
                }
                else {
                    // If the Window is already closing because the user hit the x
                    // button, don't do anything
                    if (isClosed) return;
                    if (SwingWTUtils.isSWTControlAvailable(peer))
                        peer.close();
                }
            }
        });
        
    }

}
