/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: MenuShortcut.java,v $
   Revision 1.3  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.2  2004/04/21 07:10:46  bobintetley
   Fixes to native build script and a few code tweaks. Removal of AWT
   native lib for compilation purposes.


 */

package swingwt.awt;

public class MenuShortcut {

    protected int key = 0;
    protected boolean useShiftModifier = false;
    
    public MenuShortcut(int key) {
        this(key, false);
    }
    
    public MenuShortcut(int key, boolean useShiftModifier) {
        this.key = key;
        this.useShiftModifier = useShiftModifier;
    }
    
    public boolean equals(MenuShortcut s) {
        return (s.getKey() == key && useShiftModifier == s.usesShiftModifier());
    }
    
    public boolean usesShiftModifier() { return useShiftModifier; }
    public int getKey() { return key; }
    
}
