/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: Point.java,v $
   Revision 1.4  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.3  2004/01/15 15:20:29  bobintetley
   Java2D work

   Revision 1.2  2004/01/06 08:28:02  bobintetley
   Header fixes

 
 */
package swingwt.awt;

public class Point extends swingwt.awt.geom.Point2D {

    public int x;
    public int y;
    public Point() {
	this(0, 0);
    }
    public Point(Point p) {
	this(p.x, p.y);
    }
    public Point(int x, int y) {
	this.x = x;
	this.y = y;
    }
    public double getX() {
	return x;
    }
    public double getY() {
	return y;
    }
    public Point getLocation() {
	return new Point(x, y);
    }	
    public void setLocation(Point p) {
	setLocation(p.x, p.y);
    }	
    public void setLocation(int x, int y) {
	move(x, y);
    }	
    public void setLocation(double x, double y) {
	this.x = (int) Math.floor(x+0.5);
	this.y = (int) Math.floor(y+0.5);
    }
    public void move(int x, int y) {
	this.x = x;
	this.y = y;
    }	
    public void translate(int dx, int dy) {
	this.x += dx;
	this.y += dy;
    }	
    public boolean equals(Object obj) {
	if (obj instanceof Point) {
	    Point pt = (Point)obj;
	    return (x == pt.x) && (y == pt.y);
	}
	return super.equals(obj);
    }
    public String toString() {
	return getClass().getName() + "[x=" + x + ",y=" + y + "]";
    }
}