/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: PopupMenu.java,v $
   Revision 1.6  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.5  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import swingwtx.swing.JPopupMenu;

public class PopupMenu extends Menu {
    
    public PopupMenu() { swingPeer = new JPopupMenu(); }
    public PopupMenu(String label) { swingPeer = new JPopupMenu(label); }

    private JPopupMenu getSwingPeer() { return (JPopupMenu) swingPeer; }
    
    public void show(Component origin, int x, int y) {
        getSwingPeer().setLocation(x, y);
        getSwingPeer().show();
    }
}
