/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Toolkit.java,v $
   Revision 1.18  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.17  2005/01/05 08:37:11  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.16  2004/10/30 20:11:54  bobintetley
   Code cleanup

   Revision 1.15  2004/08/20 18:04:00  dannaab
   Returns the correct menu mask on OS X

   Revision 1.14  2004/05/05 23:30:45  laurentmartelli
   Added getProperty(String,String) stub

   Revision 1.13  2004/05/05 12:43:19  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.12  2004/05/04 10:06:52  bobintetley
   Fixes to byte[] pixel data - added getModifiers() to ActionEvent

   Revision 1.11  2004/04/29 12:49:26  bobintetley
   Additional JOptionePane constants, missing JTree methods and improved awt.Image support

   Revision 1.10  2004/04/23 10:02:47  bobintetley
   MouseEvent BUTTON_MASK constants, JSlider.createStandardLabels(), FontMetrics
   thread safety, Component/Toolkit.getFontMetrics() and MouseMotionAdapter

   Revision 1.9  2004/03/30 10:42:44  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.8  2004/01/26 14:05:23  bobintetley
   Compatibility methods

   Revision 1.7  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.6  2004/01/16 09:35:46  bobintetley
   Full event dispatch thread support!

   Revision 1.5  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;

import swingwt.awt.datatransfer.Clipboard;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.image.ColorModel;
import swingwt.awt.image.ImageConsumer;
import swingwt.awt.image.ImageProducer;

public class Toolkit {
    
    private static Toolkit toolkit = new Toolkit();
    private static Object retval;
    private static Hashtable desktopProperties = new Hashtable();
    
    protected Toolkit() {}
    
    public static Toolkit getDefaultToolkit() {
        return toolkit;
    }
    
    public static Toolkit getToolkit() {
        return toolkit;
    }
    
    public Image getImage(String filename) {
        return new swingwtx.swing.ImageIcon(filename).getImage();
    }
    
    public Image getImage(URL url) {
        return new swingwtx.swing.ImageIcon(url).getImage();
    }
    
    public int getScreenResolution() {
        return swingwtx.swing.SwingWTUtils.getDisplay().getDepth();
    }
    
    public Insets getScreenInsets(GraphicsConfiguration gc) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit())
            return Toolkit.getDefaultToolkit().getScreenInsets(gc);
        else
            return new Insets(0,0,0,0);
    }
    
    public FontMetrics getFontMetrics(Font f) {
        return new FontMetrics(f);
    }

    private int isMac = 0;
    private boolean isMac() {
        
        if (isMac == 0) {
	        String vers = System.getProperty("os.name").toLowerCase();
	        if (vers.indexOf("mac") != -1)
	            isMac = 1;
	        else
	            isMac = -1;
        }
        
        return (isMac > 0);
    }
    
    public int getMenuShortcutKeyMask() throws HeadlessException {
        if (isMac())
            return KeyEvent.META_MASK;
        else
            return KeyEvent.CTRL_MASK;
    }
    
    public Dimension getScreenSize() {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                retval = new Dimension(
                    swingwtx.swing.SwingWTUtils.getDisplay().getBounds().width, 
                    swingwtx.swing.SwingWTUtils.getDisplay().getBounds().height);
            }
        });
        return (Dimension) retval;
    }
    
    public Image createImage(ImageProducer producer) {
        ToolkitImageConsumer tki = new ToolkitImageConsumer();
        producer.startProduction(tki);
        return tki.awtImage;
        
    }

    public Image createImage(byte[] imagedata) {
	return new swingwtx.swing.ImageIcon(imagedata).getImage();
    }

    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        byte[] im2 = new byte[imagelength];
	for (int i = imageoffset; i < imagelength; i++)
	    im2[i - imageoffset] = imagedata[i];
        return new swingwtx.swing.ImageIcon(im2).getImage();	    
    }
    
    public Image createImage(String filename) {
        return getImage(filename);
    }
    
    public Image createImage(URL url) {
        return getImage(url);    
    }
    
    public Clipboard getSystemClipboard() {
        return new swingwt.awt.datatransfer.Clipboard();
    }
    
    public void beep() {
    }
    
    public final Object getDesktopProperty(String propertyName) {
        return desktopProperties.get(propertyName);
    }
    
    protected final void setDesktopProperty(String propertyName, Object value) {
        desktopProperties.put(propertyName, value);    
    }
    
    /**
     * Used to create images from the pixel data created from
     * an ImageProducer
     * @author Robin Rawson-Tetley
     */
    private class ToolkitImageConsumer implements ImageConsumer {
        
        /** The SwingWT Image to be returned */
        public Image awtImage = new Image();
        public boolean imageComplete = false;
        public void imageComplete(int status) { imageComplete = true; }
        public void setColorModel(ColorModel model) {}        
        public void setDimensions(int width, int height) {
            awtImage.image = new org.eclipse.swt.graphics.Image(swingwtx.swing.SwingWTUtils.getDisplay(), width, height);
        }
        public void setHints(int hintflags) {}
        public void setProperties(java.util.Hashtable props) {}
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            byte[] bytes = new byte[pixels.length];
            for (int i = 0; i < pixels.length; i++)
                bytes[i] = (byte) pixels[i];
            setPixels(x, y, w, h, model, bytes, off, scansize);
        }
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            // Load the pixel data into the image  
            awtImage.image = 
                new org.eclipse.swt.graphics.Image(
                    swingwtx.swing.SwingWTUtils.getDisplay(), 
                    new org.eclipse.swt.graphics.ImageData( w, h, 16, 
                        new org.eclipse.swt.graphics.PaletteData(255, 255, 255)
                        , scansize, pixels));
        }
    }
    
    public static String getProperty(String key,
                                     String defaultValue) {
        return defaultValue;
    }

    public EventQueue getSystemEventQueue() {
        return EventQueue.singleton;
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        // TODO
    }
}
