/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JCoolBar.java,v $
   Revision 1.6  2005/01/05 09:22:29  bobintetley
   Updated copyright year on source

   Revision 1.5  2004/10/30 20:11:56  bobintetley
   Code cleanup

   Revision 1.4  2004/06/08 09:24:22  dannaab
   Rename Component.getPeer() -> getSWTPeer().  added ComponentPeer and stubbed out support classes.

   Revision 1.3  2004/04/28 08:38:06  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.2  2004/01/26 08:10:59  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.1  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.2  2004/01/09 10:33:57  bobintetley
   Changes for JToolBar to allow platform ToolBars, mixed with other components

   Revision 1.1  2003/12/17 17:02:12  bobintetley
   JCoolBar! (Not a real Swing component, but allows you to get at the
   SWT functionality much easier than SWT does!)


*/


package swingwtx.custom;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwtx.swing.*;

/**
 * Not a real Swing component, but since Swing doesn't do them and SWT does, I
 * could hardly leave them out, could I?
 *
 * Just add components to this thing - for each component you add (JToolBar
 * for example), it will get it's own CoolItem drag handle to move it around.
 */
public class JCoolBar extends JComponent {
    
    protected CoolBar ppeer = null;
    protected boolean pFloatable = true;

    public JCoolBar() {}
    
    public Control getSWTPeer() { return ppeer; }
    
    /** 
     *  Overridden from awt.Container so we can create CoolItems
     *  for each added component
     */
    public swingwt.awt.Component add(swingwt.awt.Component c) {
        
        // Do the normal add stuff
        super.add(c);
        
        // For each component we add to the coolbar
        // we need to create a CoolItem and associate it with it.
        // =====
        // This is nasty to get your head round, but if neither component
        // has been created yet, the components will be stored in a buffer
        // by the superclass. It will call down to this version of the
        // add method when the time comes to add the components
        // for real (and the following code becomes active).
        if (SwingWTUtils.isSWTControlAvailable(c.getSWTPeer())) {
            CoolItem cool = new CoolItem(ppeer, SWT.NONE);
            cool.setControl(c.getSWTPeer());
            cool.setMinimumSize(c.getSWTPeer().computeSize(-1, -1));
            cool.setSize(c.getSWTPeer().computeSize(-1, -1));
        }
        
        return c;
    }
    
    public boolean isFloatable() { return pFloatable; }
    public void setFloatable(final boolean b) {
        pFloatable = b;
        if (SwingWTUtils.isSWTControlAvailable(ppeer)) {
            SwingUtilities.invokeSync(new Runnable() {
                public void run() {
                    ppeer.setLocked(!b);   
                }
            });
        }
    }
    
    /** Overridden - layouts are not allowed */
    public void setLayout(swingwt.awt.LayoutManager l) {  }
    public void setLayout(swingwt.awt.LayoutManager2 l) {  }
    
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception { 
        descendantHasPeer = true;
        ppeer = new CoolBar(parent.getComposite(), SWT.BORDER);
        peer = ppeer;
        composite = ppeer;
        this.parent = parent;
        ppeer.setLocked(!pFloatable);
        super.setSwingWTParent(parent);
    }
    
}
