/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JColorChooser.java,v $
   Revision 1.5  2005/01/05 09:22:30  bobintetley
   Updated copyright year on source

   Revision 1.4  2004/06/08 09:24:22  dannaab
   Rename Component.getPeer() -> getSWTPeer().  added ComponentPeer and stubbed out support classes.

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing;

import swingwt.awt.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

/**
 * JColorChooser cannot descend a Swing component in SWT as it is not
 * an embeddable widget. Given time, we could develop one from scratch
 * that behaved the same, but no time at present.
 */
public class JColorChooser {

    protected Color initialColor;
    protected String dialogTitle = "Select Colour";
    
    public JColorChooser() {
        this(Color.white);
    }
    
    public JColorChooser(Color initialColor) {
	this.initialColor = initialColor;
    }
    
    public static Color showDialog(Component component,
        String title, Color initialColor) throws HeadlessException {

        if (initialColor == null) initialColor = Color.white;
        ColorDialog cd = new ColorDialog(component.getSWTPeer().getShell(), SWT.NONE);
        cd.setText(title);
        cd.setRGB(initialColor.getSWTColor().getRGB());
        org.eclipse.swt.graphics.RGB chosenCol = cd.open();
        if (chosenCol == null)
            return null;
        else
            return new swingwt.awt.Color(chosenCol.red, chosenCol.green, chosenCol.blue);

    }
    
}
