/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JProgressBar.java,v $
   Revision 1.19  2005/01/05 09:22:31  bobintetley
   Updated copyright year on source

   Revision 1.18  2004/06/07 15:01:25  bobintetley
   (Daniel Spiewak) JToolbar rollover support, JProgressBar orientation and indeterminate support, plus correct LAF for Win32

   Revision 1.17  2004/04/28 08:38:11  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.16  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.15  2004/01/16 12:35:27  bobintetley
   JProgressBar should be smooth

   Revision 1.14  2003/12/16 17:46:17  bobintetley
   Additional thread safety methods

   Revision 1.13  2003/12/16 14:51:16  bobintetley
   Fixed hang when a window close event closes itself again

   Revision 1.12  2003/12/16 13:14:33  bobintetley
   Use of SwingWTUtils.isSWTControlAvailable instead of null test

   Revision 1.11  2003/12/15 18:57:13  bobintetley
   getValue now thread-safe

   Revision 1.10  2003/12/15 18:54:53  bobintetley
   Threaded accessor methods to prevent SWT problems

   Revision 1.9  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.8  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.7  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

public class JProgressBar extends swingwtx.swing.JComponent implements SwingConstants {

    private ProgressBar ppeer = null;
    private int pMin = 0;
    private int pMax = 0;
    private int pValue = 0;
    private int pOrientation = HORIZONTAL;
    private boolean pIndeterminate = false; // Whether the progress bar actually counts
    
    public JProgressBar() {}
    public JProgressBar(int orient) { pOrientation = orient; }
    public JProgressBar(int min, int max) { pMin = min; pMax = max; }
    public JProgressBar(int orient, int min, int max) { pMin = min; pMax = max; pOrientation = orient; }
    
    public void setMaximum(final int max) {
        SwingUtilities.invokeAsync(new Runnable() {
            public void run() {
                setMaximumT(max); 
            }
        });
    }
    
    public void setMinimum(final int min) {
        SwingUtilities.invokeAsync(new Runnable() {
            public void run() {
                setMinimumT(min); 
            }
        });
    }
    
    public int getOrientation() { return pOrientation; }
    public void setOrientation(int orientation) { pOrientation = orientation; }
    public boolean isIndeterminate() { return pIndeterminate; }
    /** Set to true if you don't want the progress meter to count */
    public void setIndeterminate(boolean b) { pIndeterminate = b; }
    
    public void setValue(final int value) {
        pValue = value;
        SwingUtilities.invokeAsync(new Runnable() {
            public void run() {
                setValueT(value); 
            }
        });
    }
      
    protected void setMaximumT(int max) { if (!SwingWTUtils.isSWTControlAvailable(ppeer)) pMax = max; else ppeer.setMaximum(max); }
    protected void setMinimumT(int min) { if (!SwingWTUtils.isSWTControlAvailable(ppeer)) pMin = min; else ppeer.setMinimum(min); }
    protected void setValueT(int value) { if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.setSelection(value); }
    public int getMaximum() { return pMax; }
    public int getMinimum() { return pMin; }
    public int getValue() { return pValue; }
    public double getPercentComplete() { return ( ((double) (getValue() - getMinimum())) / ((double) (getMaximum() - getMinimum())) * 100); }
    public void setStringPainted(boolean b) { }
    public boolean getStringPainted() { return false; }
    public void setString(String s) {}
    public String getString() { return ""; }
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
   public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
       
	ppeer = new ProgressBar(parent.getComposite(), SWT.BORDER |
	    (pIndeterminate ? SWT.INDETERMINATE : SWT.NONE) |
	    (!SWT.getPlatform().equals("win32") ? SWT.SMOOTH : SWT.NONE) |
	    (pOrientation == HORIZONTAL ? SWT.HORIZONTAL : SWT.VERTICAL));

        ppeer.setMaximum(pMax);
        ppeer.setMinimum(pMin);
        ppeer.setSelection(pValue);

        peer = ppeer;
        this.parent = parent;
    }
    
}
