/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: DefaultTableCellRenderer.java,v $
   Revision 1.6  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.5  2004/09/07 14:18:40  bobintetley
   JScrollPane fixes to Dan's Viewport work, additional compatibility add methods for JMenuBar
   JTable cell rendering fixes - DefaultCellRenderer clears itself prior to use to prevent
   images being rendered across all columns when using the default renderer

   Revision 1.4  2004/03/30 10:42:47  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.3  2004/01/26 08:11:14  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.2  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.table;

import swingwtx.swing.*;
import swingwt.awt.*;

public class DefaultTableCellRenderer extends JLabel implements TableCellRenderer {
    
     public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        setIcon(null);
        setText("");
        setValue(value);
	return this;
    }
     
    protected void setValue(Object value) {
        if (value instanceof Icon)
            setIcon((Icon) value);
        else
            setText( (value == null) ? "" : value.toString() );
    }
    
}
