/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: AttributeSet.java,v $
   Revision 1.3  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.2  2004/04/26 13:36:58  bobintetley
   Additional constants

   Revision 1.1  2004/01/26 08:11:14  bobintetley
   Many bugfixes and addition of SwingSet

 
 */

package swingwtx.swing.text;

import java.util.Enumeration;

public interface AttributeSet {
    
    public static final Object NameAttribute = StyleConstants.NameAttribute;
    public static final Object ResolveAttribute = StyleConstants.ResolveAttribute;
    
    public interface FontAttribute {
    }
    public interface ColorAttribute {
    }
    public interface CharacterAttribute {
    }
    public interface ParagraphAttribute {
    }
    public int getAttributeCount();
    public boolean isDefined(Object attrName);
    public boolean isEqual(AttributeSet attr);
    public AttributeSet copyAttributes();
    public Object getAttribute(Object key);
    public Enumeration getAttributeNames();
    public boolean containsAttribute(Object name, Object value);
    public boolean containsAttributes(AttributeSet attributes);
    public AttributeSet getResolveParent();
}
