/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "frmconfig.h"

frmconfig::frmconfig(QWidget* parent, const char* name, bool modal, WFlags fl)
                : dlgConfig(parent,name, modal,fl)
{
	btnExit->setIconSet(BarIcon("button_cancel"));
	btnSave->setIconSet(BarIcon("button_ok"));
	frmconfig::configureConnection();	//connection to the db
}

frmconfig::~frmconfig()
{
	qDebug("Deleting frmconfig...");	
}

/*$SPECIALIZATION$*/

bool frmconfig::configureConnection()
{
	bool found = false;
	QString filename = QDir::homeDirPath() + "/.swscanner/swscanner.db";
	QFile file (filename);
	db = QSqlDatabase::addDatabase( "QSQLITE" );
	db->setDatabaseName( filename );
	//db->setUserName( USER );
	//db->setPassword( PASSWORD );
	//db->setHostName( HOST );
	
	// If it doesn't exists then create it
	if (!file.exists()) 
	{
		if ( !QDir(QDir::homeDirPath() + "/.swscanner").exists() )
		{
			qDebug("Creating '~/.swscanner' directory for first time...");
			QDir::home().mkdir( ".swscanner" );
		}
		qDebug("Creating database for first time...");
		file.open(IO_ReadWrite);
		file.close();
	}
	
	if( !db->open() )
	{
		db->lastError().showMessage( i18n("An error occured while opening the database:") );
		return false;
	}
	
	QStringList list = db->tables();
	QStringList::Iterator it = list.begin();
	while( it != list.end() ) 
	{
		    cout << "Tables found: ";
		    cout << "    " << *it << endl;
		    if(*it=="networks") found = true;
		    ++it;
	}
	if (!found)
	{
		qDebug("No tables found--> Creating table 'networks'");
		QString sql;
		sql = "CREATE TABLE networks (";
			sql += "'mac' varchar(18) primary key, ";
			sql += "'essid' varchar(256), ";
			sql += "'haswep' int, ";
			sql += "'wepkey' varchar(13), ";
			sql += "'ingroup' int, ";
			sql += "'static' int, ";
			sql += "'ip' varchar(16), ";
			sql += "'netmask' varchar(16), ";
			sql += "'hasgw' int, ";
			sql += "'ipgw' varchar(16), ";
			sql += "'script' varchar(256))";
		
		QSqlQuery query(sql,db);
		if (query.lastError().type() != 0) 
			query.lastError().showMessage();
		qDebug("Adding a test record...");
		sql="INSERT INTO networks (mac, essid, haswep, wepkey, ingroup, static, ip, netmask, hasgw, ipgw, script) ";
		sql+="VALUES ('11:22:33:44:55:66', 'test', 0, NULL, 1,1,'192.189.1.2', ";
		sql+="'255.255.255.0',1,'192.168.1.1',NULL)";
		query = QSqlQuery (sql,db);
		if (query.lastError().type() != 0) 
			query.lastError().showMessage();
	}
	return true;
}
void frmconfig::enableWEP(int e)
{
	if (e==0)
	{
		txtKey->setEnabled(false);
		cmbKeyLength->setEnabled(false);
	}	
	else
	{
		txtKey->setEnabled(true);
		cmbKeyLength->setEnabled(true);
	}
}

void frmconfig::staticSelected(bool sel)
{
	frmDhcp->setChecked(!sel);
}

void frmconfig::dhcpSelected(bool sel)
{
	frmStatic->setChecked(!sel);
}

void frmconfig::keyLengthSel()
{
	int i = cmbKeyLength->currentItem();
	if (i==0)	//64bit
		txtKey->setMaxLength(5);
	else if (i==1)	//128bit
		txtKey->setMaxLength(13);
}

void frmconfig::saveData()
{    
	QString sql;
	QString mac = "'" + lblMAC->text() + "'";
	QString essid = "'" + lblEssid->text() + "'";
	int haswep = chkWEP->isChecked() ? 1 : 0;
	QString wepkey = ((haswep==1)?"'" + txtKey->text() + "'":"NULL");
	int ingroup = chkGrouped->isChecked() ? 1 : 0;
	int staticIP = frmStatic->isChecked() ? 1 : 0;
	QString IP = "'" + txtIP1->text() + "." + txtIP2->text() + "." + txtIP3->text() + "." + txtIP4->text() + "'";
		IP = ((staticIP==1)?IP:"NULL");
	QString Mask = "'" + txtMask1->text() + "." + txtMask2->text() + "." + txtMask3->text() + "." + txtMask4->text() + "'";
		Mask = ((staticIP==1)?Mask:"NULL");
	int hasgw = frmGate->isChecked() ? 1 : 0;
	QString GW = "'" + txtGat1->text() + "." + txtGat2->text() + "." + txtGat3->text() + "." + txtGat4->text() + "'";
		GW = (staticIP==1)?GW:"NULL";
	QString script = (txtScript->text().length()>0) ? "'" + txtScript->text() + "'" : "NULL";
	
	if (btnSave->text()==i18n("&Save"))
	{
		sql="INSERT INTO networks (mac, essid, haswep, wepkey, ingroup, static, ip, netmask, hasgw, ipgw,script) VALUES ";
		sql+="( " + mac + "," + essid + ", " +QVariant(haswep).toString() + ", " + wepkey + ", " ;
		sql+=QVariant(ingroup).toString() + ", " + QVariant(staticIP).toString() + ", " + IP + ", " ;
		sql+=Mask + ", " + QVariant(hasgw).toString() + ", " + GW + ", " + script + " )";
	}
	else
	{
		sql = "UPDATE networks SET ";
		sql += "mac=" + mac + ", ";
		sql += "essid=" + essid + ", ";
		sql += "haswep=" + QVariant(haswep).toString() + ", ";
		sql += "wepkey=" + wepkey + ", ";
		sql += "ingroup=" + QVariant(ingroup).toString() + ", ";
		sql += "static=" + QVariant(staticIP).toString() + ", ";
		sql += "ip=" + IP + ", ";
		sql += "netmask=" + Mask + ", ";
		sql += "hasgw=" + QVariant(hasgw).toString() + ", ";
		sql += "ipgw=" + GW + ", ";
		sql += "script=" + script + " ";
		if (ingroup==1)
			sql += "WHERE essid=" + essid;	
		else
			sql += "WHERE mac=" + mac;
	}
	cout << "Query: " << sql << endl;
	QSqlQuery query(sql,db);
	//query.exec(sql,db);
	if (query.lastError().type() != 0) 
		query.lastError().showMessage();
	else
	{
	/* I use a config file to store dhcpClient instead
		query.exec("UPDATE networks SET essid='" + txtDhcpClient->text() + "' WHERE mac='11:22:33:44:55:66'");
		if (query.lastError().type() != 0) 
			query.lastError().showMessage();
		else */
			QMessageBox::information( this, i18n("SWScanner"),(btnSave->text()==i18n("&Save"))?
			i18n("Configuration successfully saved"):i18n("Configuration successfully updated"));
	}
    	frmconfig::close();
    
}

bool frmconfig::isConfigured(QString essid, QString mac)
{
	if (isGrouped(essid))
		return true;
	else		//need to look for that mac specifically
	{
		QSqlQuery q("SELECT count(*) FROM networks WHERE mac = '" + mac + "'");
		if (q.lastError().type() != 0) 
		{	
			q.lastError().showMessage();
			return false;
		}
		q.first();
		if (q.value(0).toInt() > 0) 
			return true;	//if the mac exist in the db, then it has been already configured
		else
			return false;	//otherwise not
	}
}

void frmconfig::removeConfig(QString essid, QString mac)
{
	QSqlQuery q(QString::null,db);
	if (isGrouped(essid))
		q.exec("DELETE FROM networks WHERE essid='" + essid + "'");
	else
		q.exec("DELETE FROM networks WHERE mac='" + mac + "'");
	
	if (q.lastError().type() != 0) 
		q.lastError().showMessage();
	else
		QMessageBox::information( this, i18n("SWScanner"),i18n("Configuration for '%1' (%2) successfully removed").arg(essid,mac));
}
bool frmconfig::isGrouped(QString essid)
{
	int c=0;
	QSqlQuery q("SELECT essid, mac, ingroup FROM networks WHERE essid='" + essid + "'");
	if (q.lastError().type() != 0) 
	{	
		q.lastError().showMessage();
		return false;
	}
	while ( q.next() ) c++;	//count the records
	if (c==0) return false;
	q.first();
	if (q.value(2).toInt()==1) 	//ingroup==1 -> all mac's with that essid have the same configuration
		return true;		//-> don't mind if there are more records whith that essid	
	else
		return false;
}

void frmconfig::loadConfiguration(QString essid, QString mac)
{
	//char temp [256];
/* I now use a config file to store the dhcp client so next 3 lines are obsolete
	QSqlQuery q("SELECT essid FROM networks WHERE mac='11:22:33:44:55:66'");
	q.first();
	txtDhcpClient->setText(q.value(0).toString());
*/
	//configIni * conf = new configIni;	// obsolete
	SWSconfig * conf = new SWSconfig;
	txtDhcpClient->setText(conf->getDhclient());
	delete conf;
	
	QSqlCursor cur( "networks", db ); 	// Specify the table/view name
	if (isGrouped(essid))	
	{
        	cur.select("essid='" + essid + "'"); 	//query and filter
		if (cur.lastError().type() != 0) 
		{	
			cur.lastError().showMessage();
			return;
		}
	}
	else
	{
        	cur.select("mac='" + essid + "'"); 	//query and filter
		if (cur.lastError().type() != 0) 
		{	
			cur.lastError().showMessage();
			return;
		}
	}
                
       	cur.first();	//There should be only one record		
	lblEssid->setText(essid);
	lblMAC->setText(mac);
	if (cur.value("haswep").toInt() == 1)
	{
		chkWEP->setChecked(true);
		if (cur.value("wepkey").toString().length()==5)
		{
			cmbKeyLength->setCurrentItem(0);
			txtKey->setMaxLength(5);
		}
		else
		{
			cmbKeyLength->setCurrentItem(1);
			txtKey->setMaxLength(13);
		}
		txtKey->setText(cur.value("wepkey").toString());
	}
	else
		chkWEP->setChecked(false);
	if (cur.value("ingroup").toInt()==1)
		chkGrouped->setChecked(true);
	else
		chkGrouped->setChecked(false);
	if (cur.value("static").toInt()==1)
	{
		frmStatic->setChecked(true);
		txtIP1->setText(cur.value("ip").toString().section(".",0,0));
		txtIP2->setText(cur.value("ip").toString().section(".",1,1));
		txtIP3->setText(cur.value("ip").toString().section(".",2,2));
		txtIP4->setText(cur.value("ip").toString().section(".",3,3));
		txtMask1->setText(cur.value("netmask").toString().section(".",0,0));
		txtMask2->setText(cur.value("netmask").toString().section(".",1,1));
		txtMask3->setText(cur.value("netmask").toString().section(".",2,2));
		txtMask4->setText(cur.value("netmask").toString().section(".",3,3));
		if (cur.value("hasgw").toInt()==1)
		{
			frmGate->setChecked(true);
			txtGat1->setText(cur.value("ipgw").toString().section(".",0,0));
			txtGat2->setText(cur.value("ipgw").toString().section(".",1,1));
			txtGat3->setText(cur.value("ipgw").toString().section(".",2,2));
			txtGat4->setText(cur.value("ipgw").toString().section(".",3,3));
		}
		else
			frmGate->setChecked(false);
	}
	else
		frmDhcp->setChecked(true);
	
	txtScript->setText(cur.value("script").toString());
}

void frmconfig::findScript()
{
    QString s = QFileDialog::getOpenFileName(
                    QDir::homeDirPath (),
                    "",
                    this,
                    i18n("Open file dialog"),
                    i18n("Choose a script file to execute after asociating") );
    
    txtScript->setText(s);
}

#include "frmconfig.moc"

