/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "frmconfigini.h"

frmConfigIni::frmConfigIni(QWidget* parent, const char* name, bool modal, WFlags fl)
: frmSettings(parent,name, modal,fl)
{
	int i, databits, stop;
	//char temp [256];
	QString baud, parity;
	
	btnExit->setIconSet(BarIcon("button_cancel"));
	btnSave->setIconSet(BarIcon("button_ok"));
	
	baud = QVariant(conf.getBaud()).toString() + " " + i18n("baud");
	parity = conf.getParity();
	databits = conf.getDataBits();
	stop = conf.getStopBits();

	for (i=0;i < cmbBaud->count();i++)
		if ( cmbBaud->text(i) == baud )
			cmbBaud->setCurrentItem(i);
			
	for (i=0;i < cmbParity->count();i++)
		if ( cmbParity->text(i).left(1) == parity )
			cmbParity->setCurrentItem(i);

	for (i=0;i < cmbBits->count();i++)
		if ( cmbBits->text(i) == QVariant(databits).toString() )
			cmbBits->setCurrentItem(i);
			
	for (i=0;i < cmbStop->count();i++)
		if ( cmbStop->text(i) == QVariant(stop).toString() )
			cmbStop->setCurrentItem(i);	
	
	txtDHCP->setText(conf.getDhclient());
	txtDevice->setText(conf.getSerialDev());
	txtIface->setText(conf.getDefIface());
	txtTerminal->setText(conf.getTerminal());
	
	chkStartup->setChecked (conf.getStartScanning());
	chkTerminal->setChecked (conf.getUseTerminal());
	chkTerminalChanged (chkTerminal->isChecked());
}

frmConfigIni::~frmConfigIni()
{
}

/*$SPECIALIZATION$*/
void frmConfigIni::saveConfig()
{
	if (txtDHCP->text() == "" || txtDevice->text() == "" || txtTerminal->text() == "")
	{
		QMessageBox::information( this, i18n("SWScanner"), i18n("Can't save incomplete data."));
		return;
	}
	
	conf.setBaud(cmbBaud->currentText().left(cmbBaud->currentText().length()-i18n("baud").length()).toInt());
	conf.setDataBits(cmbBits->currentText().toInt());
	conf.setStopBits(cmbStop->currentText().toInt());
	switch(cmbParity->currentItem())
	{
		case 0: conf.setParity("E"); break;
		case 1: conf.setParity("O"); break;
		case 2: conf.setParity("N"); break;
	}
	conf.setDhclient(txtDHCP->text());
	conf.setSerialDev(txtDevice->text());
	conf.setDefIface(txtIface->text());
	conf.setStartScanning(chkStartup->isChecked());
	conf.setUseTerminal(chkTerminal->isChecked());
	conf.setTerminal(txtTerminal->text());
	
	//conf.WriteCFG();
	QMessageBox::information( this, i18n("SWScanner"), i18n("Configuration successfully updated."));
	

}

void frmConfigIni::findDevice()
{
	QString device = QFileDialog::getOpenFileName(
		"/dev",
        	i18n("All files (*)"),
		this,
		i18n("Open file dialog"),
		i18n("Choose your serial device"));
	if (device=="") return;
	txtDevice->setText(device);
}

void frmConfigIni::findDHCP()
{
	QString filename = QFileDialog::getOpenFileName(
		"/",
        	i18n("All files (*)"),
		this,
		i18n("Open file dialog"),
		i18n("Choose your dhcp client binary"));
	if (filename=="") return;
	txtDHCP->setText(filename);
}

void frmConfigIni::findTerminal()
{
	QString filename = QFileDialog::getOpenFileName(
		"/",
        	i18n("All files (*)"),
		this,
		i18n("Open file dialog"),
		i18n("Choose your favorite x-terminal"));
	if (filename=="") return;
	txtTerminal->setText(filename);
}
void frmConfigIni::chkTerminalChanged(bool checked)
{
	if (checked)
	{
		txtTerminal->setEnabled(true);
		btnFindTerminal->setEnabled(true);
	} else 
	{
		txtTerminal->setEnabled(false);
		btnFindTerminal->setEnabled(false);
	}	
}

#include "frmconfigini.moc"

