/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "scanthread.h"

extern APList * plist;

scanThread::scanThread(SWScanner * win, char * ifc)
{
	printf ("Creating scanning thread...\n");
	parentWin = win;
	setIface(ifc);
}


scanThread::~scanThread()
{
	printf ("Deleting scanning thread...\n");
}

void scanThread::run()
{
	char temp[32];
	printf ("Starting a new scan!!\n");
	plist->lock();
		plist->Drop();					// Empty the list
		start_scan( getIface(temp), plist );		// Fills the ap list with new scan data
		scanFinishedEvent* ev = new scanFinishedEvent;
		QApplication::postEvent( parentWin, ev );	// Qt will delete it when done	
		#if	DEBUG_STDOUT
			plist->Display();  			// for debugging only 
		#endif	
		plist->unlock();
	printf ("Scan finished!!\n");
}

void scanThread::setIface(char * i)
{

	mut.lock();
	strcpy(iface,i);
	mut.unlock();
}

char * scanThread::getIface(char * temp)
{
	mut.lock();
	temp = strcpy(temp,iface);
	mut.unlock();
	return temp;
}
