# Utils.py 
#  
#  Copyright (c) 2005 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import os
import statvfs

BUFFER_SIZE = 512
    
def freespace(path):
        s = os.statvfs(path)
        return s[statvfs.F_BFREE] * s[statvfs.F_BSIZE] / 1024

def get_song_size(path):
	# Add a bit more to reserve space for the playlist
	# TODO: This is hardcoded and not correct. Fix!
	return (os.path.getsize(path) / (1024) ) + 100

def freespace_percentage(path):
	s = os.statvfs(path)

        bavail = s[statvfs.F_BLOCKS] * s[statvfs.F_BSIZE] / 1024
	bfree = s[statvfs.F_BFREE] * s[statvfs.F_BSIZE] / 1024
	
	bused = bavail - bfree

	#print "A: %s, F: %s, U: %s, PER: %s" % (bavail, bfree, bused, int(100.0 * bused / bavail) * 0.01) 

	return int(100.0 * bused / bavail) * 0.01;

def unicodify(string):
	string.strip("\x00")

	for codec in ['utf-8', 'latin1']:
		try:
			unicode_string = unicode(string.strip("\x00"), codec)
		except UnicodeDecodeError, e:
			continue
		break
	return unicode_string

def transfer_file(filein, fileout):
	#print "  Copying %s" % (fileout)

	fin = open(filein, "r")
	fout = open(fileout, "w")

	while True:
		buf = fin.read(BUFFER_SIZE)
		if not buf:
			break
		fout.write(buf)

	fin.close()
	fout.close()
