/* === S Y N F I G ========================================================= */
/*!	\file valuenode_scale.h
**	\brief Header file for implementation of the "Scale" valuenode conversion.
**
**	$Id$
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**	Copyright (c) 2007, 2008 Chris Moore
**  Copyright (c) 2011 Carlos López
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === S T A R T =========================================================== */

#ifndef __SYNFIG_VALUENODE_SCALE_H
#define __SYNFIG_VALUENODE_SCALE_H

/* === H E A D E R S ======================================================= */

#include <synfig/valuenode.h>

/* === M A C R O S ========================================================= */

/* === C L A S S E S & S T R U C T S ======================================= */

namespace synfig {

class ValueNode_Scale : public LinkableValueNode
{
public:
	typedef etl::handle<ValueNode_Scale> Handle;
	typedef etl::handle<const ValueNode_Scale> ConstHandle;

private:
	ValueNode::RHandle value_node;
	ValueNode::RHandle scalar;

	ValueNode_Scale(const ValueBase &value);

public:

	//static Handle create(Type &type=type_nil);

	//static Handle create(ValueNode::Handle value_node, Real scalar);

	virtual ~ValueNode_Scale();

	virtual ValueNode::LooseHandle get_link_vfunc(int i)const;

	virtual ValueBase operator()(Time t)const;

	//! Returns the modified Link to match the target value at time t
	ValueBase get_inverse(Time t, const synfig::Vector &target_value) const;
	ValueBase get_inverse(Time t, const synfig::Angle &target_value) const;
	ValueBase get_inverse(Time t, const synfig::Real &target_value) const;

	bool is_invertible(Time t)const;

	virtual String get_name()const;

	virtual String get_local_name()const;

protected:
	virtual bool set_link_vfunc(int i,ValueNode::Handle x);

	virtual LinkableValueNode* create_new()const;

public:
	using synfig::LinkableValueNode::get_link_vfunc;
	using synfig::LinkableValueNode::set_link_vfunc;
	static bool check_type(Type &type);
	static ValueNode_Scale* create(const ValueBase &x);
	virtual Vocab get_children_vocab_vfunc()const;
}; // END of class ValueNode_Scale

}; // END of namespace synfig

/* === E N D =============================================================== */

#endif
