C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                         SUBROUTINE CADTMY                      
C                        *****************                                
C                                                                       
     * (NTSYR_,DT_,DTIMPO,NPREM,NPOINS,TMPSA,TMPS)      
C                                                                       
C                                                                       
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                       
C            SOUS-PROGRAMME PRINCIPAL DE SYRTHES
C           
C-----------------------------------------------------------------------
C                             ARGUMENTS                                 
C .________________.____.______________________________________________.
C !      NOM       !MODE!                   ROLE                       !
C !________________!____!______________________________________________!
C .________________.____.______________________________________________.
C                             COMMONS                                   
C .________________.____.______________________________________________.
C !                !    ! TOUS LES COMMONS SONT PRESENTS ICI           !
C !________________!____!______________________________________________!
C  MODE:-->ENTREE,<--RESULTAT,<-->DONNEE MODIFIEE,--TABLEAU DE TRAVAIL  
C-----------------------------------------------------------------------
C     - SOUS PROGRAMME(S) APPELANT(S) :                         
C     - SOUS PROGRAMME(S) APPELE(S)   :     
C***********************************************************************
C                                                                       
      IMPLICIT NONE                                     
C                                                                       
C***********************************************************************
C                                                                       
#include "nlofes.h"  
#include "optct.h"  
#include "divct.h"  
C                           
C***********************************************************************
C
      INTEGER NTSYR_,NPOINS,NPREM
      DOUBLE PRECISION DT_,DTIMPO,TMPSA(NPOINS),TMPS(NPOINS)
C
      INTEGER I,NUM
      DOUBLE PRECISION DD,DTM
C                            
C***********************************************************************
C
C     Pas de temps impose en dur 
C     (soit un pas de temps qui vient du fluide, soit si on veut ecraser
C      le pas de temps calcule normalement)
      IF (DTIMPO.GT.0) THEN
        RDTTS=DTIMPO
        DT_=DTIMPO
C
C
C     Pas de temps multiples
      ELSEIF (NDTMUL.GT.0) THEN
C
        IF (NTSYR_.LE.IDTMUL(1)) THEN
          NUM=1
        ELSEIF (NTSYR_.GT.IDTMUL(NDTMUL)) THEN
          NUM=NDTMUL
        ELSE
          DO I=1,NDTMUL-1
            IF (IDTMUL(I).LT.NTSYR_ .AND. NTSYR_.LE.IDTMUL(I+1)) NUM=I+1
          ENDDO
        ENDIF
C
        RDTTS=XDTMUL(NUM)
        DT_=XDTMUL(NUM)
C
C
C     Pas de temps automatique
      ELSEIF (DTAUTO.GT.0) THEN
        IF (NPREM.EQ.1) THEN
          DT_=RDTTS 
        ELSE
          DTM=0
          DO I=1,NPOINS
            DD=ABS(TMPSA(I)-TMPS(I))
            IF (DD.GT.DTM) DTM=DD
          ENDDO
          DD=RDTTS*DTAUTO/DTM
          IF (DD.GT.DTAUTM) DD=DTAUTM
          RDTTS=DD
          DT_=DD
          
        ENDIF     
      ENDIF
C
C
C     si le pas de temps impose est negatif, on retourne
C     le pas de temps calcule par SYRTHES
      IF (DTIMPO.LT.0) THEN
        DTIMPO=RDTTS
      ENDIF
C
C
C--------
C FORMATS
C--------
C                                                     
      END                                                               


