C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CHFORM,SSI=0
C
                        SUBROUTINE CHFORM
C                       *****************
C
     * (CTYP,CH,LCH,NB,FORMA)
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
C**********************************************************************
C
C..Variables externes
      CHARACTER*1 CTYP
      CHARACTER CH*(*),FORMA*(*)
      INTEGER NB,LCH
C
C..Variables internes
      INTEGER IDEB,IFIN,NBB,LC,I1,N,ILF,ILONF,NBCHI,I
      INTEGER NBCHI1,NBCHI2
      CHARACTER FF*80,CLC*3,CLC1*3,CLC2*3
C
      CHARACTER CNBRE*80,CF*1
      INTEGER IPOINT,IFDECI,LDECI
      LOGICAL FORMAE
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      FORMA = '('
      ILONF = 1
      I1 = 1
C
C     1- CAS DU DECRYPTAGE D'ENTIERS
C     ==============================
C
      IF (CTYP.EQ.'I') THEN
C
C
        DO 100 N=1,NB
C
          CALL POSNBR (CH(I1:),IDEB,IFIN,NBB,LC)
          FF = ' '
          NBCHI =  3 - INT ( LOG10 (DBLE(LC)) ) 
          WRITE ( CLC,'(I3)' ) LC

          IF (NBB.EQ.0) THEN
            WRITE(FF(1:),1000) CLC(NBCHI:3)
            ILF = 3-NBCHI+1 + 1
          ELSE
            WRITE(FF(1:),1001) NBB,CLC(NBCHI:3)
            ILF = 3-NBCHI+1 + 1 + 4
          ENDIF
C
          IF (N.EQ.1) THEN
            FORMA = FORMA(1:ILONF)//FF(1:ILF)
            ILONF = ILONF+ILF
          ELSE
            FORMA = FORMA(1:ILONF)//','//FF(1:ILF)
            ILONF = ILONF+ILF + 1
          ENDIF
C
          I1 = I1 + IFIN 
C
  100    CONTINUE
C   
         FORMA = FORMA(1:ILONF)//')'
C
C
C
C     2- CAS DU DECRYPTAGE DE REELS
C     =============================
      ELSEIF (CTYP.EQ.'R') THEN
C
        DO 200 N=1,NB
C
          CALL POSNBR (CH(I1:),IDEB,IFIN,NBB,LC)
          CNBRE(1:LC) = CH(I1+IDEB-1:I1+IFIN-1)
C
          FORMAE = .FALSE.
          IPOINT = LC
          IFDECI = LC
C
          DO 210 I=1,LC
            IF (CNBRE(I:I).EQ.'.') THEN
              IPOINT = I
            ELSE IF (CNBRE(I:I).EQ.'E') THEN
              FORMAE = .TRUE.
              IFDECI = I-1
            ENDIF
  210     CONTINUE
C
          IF (FORMAE) THEN
            CF = 'E'
          ELSE
            CF = 'F'
          ENDIF
C
          NBCHI1 =  3 - INT ( LOG10 (DBLE(LC)) ) 
          WRITE ( CLC1,'(I3)' ) LC
C

          LDECI = IFDECI - IPOINT
          NBCHI2 = 3
          IF (LDECI.GT.0) NBCHI2 = 3 - INT ( LOG10 (DBLE(LDECI)) ) 
          WRITE ( CLC2,'(I3)' ) LDECI
C
          IF (NBB.EQ.0) THEN
            WRITE(FF(1:),2000) CF,CLC1(NBCHI1:3),CLC2(NBCHI2:3)
            ILF = 3-NBCHI1+1 + 3-NBCHI2+1 +2
          ELSE
            WRITE(FF(1:),2001) NBB,CF,CLC1(NBCHI1:3),CLC2(NBCHI2:3)
            ILF = 3-NBCHI1+1 +3-NBCHI2+1 +2 + 4
          ENDIF
C
          IF (N.EQ.1) THEN
            FORMA = FORMA(1:ILONF)//FF(1:ILF)
            ILONF = ILONF+ILF
          ELSE
            FORMA = FORMA(1:ILONF)//','//FF(1:ILF)
            ILONF = ILONF+ILF + 1
          ENDIF
C
          I1 = I1 + IFIN 
C
  200 CONTINUE  
C
         FORMA = FORMA(1:ILONF)//')'
C
      ENDIF
C---------
C FORMATS
C---------
 1000 FORMAT ('I',A)
 1001 FORMAT (I2,'X,I',A)
 2000 FORMAT (A1,A,'.',A)
 2001 FORMAT (I2,'X,',A1,A,'.',A)
C----
C FIN
C----
C
      RETURN
      END
