C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CONTOU,SSI=0
C
                        SUBROUTINE CONTOU
C                       *****************
C    ------------------
     *(XI,YI,ZI,FFORME)
C    ------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   Calcul de facteur de forme (methode PENIGUEL/RUPP)      *
C              Application a des triangles                             *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !   XI   !  TR  !  D ! Coordonnees X des 6 points des 2 triangles  !
C   !        !      !    ! (dans l'ordre xa,xb,xc,   xd,xe,xf)         !
C   !   YI   !  TR  !  D ! Coordonnees Y des 6 points des 2 triangles  !
C   !   ZI   !  TR  !  D ! Coordonnees Z des 6 points des 2 triangles  !
C   ! FFORME !   R  !  R ! Facteur de forme resultat
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "optct.h" 
C
C**********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION XI(6),YI(6),ZI(6),FFORME
C
C.. Variables locales
      INTEGER N,M,N2,M1,M2,ITYP
      DOUBLE PRECISION XAB,YAB,ZAB,XCD,YCD,ZCD,XAC,YAC,ZAC,AB,CD
      DOUBLE PRECISION XAD,YAD,ZAD,XBC,YBC,ZBC,XBD,YBD,ZBD,AC,AD,BC,BD
      DOUBLE PRECISION A,B,C,PABAC
      DOUBLE PRECISION COST,VALINT,PI
      DOUBLE PRECISION EPS
C
C**********************************************************************
C
C     1- INITIALISATION
C     =================
      FFORME = 0.
      PI = 3.141592653589793
      EPS = 1.E-6
C
C
C     2- BOUCLE SUR LES SEGMENTS 
C     ==========================
C
      DO 100 N=1,3
        DO 100 M=1,3
C
C         1.1 Initialisations
C         -------------------
          N2 = MOD(N,3) + 1
          M2 = 3+MOD(M,3) + 1
          M1 = M+3
C
C         1.2- Normes et cos entre les segments
C         -------------------------------------
C
          XAB = XI(N2)-XI(N)
          YAB = YI(N2)-YI(N)
          ZAB = ZI(N2)-ZI(N)
          XCD = XI(M2) - XI(M1)
          YCD = YI(M2) - YI(M1)
          ZCD = ZI(M2) - ZI(M1)
C
          AB = SQRT(XAB*XAB + YAB*YAB + ZAB*ZAB)
          CD = SQRT(XCD*XCD + YCD*YCD + ZCD*ZCD)
C
          COST = (XAB*XCD + YAB*YCD + ZAB*ZCD) / (AB*CD)
C
C         1.3 Orthogonalite des vecteurs
C         ------------------------------
          IF (ABS(COST).LE.EPS) THEN
            VALINT = 0.
C
          ELSE
            XAD = XI(M2) - XI(N)
            YAD = YI(M2) - YI(N)
            ZAD = ZI(M2) - ZI(N)
            XBC = XI(M1)- XI(N2)
            YBC = YI(M1)- YI(N2)
            ZBC = ZI(M1)- ZI(N2)
            XAC = XI(M1)- XI(N)
            YAC = YI(M1)- YI(N)
            ZAC = ZI(M1)- ZI(N)
            XBD = XI(M2)- XI(N2)
            YBD = YI(M2)- YI(N2)
            ZBD = ZI(M2)- ZI(N2)
C
C
            AD = SQRT(XAD*XAD + YAD*YAD + ZAD*ZAD)
            BC = SQRT(XBC*XBC + YBC*YBC + ZBC*ZBC)
            AC = SQRT(XAC*XAC + YAC*YAC + ZAC*ZAC)
            BD = SQRT(XBD*XBD + YBD*YBD + ZBD*ZBD)
C
C
C           1.4 Cas general
C           ---------------
            IF (AD.GT.EPS .AND. BC.GT.EPS .AND.
     *           AC.GT.EPS .AND. BD.GT.EPS  ) THEN
	      PABAC = (XAB*XAC + YAB*YAC + ZAB*ZAC)/(AB*AC)
chris modif par chris le 27 08 97 (en toute rigueur a verifier)
chris         IF (ABS(COST).LE.0.9999 .OR. ABS(PABAC).LE.0.9999) THEN
chris2        IF (ABS(COST).LE.1-eps .OR. ABS(PABAC).LE.1.) THEN
              IF (ABS(COST).LE.1-eps .OR. ABS(PABAC).LT.1.-eps) THEN
                CALL INTSEG(XAB,YAB,ZAB,XAC,YAC,ZAC,XCD,YCD,ZCD,VALINT)
	      ELSE
		A = AB
                B = CD
                C = AC
chris   reblinder en log le 22 janv 1999
chris   le cas ne devrait pas
chris   arrive mais peut avoir pour origine 
chris   une erreur de precision sur intersection de decoupage
chris   pas tres grande importance liee a la decroissance du log

		IF (COST .GT. EPS .AND. PABAC .GT. EPS ) THEN
                   VALINT = -3. +
     *                     ( -(-A+B+C)**2 * LOG(abs(-A+B+C)) 
     *	                    +(C-A)**2    * LOG(abs(C-A))
     *			    - C**2       * LOG(C)
     *			    +(C+B)**2    * LOG(C+B) )/ (A*B)
	        ELSEIF ( COST .GT. EPS .AND. PABAC .LE. -EPS ) THEN
                   VALINT = -3. +
     *			  (-(C-B+A)**2 * LOG(abs(C-B+A))
     *		           +(C-B)**2   * LOG(abs(C-B))
     *                     +(C+A)**2   * LOG(A+C)
     *                     - C**2       * LOG(C)    )/ (A*B)
	        ELSEIF ( COST .LE. -EPS .AND. PABAC .GE. EPS ) THEN
                   VALINT = -3. +
     *			 ( (-A-B+C)**2 * LOG(abs(C-B-A))
     *                    -(C-B)**2    * LOG(abs(C-B))
     *                    -(C-A)**2    * LOG(abs(C-A))
     *                    + C**2       * LOG(C)    )/(A*B)
	        ELSEIF ( COST .LE. -EPS .AND. PABAC .LE. -EPS ) THEN
                   VALINT = -3. +
     *			( (A+B+C)**2 * LOG(A+B+C)
     *			 -(B+C)**2   * LOG(B+C)
     *                   -(C+A)**2   * LOG(C+A)
     *			 + C**2      * LOG(C)      )/(A*B)
                ELSE
                   WRITE(NFECRA,*) 
     *                ' Ce cas ne devrait jamais intervenir '
                   WRITE(NFECRA,*) 
     *                ' Voir les concepteurs de Syrthes CP-IR'
                ENDIF
 	      ENDIF
C
C           1.5 Cas singuliers 
C           ------------------
            ELSEIF (AD .LE. EPS) THEN
               IF (ABS(COST) .GE. 1.-EPS*0.001) THEN
                   IF ( ABS (AB-CD) .LT. EPS ) THEN 
                     IF (COST.LT. 0.) THEN
                        VALINT = 2.*LOG(AB) - 3.
                     ELSE
                        VALINT = 2.*LOG(AB) -3. +4*LOG(2*AB)
                     ENDIF
                   ELSE
                     IF (COST .LT. 0.) THEN
                        VALINT = - 3. +
     *                          ( AB*AB*LOG(AB) + CD*CD*LOG(CD) -
     *                            (AB-CD)*(AB-CD)*LOG(ABS(CD-AB)) )
     *                            /(AB*CD)
                     ELSE
                        VALINT = - 3. +
     *                          ( - AB*AB*LOG(AB) - CD*CD*LOG(CD) +
     *                           (AB+CD)*(AB+CD)*LOG(AB+CD) )
     *                            /(AB*CD)
                     ENDIF
                   ENDIF
C
               ELSE
                 ITYP = 1
                 A = AB*AB
                 B = 2.*(XAB*XAC + YAB*YAC + ZAB*ZAC)
                 C = AC*AC
                 CALL INT2EG(A,B,C,ITYP,VALINT)
               ENDIF
C
            ELSEIF (BC .LE. EPS) THEN
               IF (ABS(COST) .GE. 1.-EPS*0.001) THEN
                 IF (ABS(AB-CD) .LE. EPS) THEN
                   IF (COST.LT. 0.) THEN
                      print*,' Ce cas aurait deja du etre traite'
                      VALINT = 2.*LOG(AB) - 3.
                   ELSE
                      VALINT = -2.*LOG(AB) -3. +4*LOG(2*AB)
                   ENDIF
                 ELSE
                   IF (COST.LT.0.) THEN
                     VALINT = - 3. +
     *                       ( CD*CD*LOG(CD) + AB*AB*LOG(AB) -
     *                         (AB-CD)*(AB-CD)*LOG(ABS(AB-CD)) )
     *                        /(AB*CD)
                   ELSE
                     VALINT = - 3. +
     *                       (-CD*CD*LOG(CD) - AB*AB*LOG(AB) +
     *                         (AB+CD)*(AB+CD)*LOG(AB+CD) )
     *                        /(AB*CD)
                   ENDIF
                 ENDIF
               ELSE
                 A = CD*CD
                 B = -2.*(XAB*XCD + YAB*YCD + ZAB*ZCD)
                 C = AB*AB
                 ITYP = 1
                 CALL INT2EG(A,B,C,ITYP,VALINT)
               ENDIF
C
C
            ELSEIF (AC .LE. EPS) THEN
               IF (ABS(COST) .GE. 1.-EPS*0.001) THEN
                 IF (ABS(AB-CD) .LE. EPS) THEN
                   IF (COST.LT. 0.) THEN
                      VALINT = -2.*LOG(AB) -3. + 4*LOG(2*AB)
                   ELSE
                      VALINT = 2.*LOG(AB) - 3.
                   ENDIF
                 ELSE
                   IF (COST.GT.0.) THEN
                      VALINT = -3. +
     *                         ( CD*CD*LOG(CD) + AB*AB*LOG(AB) -
     *                          (AB-CD)*(AB-CD)*LOG(ABS(CD-AB)) )
     *                          / (AB*CD)
                   ELSE
                      VALINT = -3. +
     *                         (-AB*AB*LOG(AB) -CD*CD*LOG(CD) +
     *                          (AB+CD)*(AB+CD)*LOG(AB+CD) )
     *                         / (AB*CD)
                   ENDIF
                 ENDIF
C
               ELSE
                 A = AB*AB
                 B = -2.*(XAB*XAD + YAB*YAD + ZAB*ZAD)
                 C = AD*AD
                 ITYP = 2
                 CALL INT2EG(A,B,C,ITYP,VALINT)
               ENDIF
C
            ELSEIF (BD .LE. EPS) THEN
               IF (ABS(COST) .GE. 1.-EPS*.001) THEN
                 IF (ABS(AB-CD) .LE. EPS) THEN
                   IF (COST.LT. 0.) THEN
                      VALINT = -2.*LOG(AB) -3. + 4*LOG(2*AB)
                   ELSE
                      print*,' Ce cas est a priori deja traite'
                      VALINT = 2.*LOG(AB) - 3.
                   ENDIF
                 ELSE
                   IF (COST.GT.0.) THEN
                      VALINT = - 3. +
     *                        ( AB*AB*LOG(AB) + CD*CD*LOG(CD) -
     *                         (AB-CD)*(AB-CD)*LOG(ABS(AB-CD))  )
     *                        / (AB*CD)                
                   ELSE
                      VALINT = - 3. +
     *                        ( -AB*AB*LOG(AB) - CD*CD*LOG(CD) +
     *                         (AB+CD)*(AB+CD)*LOG(AB+CD)  )
     *                        / (AB*CD)                
                   ENDIF
                 ENDIF
C
               ELSE
                 ITYP = 3
                 A = AB*AB
                 B = 2.*(XAB*XBC + YAB*YBC + ZAB*ZBC)
                 C = BC*BC
                 CALL INT2EG(A,B,C,ITYP,VALINT)
               ENDIF
C
C           1.6- Erreur
C           -----------
            ELSE
              WRITE(NFECRA,1600)
              STOP
            ENDIF
C
C           1.7- Mise  a jour de la valeur de l'integrale
C           ---------------------------------------------
          ENDIF
            FFORME = FFORME + 0.5 * COST * AB * CD * VALINT
C
  100 CONTINUE
C
C     3- VALEUR DU FACTEUR DE FORME * SURFACE
C     =======================================
C
      FFORME = FFORME / (2.*PI)
C
C     4- IMPRESSIONS DE CONTROLE
C     ==========================
C
C--------
C FORMATS
C--------
 1600 FORMAT('%% ERREUR CONTOU : on n''est dans aucun cas prevu !')
 4000 FORMAT('>>> CONTOU : Facteur de forme = ',E16.9)
C----
C FIN
C----
C
      END
