/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"

#define N64 128

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | coroct                                                               |
  |         Gestion du calcul des correspondants en dimension 3          |
  |======================================================================| */

proc(void coroct,void COROCT) (int *ndim,int *npoins,int *neless,int *ndmass,int *nelesf,
		     int *ndmasf,int *nbcous,int *nbcouf,double *coords,
		     int *nodess,double *coordf,int *nodesf,double *baryf,
		     int *ncborf,double *barys,int *ncbors,int *ncoups,
		     int *nbicor,int *nblbla,double *d2maxf,double *dmax_util,
		     double *trav1, double *trav2)
{

  int i,n,npf,nps,ng,nlonv,nbcouf2,nbcous2,npoins2,neless2,nelesf2,num;
  int nelmin,n1min,n2min,n3min,n4min,n5min,n6min,numtri,nm,npfpb,npspb;
  int ntabel[N64],na[N64],nb[N64],nc[N64],icode[N64],lco[N64];
  double xa[N64],xb[N64],xc[N64],ya[N64],yb[N64],yc[N64];
  double za[N64],zb[N64],zc[N64];
  int n1,n2,n3,n4,n5,n6,nonc,nb_passage;
  int *nodessg,nbhisto,*thisto;
  double vmin,interv;
  double x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,x5,y5,z5,x6,y6,z6;
  double dim_boite[6],xp1,yp1,zp1,dm,xm,ym,zm,dmin,xmin,ymin,zmin;
  double b1,b2,b3,size_min,dist_max,*distance,dist_moy,dist_var;
  struct element *fa;
  struct node *arbre,*noeud;

  nonc=0;
  for (n=0;n<*nbcouf* *ndim;n++) baryf[n]=0;
  for (n=0;n<*nbcous* *ndim;n++) barys[n]=0;
  nbcouf2=*nbcouf*2;  nbcous2=*nbcous*2;  npoins2=*npoins*2;
  neless2=*neless*2;  nelesf2=*nelesf*2;
  
 
  boite2(*ndim,*npoins,coords,*nbcouf,coordf,dim_boite);

  size_min = 1.E8;
  arbre= (struct node *)malloc(sizeof(struct node));
  if (arbre==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}

  nodessg= (int *)malloc(*neless* *ndmass * sizeof(int));
  if (nodessg==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}
  for (nps=0 ; nps < *neless* *ndmass ; nps++ ) nodessg[nps]=ncoups[nodess[nps]-1];
  build_octree (arbre,*ndim,*npoins,*neless,nodessg,coords,&size_min,dim_boite);
  free(nodessg);

  /* affiche_tree(arbre,8); */


  printf("\n *** COROCT : Calcul des correspondants des noeuds fluides  \n"); 

  dist_max=0; dist_moy=0; dist_var=0; npfpb=0;
  distance= (double *)malloc(*nbcouf*sizeof(double));
  if (distance==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}

    for (npf=0 ; npf < *nbcouf ; npf++ ) trav1[npf]=0;

    for (npf=0 ; npf < *nbcouf ; npf++ ) 
  /*--------------------------------*/
    {
      dmin=1.e6; xmin=ymin=zmin=0;
      nelmin=1; n1min=n2min=n3min=n4min=n5min=0;
      nm=1; xm=ym=zm=0; dm=1.e6;

      xp1=coordf[npf]; yp1=coordf[npf+ *nbcouf]; zp1=coordf[npf+nbcouf2];
      noeud=arbre;
      find_node_3d (&noeud,xp1,yp1,zp1); 

      fa = noeud->lelement;
      if (fa==NULL) {noeud=arbre;fa = noeud->lelement;}

      nb_passage=1;

    onrecommence:

      while (fa != NULL)
	{
	  nlonv=0;
	  while (fa!=NULL && nlonv<N64) {ntabel[nlonv]=fa->num;nlonv+=1;fa=fa->suivant;}
	  for (i=0;i<nlonv;i++)
	    {
              icode[i]=0; lco[i]=1; num=ntabel[i];
              na[i] = nodess[num-1];
              nb[i] = nodess[num-1+ *neless];
              nc[i] = nodess[num-1+ neless2];

             if (ncbors[na[i]-1]==-1 || ncbors[nb[i]-1]==-1 ||ncbors[nc[i]-1]==-1) 
               {lco[i]=0; continue;}

             na[i]=ncoups[na[i]-1]; nb[i]=ncoups[nb[i]-1]; nc[i]=ncoups[nc[i]-1];
             xa[i]=coords[na[i]-1];
             ya[i]=coords[na[i]-1+ *npoins];
             za[i]=coords[na[i]-1+ npoins2];
             xb[i]=coords[nb[i]-1];
             yb[i]=coords[nb[i]-1+ *npoins];
             zb[i]=coords[nb[i]-1+ npoins2];
             xc[i]=coords[nc[i]-1];
             yc[i]=coords[nc[i]-1+ *npoins];
             zc[i]=coords[nc[i]-1+ npoins2];
            }

	  cal_dmin(xp1,yp1,zp1,xa,ya,za,xb,yb,zb,xc,yc,zc,nlonv,&dm,&xm,&ym,&zm,&nm,lco,icode);
	  
	  for (i=0;i<nlonv;i++)
	    if (icode[i]!=0) 
	      {
		printf("\n %%%% ERREUR  COROCT : LA RECHERCHE DU CORRESPONDANT A ECHOUE\n");
		printf("                       POINT FLUIDE : %d\n",npf+1);
		printf("                                      %10.3f %10.3f %10.3f\n",xp1,yp1,zp1);
		printf("            DANS LE TRIANGLE SOLIDE : %d\n",ntabel[i]);
		printf("                                      %d %d %d\n",na[i],nb[i],nc[i]);
		exit(0);
	      }
	  
	  if (dm<dmin) {dmin=dm; xmin=xm; ymin=ym;zmin=zm; nelmin=ntabel[nm];}
	}

      if (dmin>*dmax_util && nb_passage==1)
	{
	  noeud=arbre;
	  fa = noeud->lelement;
	  nb_passage++;
	  goto onrecommence;
	}
      else if (dmin>99999. && nb_passage>1)
	{
	  printf("       Pas de correspondant, noeud fluide %d de coord %f %f %f\n",npf+1,xp1,yp1,zp1);
	  npfpb++;
	  continue;
	}

      if (dmin>dist_max) dist_max=dmin;
      trav1[npf]=dmin;
      n1min=nodess[nelmin-1]; n2min=nodess[nelmin-1+ *neless]; 
      n3min=nodess[nelmin-1+ *neless*2]; n4min=nodess[nelmin-1+ *neless*3]; 
      n5min=nodess[nelmin-1+ *neless*4]; n6min=nodess[nelmin-1+ *neless*5];

      n1=ncoups[n1min-1];
      x1=coords[n1-1];  y1=coords[n1-1+ *npoins]; z1=coords[n1-1 +npoins2]; 
      n2=ncoups[n2min-1];
      x2=coords[n2-1];  y2=coords[n2-1+ *npoins]; z2=coords[n2-1 +npoins2]; 
      n3=ncoups[n3min-1];
      x3=coords[n3-1];  y3=coords[n3-1+ *npoins]; z3=coords[n3-1 +npoins2]; 
      n4=ncoups[n4min-1];
      x4=coords[n4-1];  y4=coords[n4-1+ *npoins]; z4=coords[n4-1 +npoins2]; 
      n5=ncoups[n5min-1];
      x5=coords[n5-1];  y5=coords[n5-1+ *npoins]; z5=coords[n5-1 +npoins2]; 
      n6=ncoups[n6min-1];
      x6=coords[n6-1];  y6=coords[n6-1+ *npoins]; z6=coords[n6-1 +npoins2]; 

      proc(soutri,SOUTRI)(xmin,ymin,zmin, x4,y4,z4, x5,y5,z5, x6,y6,z6, &numtri);

      if (numtri==1)      bary3d (xmin,ymin,zmin,x1,y1,z1, x4,y4,z4, x6,y6,z6,&b1,&b2,&b3);
      else if (numtri==2) bary3d (xmin,ymin,zmin,x4,y4,z4, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
      else if (numtri==3) bary3d (xmin,ymin,zmin,x2,y2,z2, x4,y4,z4, x5,y5,z5,&b1,&b2,&b3);
      else if (numtri==4) bary3d (xmin,ymin,zmin,x3,y3,z3, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
      
      baryf[npf]=b1;  baryf[npf+ *nbcouf]=b2;  baryf[npf+ nbcouf2]=b3;
      ncborf[npf]=nelmin;  ncborf[npf+ *nbcouf]=numtri;
      distance[npf]=dmin; dist_moy+=dmin;  dist_var+=(dmin*dmin);

      if (*nblbla==15)
	{
	  printf("\n   NOEUD FLUIDE : %6d  coordonnees : %10.3f %10.3f %10.3f\n",npf+1,xp1,yp1,zp1);
	  printf("   CORRESPONDANT SOLIDE :\n");
	  printf("           numero du triangle solide : %6d\n",nelmin);
	  printf("                              noeuds : %6d  %6d  %6d\n",n1,n2,n3);
	  printf("             numero du sous-triangle : %6d\n",numtri);
	  printf("              coord du correspondant : %10.3f %10.3f %10.3f\n",xmin,ymin,zmin);
	  printf("                   distance minimale :%10.3f\n",dmin);
	  printf("                coord barycentriques : %10.3f %10.3f %10.3f\n",b1,b2,b3);
	}

    }

  if (npfpb)
    {
      printf("\n %%%% ERREUR COROCT : %d points du maillage fluide n'ont pas de correspondant\n",npfpb);
      printf("                    sur le maillage solide \n");
      printf("                    Verifier les references et le fichier de donnees\n");
      exit(0);
    }


  dist_moy /= *nbcouf; dist_var= dist_var/ *nbcouf-(dist_moy*dist_moy);
  printf("\n              Distance de correspondance\n"); 
  printf("                               - maximale : %12.5e\n",dist_max); 
  printf("                               - moyenne  : %12.5e\n",dist_moy); 
  printf("                               - variance : %12.5e\n",dist_var); 
  tuer_tree(arbre,8); free(arbre);


  vmin=0;  nbhisto=10;  interv=dist_max/(nbhisto);
  thisto=(int *)malloc(nbhisto*sizeof(int));
  if (thisto==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}
  histog (*nbcouf,distance,vmin,dist_max,thisto,nbhisto);
  printf("              Histogramme de la distance (nombre de points=%5d)\n",*nbcouf);
  printf("                       Intervalle                  nb_points    Pourcentage\n");
  for (i=0;i<nbhisto;i++) 
    {printf("                 %12.5e - %12.5e        %5d         %5.2f\n",
      i*interv,(i+1)*interv,thisto[i],(double)thisto[i]/ *nbcouf);
    }
  free(distance);



  printf("\n *** COROCT : Calcul des correspondants des noeuds solides \n"); 

  size_min = 1.E8;
  arbre= (struct node *)malloc(sizeof(struct node));
  if (arbre==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}
  build_octree (arbre,*ndim,*nbcouf,*nelesf,nodesf,coordf,&size_min,dim_boite);
  /* affiche_tree(arbre,8); */


  dist_max=0; dist_moy=0; dist_var=0; npspb=0;
  distance= (double *)malloc(*nbcous*sizeof(double));
  if (distance==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}

  for (nps=0 ; nps < *npoins ; nps++ ) trav2[nps]=0;

    for (nps=0 ; nps < *nbcous ; nps++ ) 
  /*--------------------------------*/
    {
      if (ncbors[nps]==-1) {nonc++; continue;}
      dmin=1.e6; xmin=ymin=zmin=0;
      nelmin=1; n1min=n2min=n3min=n4min=n5min=0;
      nm=1; xm=ym=zm=0; dm=1.e6;
      
      ng=ncoups[nps];
      xp1=coords[ng-1]; yp1=coords[ng-1+ *npoins]; zp1=coords[ng-1+npoins2];
      noeud=arbre;
      find_node_3d (&noeud,xp1,yp1,zp1); 

      fa = noeud->lelement;
      if (fa==NULL) {noeud=arbre;fa = noeud->lelement;}

      nb_passage=1;

    onrecommence2:

      while (fa != NULL)
	{
	  nlonv=0;
	  while (fa!=NULL && nlonv<N64) {ntabel[nlonv]=fa->num;nlonv+=1;fa=fa->suivant;}
	  for (i=0;i<nlonv;i++)
	    {
	      icode[i]=0; lco[i]=1; num=ntabel[i];
              na[i] = nodesf[num-1];
              nb[i] = nodesf[num-1+ *nelesf];
              nc[i] = nodesf[num-1+ nelesf2];

              xa[i]=coordf[na[i]-1];
              ya[i]=coordf[na[i]-1+ *nbcouf];
              za[i]=coordf[na[i]-1+ nbcouf2];
              xb[i]=coordf[nb[i]-1];
              yb[i]=coordf[nb[i]-1+ *nbcouf];
              zb[i]=coordf[nb[i]-1+ nbcouf2];
              xc[i]=coordf[nc[i]-1];
              yc[i]=coordf[nc[i]-1+ *nbcouf];
              zc[i]=coordf[nc[i]-1+ nbcouf2];
            }
          
	  cal_dmin(xp1,yp1,zp1,xa,ya,za,xb,yb,zb,xc,yc,zc,nlonv,&dm,&xm,&ym,&zm,&nm,lco,icode);

	  for (i=0;i<nlonv;i++)
	    if (icode[i]!=0) 
	      {
		printf("\n %%%% ERREUR  COROCT : LA RECHERCHE DU CORRESPONDANT A ECHOUE\n");
		printf("                       POINT SOLIDE : %d\n",nps+1);
		printf("                                      %10.3f %10.3f %10.3f\n",xp1,yp1,zp1);
		printf("            DANS LE TRIANGLE FLUIDE : %d\n",ntabel[i]);
		printf("                                      %d %d %d\n",na[i],nb[i],nc[i]);
		exit(0);
	      }

	  if (dm<dmin) {dmin=dm; xmin=xm; ymin=ym;zmin=zm; nelmin=ntabel[nm];}
	}

      if (dmin>*dmax_util && nb_passage==1)
	{
	  noeud=arbre;
	  fa = noeud->lelement;
	  nb_passage++;
	  goto onrecommence2;
	}
      else if (dmin>99999. && nb_passage>1)
	{
	  printf("       Pas de correspondant, noeud solide %d de coord %f %f %f\n",ng,xp1,yp1,zp1);
	  npspb++;
	  continue;
	}

      if (dmin>dist_max) dist_max=dmin;
      if (dmin>*d2maxf) {nonc++; ncbors[nps] = -1; continue;}
      trav2[ng-1]=dmin;

      n1min=nodesf[nelmin-1]; n2min=nodesf[nelmin-1+ *nelesf]; 
      n3min=nodesf[nelmin-1+ *nelesf*2]; 
      x1=coordf[n1min-1];  y1=coordf[n1min-1+ *nbcouf]; z1=coordf[n1min-1 +nbcouf2]; 
      x2=coordf[n2min-1];  y2=coordf[n2min-1+ *nbcouf]; z2=coordf[n2min-1 +nbcouf2]; 
      x3=coordf[n3min-1];  y3=coordf[n3min-1+ *nbcouf]; z3=coordf[n3min-1 +nbcouf2]; 

/*      if (*ndmasf==6 && nodess[nelmin-1+ *nelesf*3]!=0)   a eliminer vraissemblablement */
      if (*ndmasf==6)
	{
	  n4min=nodesf[nelmin-1+ *nelesf*3]; 
	  n5min=nodesf[nelmin-1+ *nelesf*4]; n6min=nodesf[nelmin-1+ *nelesf*5];
	  x4=coordf[n4min-1];  y4=coordf[n4min-1+ *nbcouf]; z4=coordf[n4min-1 +nbcouf2]; 
	  x5=coordf[n5min-1];  y5=coordf[n5min-1+ *nbcouf]; z5=coordf[n5min-1 +nbcouf2]; 
	  x6=coordf[n6min-1];  y6=coordf[n6min-1+ *nbcouf]; z6=coordf[n6min-1 +nbcouf2]; 

	  proc(soutri,SOUTRI)(xmin,ymin,zmin, x4,y4,z4, x5,y5,z5, x6,y6,z6, &numtri);

	  if (numtri==1)      bary3d (xmin,ymin,zmin,x1,y1,z1, x4,y4,z4, x6,y6,z6,&b1,&b2,&b3);
	  else if (numtri==2) bary3d (xmin,ymin,zmin,x4,y4,z4, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
	  else if (numtri==3) bary3d (xmin,ymin,zmin,x2,y2,z2, x4,y4,z4, x5,y5,z5,&b1,&b2,&b3);
	  else if (numtri==4) bary3d (xmin,ymin,zmin,x3,y3,z3, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
      
	  barys[nps]=b1;  barys[nps+ *nbcous]=b2;  barys[nps+ nbcous2]=b3;
	}
      else
	{
	  numtri = 0;
	  bary3d (xmin,ymin,zmin,x1,y1,z1, x2,y2,z2, x3,y3,z3,&b1,&b2,&b3);	
 	  barys[nps]=b1;  barys[nps+ *nbcous]=b2;  barys[nps+ nbcous2]=b3;
	}
      
      ncbors[nps]=nelmin;  ncbors[nps+ *nbcous]=numtri;
      distance[nps]=dmin; dist_moy+=dmin;  dist_var+=(dmin*dmin);

      if (*nblbla==15)
	{
	  printf("\n   NOEUD SOLIDE : %6d  coordonnees : %10.3f %10.3f %10.3f\n",ng,xp1,yp1,zp1);
	  printf("   CORRESPONDANT FLUIDE :\n");
	  printf("           numero du triangle fluide : %6d\n",nelmin);
	  printf("                              noeuds : %6d  %6d  %6d\n",n1min,n2min,n3min);
	  printf("             numero du sous-triangle : %6d\n",numtri);
	  printf("              coord du correspondant : %10.3f %10.3f %10.3f\n",xmin,ymin,zmin);
	  printf("                   distance minimale :%10.3f\n",dmin);
	  printf("                coord barycentriques : %10.3f %10.3f %10.3f\n",b1,b2,b3);
	}

    }

  if (*nblbla==15)
    {
      printf(" *** COROCT :\n"); 
      printf(" Nombre de noeuds solides candidats au couplage %d\n",*nbcous);
      printf(" Nombre de noeuds elimines du couplage          %d\n",*nbcous);
    }

  if (npspb)
    {
      printf("\n %%%% ERREUR COROCT : %d points du maillage solide n'ont pas de correspondant\n",nps);
      printf("                    sur le maillage fluide \n");
      printf("                    Verifier les references et le fichier de donnees\n");
      exit(0);
    }

  dist_moy /= *nbcous; dist_var= dist_var/ *nbcous-(dist_moy*dist_moy);
  printf("\n              Distance de correspondance\n"); 
  printf("                               - maximale : %12.5e\n",dist_max); 
  printf("                               - moyenne  : %12.5e\n",dist_moy); 
  printf("                               - variance : %12.5e\n",dist_var); 
  tuer_tree(arbre,8); free(arbre);

  vmin=0;  nbhisto=10;  interv=dist_max/(nbhisto);
  thisto=(int *)malloc(nbhisto*sizeof(int));
  if (thisto==NULL) 
    {printf(" ERREUR coroct : probleme d'allocation memoire\n");
     exit(0);}
  histog (*nbcous,distance,vmin,dist_max,thisto,nbhisto);
  printf("              Histogramme de la distance (nombre de points=%5d)\n",*nbcous);
  printf("                       Intervalle                  nb_points    Pourcentage\n");
  for (i=0;i<nbhisto;i++) 
    {printf("                 %12.5e - %12.5e        %5d         %5.2f\n",
      i*interv,(i+1)*interv,thisto[i],(double)thisto[i]/ *nbcous);
    }
  free(distance);

}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | crroct                                                               |
  |         Gestion du calcul des correspondants rayonnement en dim 3    |
  |======================================================================| */

proc(void crroct,void CRROCT) (int *ndim,
		     int *ndma1,int *np1,double *coor1,int *nel1,
		     int *nod1,int *ngl1,int *nglob1,int *nc1,double *bary1,
		     int *ndma2,int *np2,double *coor2,int *nel2,
		     int *nod2,int *nref2,int *ngl2,int *nglob2,int *nc2,
		     double *bary2,int *iref,int *indglo,
		     int *nblbla,double *trav1, double *trav2)
{

  int ntabel[N64],na[N64],nb[N64],nc[N64],icode[N64],lco[N64];
  double xa[N64],xb[N64],xc[N64],ya[N64],yb[N64],yc[N64];
  double za[N64],zb[N64],zc[N64];

  int i,n,ng,ngg,nf,nff,nlonv,ngl22,ngl12,np12,np22,nel12,nel22,num;
  int nelmin,n1min,n2min,n3min,n4min,n5min,n6min,numtri,nm;
  int *nod1g,nbhisto,*thisto;
  double x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,x5,y5,z5,x6,y6,z6;
  double dim_boite[6],xp1,yp1,zp1,dm,xm,ym,zm,dmin,xmin,ymin,zmin;
  double b1,b2,b3,size_min,dist_max,*distance,dist_moy,dist_var;
  double vmin,interv;
  struct element *fa;
  struct node *arbre,*noeud;

  if (*ngl1==0 && *ngl2==0)  return;


  for (n=0;n<*ngl2* *ndim;n++) bary2[n]=0;
  for (n=0;n<*ngl1* *ndim;n++) bary1[n]=0;
  ngl22=*ngl2*2;  ngl12=*ngl1*2;  np12=*np1*2;  np22=*np2*2;
  nel12=*nel1*2; nel22=*nel2*2;
  
  boite2(*ndim,*np1,coor1,*np2,coor2,dim_boite);

  size_min = 1.E8;
  arbre= (struct node *)malloc(sizeof(struct node));
  if (arbre==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}

  nod1g= (int *)malloc(*nel1* *ndma1 * sizeof(int));
  if (nod1g==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}
  for (i=0 ; i < *nel1* *ndma1 ; i++ ) nod1g[i]=nglob1[nod1[i]-1];
  
  build_octree (arbre,*ndim,*np1,*nel1,nod1g,coor1,&size_min,dim_boite);
  free(nod1g);

  /* affiche_tree(arbre,8); */


  printf("\n *** CRROCT : Calcul des correspondants du maillage de rayonnement \n"); 

  dist_max=0; dist_moy=0; dist_var=0;
  distance= (double *)malloc(*ngl2*sizeof(double));
  if (distance==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}

  for (ng=0 ; ng < *ngl2 ; ng++ ) trav2[ng]=0;

  for (ng=0 ; ng < *ngl2 ; ng++ ) 
  /*--------------------------------*/
    {
      dmin=1.e6; xmin=ymin=zmin=0;
      nelmin=1; n1min=n2min=n3min=n4min=n5min=0;
      nm=1; xm=ym=zm=0; dm=1.e6;

      ngg=nglob2[ng]-1;
      xp1=coor2[ngg]; yp1=coor2[ngg+ *np2]; zp1=coor2[ngg+np22];

      noeud=arbre;
      find_node_3d (&noeud,xp1,yp1,zp1); 

      fa = noeud->lelement;
      if (fa==NULL) {noeud=arbre;fa = noeud->lelement;}
      while (fa != NULL)
	{
	  nlonv=0;
	  while (fa!=NULL && nlonv<N64) {ntabel[nlonv]=fa->num;nlonv+=1;fa=fa->suivant;}
	  for (i=0;i<nlonv;i++)
	    {
	      num=ntabel[i]; lco[i]=1;
	      if (*indglo==1)
		{
		  na[i] = nglob1[nod1[num-1]-1];
		  nb[i] = nglob1[nod1[num-1+ *nel1]-1];
		  nc[i] = nglob1[nod1[num-1+ nel12]-1];
		}
	      else
		{
		  na[i] = nod1[num-1];
		  nb[i] = nod1[num-1+ *nel1];
		  nc[i] = nod1[num-1+ nel12];
		}
	      xa[i] = coor1[na[i]-1]; ya[i] = coor1[na[i]-1+ *np1]; za[i] = coor1[na[i]-1+ np12];
              xb[i] = coor1[nb[i]-1]; yb[i] = coor1[nb[i]-1+ *np1]; zb[i] = coor1[nb[i]-1+ np12];
	      xc[i] = coor1[nc[i]-1]; yc[i] = coor1[nc[i]-1+ *np1]; zc[i] = coor1[nc[i]-1+ np12];
	      icode[i]=0;
	    }
	  
	  cal_dmin(xp1,yp1,zp1,xa,ya,za,xb,yb,zb,xc,yc,zc,nlonv,&dm,&xm,&ym,&zm,&nm,lco,icode);

	  for (i=0;i<nlonv;i++)
	    if (icode[i]!=0) 
	      {
		printf("\n %%%% ERREUR  CRROCT : LA RECHERCHE DU CORRESPONDANT A ECHOUE\n");
		printf("                     POINT GROSSIER : %d\n",ngg+1);
		printf("                                      %10.3f %10.3f %10.3f\n",xp1,yp1,zp1);
		printf("               DANS LE TRIANGLE FIN : %d\n",ntabel[i]);
		printf("                                      %d %d %d\n",na[i],nb[i],nc[i]);
		exit(0);
	      }
	  
	  if (dm<dmin) {dmin=dm; xmin=xm; ymin=ym;zmin=zm; nelmin=ntabel[nm];}
	}


      if (dmin>99999.) {printf("       Pas de correspondant, noeud rayonnement %d\n",ngg+1); continue;}
      if (dmin>dist_max) dist_max=dmin;
      trav2[ngg]=dmin;

      if (*indglo==1)
	{ n1min=nglob1[nod1[nelmin-1]-1]; n2min=nglob1[nod1[nelmin-1+ *nel1]-1];  
	  n3min=nglob1[nod1[nelmin-1+ *nel1*2]-1];
	}
      else
	{ n1min=nod1[nelmin-1]; n2min=nod1[nelmin-1+ *nel1];  
	  n3min=nod1[nelmin-1+ nel12]; 
	}

      x1=coor1[n1min-1];  y1=coor1[n1min-1+ *np1]; z1=coor1[n1min-1 +np12]; 
      x2=coor1[n2min-1];  y2=coor1[n2min-1+ *np1]; z2=coor1[n2min-1 +np12]; 
      x3=coor1[n3min-1];  y3=coor1[n3min-1+ *np1]; z3=coor1[n3min-1 +np12]; 

      if (*ndma1==6)
	{
	  if (*indglo==1)
	    { n4min=nglob1[nod1[nelmin-1+ *nel1*3]-1]; 
	      n5min=nglob1[nod1[nelmin-1+ *nel1*4]-1];  
	      n6min=nglob1[nod1[nelmin-1+ *nel1*5]-1];
	    }
	  else
	    { n4min=nod1[nelmin-1+ *nel1*3]; 
	      n5min=nod1[nelmin-1+ *nel1*4];  
	      n6min=nod1[nelmin-1+ *nel1*5]; 
	    }

	  x4=coor1[n4min-1];  y4=coor1[n4min-1+ *np1]; z4=coor1[n4min-1 +np12]; 
	  x5=coor1[n5min-1];  y5=coor1[n5min-1+ *np1]; z5=coor1[n5min-1 +np12]; 
	  x6=coor1[n6min-1];  y6=coor1[n6min-1+ *np1]; z6=coor1[n6min-1 +np12]; 

	  proc(soutri,SOUTRI)(xmin,ymin,zmin, x4,y4,z4, x5,y5,z5, x6,y6,z6, &numtri);

	  if (numtri==1)      bary3d (xmin,ymin,zmin,x1,y1,z1, x4,y4,z4, x6,y6,z6,&b1,&b2,&b3);
	  else if (numtri==2) bary3d (xmin,ymin,zmin,x4,y4,z4, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
	  else if (numtri==3) bary3d (xmin,ymin,zmin,x2,y2,z2, x4,y4,z4, x5,y5,z5,&b1,&b2,&b3);
	  else if (numtri==4) bary3d (xmin,ymin,zmin,x3,y3,z3, x5,y5,z5, x6,y6,z6,&b1,&b2,&b3);
	}
      else
	{
	  numtri=0;
	  bary3d (xmin,ymin,zmin,x1,y1,z1, x2,y2,z2, x3,y3,z3,&b1,&b2,&b3);
	}

      bary2[ng]=b1;  bary2[ng+ *ngl2]=b2;  bary2[ng+ ngl22]=b3;
      nc2[ng]=nelmin;  nc2[ng+ *ngl2]=numtri;
      distance[ng]=dmin; dist_moy+=dmin;  dist_var+=(dmin*dmin);

      if (*nblbla==16)
	{
	  printf("\n   NOEUD GROSSIER : %6d  coordonnees : %10.3f %10.3f %10.3f\n",ng+1,xp1,yp1,zp1);
	  printf("   CORRESPONDANT FIN :\n");
	  printf("              numero du triangle fin : %6d\n",nelmin);
	  printf("                              noeuds : %6d  %6d  %6d\n",n1min,n2min,n3min);
	  printf("             numero du sous-triangle : %6d\n",numtri);
	  printf("              coord du correspondant : %10.3f %10.3f %10.3f\n",xmin,ymin,zmin);
	  printf("                   distance minimale :%10.3f\n",dmin);
	  printf("                coord barycentriques : %10.3f %10.3f %10.3f\n",b1,b2,b3);
	}

    }

  if (dist_max>99999.)
    {
      printf("\n %%%% ERREUR CRROCT : des points du maillage de rayonnement  n'ont pas de correspondant\n");
      printf("                    sur le maillage fin \n");
      printf("                    Verifier les references et le fichier de donnees\n");
      exit(0);
    }

  dist_moy /= *ngl2; dist_var= dist_var/ *ngl2-(dist_moy*dist_moy);
  printf("\n              Distance de correspondance\n"); 
  printf("                               - maximale : %12.5e\n",dist_max); 
  printf("                               - moyenne  : %12.5e\n",dist_moy); 
  printf("                               - variance : %12.5e\n",dist_var); 
  tuer_tree(arbre,8);


  vmin=0;  nbhisto=10;  interv=dist_max/(nbhisto);
  thisto=(int *)malloc(nbhisto*sizeof(int));
  if (thisto==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}
  histog (*ngl2,distance,vmin,dist_max,thisto,nbhisto);
  printf("              Histogramme de la distance (nombre de points=%5d)\n",*ngl2);
  printf("                       Intervalle                  nb_points    Pourcentage\n");
  for (i=0;i<nbhisto;i++) 
    {printf("                 %12.5e - %12.5e        %5d         %5.2f\n",
      i*interv,(i+1)*interv,thisto[i],(double)thisto[i]/ *ngl2);
    }
  free(distance);



  printf("\n *** CRROCT : Calcul des correspondants du maillage conduction \n"); 

  size_min = 1.E8;
  arbre= (struct node *)malloc(sizeof(struct node));
  if (arbre==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}
  build_octree (arbre,*ndim,*np2,*nel2,nod2,coor2,&size_min,dim_boite);
  /* affiche_tree(arbre,8); */


  dist_max=0; dist_moy=0; dist_var=0;
  distance= (double *)malloc(*ngl1*sizeof(double));
  if (distance==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}

  for (nf=0 ; nf < *np1 ; nf++ ) trav1[nf]=0;

  for (nf=0 ; nf < *ngl1 ; nf++ ) 
  /*--------------------------------*/
    {
      dmin=1.e6; xmin=ymin=zmin=0;
      nelmin=1; n1min=n2min=n3min=n4min=n5min=0;
      nm=1; xm=ym=zm=0; dm=1.e6;
      
      if (*indglo==1) nff=nglob1[nf]-1; else nff=nf;
      xp1=coor1[nff]; yp1=coor1[nff+ *np1]; zp1=coor1[nff+np12];

      noeud=arbre;
      find_node_3d (&noeud,xp1,yp1,zp1); 

      fa = noeud->lelement;
      if (fa==NULL) {noeud=arbre;fa = noeud->lelement;}
      while (fa != NULL)
	{
	  nlonv=0;
	  while (fa!=NULL && nlonv<N64) {ntabel[nlonv]=fa->num;nlonv+=1;fa=fa->suivant;}
	  for (i=0;i<nlonv;i++)
	    {
	      icode[i]=0; lco[i]=1; num=ntabel[i];
	      if (iref[nref2[num-1]-1]==0) {lco[i]=0; continue;}

	      na[i] = nod2[num-1];
	      nb[i] = nod2[num-1+ *nel2];
	      nc[i] = nod2[num-1+ nel22];
	      xa[i] = coor2[na[i]-1]; ya[i] = coor2[na[i]-1+ *np2]; za[i] = coor2[na[i]-1+ np22];
              xb[i] = coor2[nb[i]-1]; yb[i] = coor2[nb[i]-1+ *np2]; zb[i] = coor2[nb[i]-1+ np22];
	      xc[i] = coor2[nc[i]-1]; yc[i] = coor2[nc[i]-1+ *np2]; zc[i] = coor2[nc[i]-1+ np22];
	    }

	  cal_dmin(xp1,yp1,zp1,xa,ya,za,xb,yb,zb,xc,yc,zc,nlonv,&dm,&xm,&ym,&zm,&nm,lco,icode);

	  for (i=0;i<nlonv;i++)
	    if (icode[i]!=0) 
	      {
		printf("\n %%%% ERREUR  CRROCT : LA RECHERCHE DU CORRESPONDANT A ECHOUE\n");
		printf("                          POINT FIN : %d\n",nff+1);
		printf("                                      %10.3f %10.3f %10.3f\n",xp1,yp1,zp1);
		printf("          DANS LE TRIANGLE GROSSIER : %d\n",ntabel[i]);
		printf("                                      %d %d %d\n",na[i],nb[i],nc[i]);
		exit(0);
	      }
	  
	  if (dm<dmin) {dmin=dm; xmin=xm; ymin=ym;zmin=zm; nelmin=ntabel[nm];}
	}



      if (dmin>99999.) {printf("       Pas de correspondant, noeud fin %d\n",nff+1); continue;}
      if (dmin>dist_max) dist_max=dmin;
      trav1[nff]=dmin;
      
      n1min=nod2[nelmin-1]; n2min=nod2[nelmin-1+ *nel2]; 
      n3min=nod2[nelmin-1+ *nel2*2]; 
      x1=coor2[n1min-1];  y1=coor2[n1min-1+ *np2]; z1=coor2[n1min-1 +np22]; 
      x2=coor2[n2min-1];  y2=coor2[n2min-1+ *np2]; z2=coor2[n2min-1 +np22]; 
      x3=coor2[n3min-1];  y3=coor2[n3min-1+ *np2]; z3=coor2[n3min-1 +np22]; 

      bary3d (xmin,ymin,zmin,x1,y1,z1, x2,y2,z2, x3,y3,z3,&b1,&b2,&b3);	
      bary1[nf]=b1;  bary1[nf+ *ngl1]=b2;  bary1[nf+ ngl12]=b3;
      nc1[nf]=nelmin;
      distance[nf]=dmin; dist_moy+=dmin;  dist_var+=(dmin*dmin);

      if (*nblbla==16)
	{
	  printf("\n      NOEUD FIN : %6d  coordonnees : %10.3f %10.3f %10.3f\n",nff+1,xp1,yp1,zp1);
	  printf("   CORRESPONDANT GROSSIER :\n");
	  printf("         numero du triangle grossier : %6d\n",nelmin);
	  printf("                              noeuds : %6d  %6d  %6d\n",n1min,n2min,n3min);
	  printf("              coord du correspondant : %10.3f %10.3f %10.3f\n",xmin,ymin,zmin);
	  printf("                   distance minimale :%10.3f\n",dmin);
	  printf("                coord barycentriques : %10.3f %10.3f %10.3f\n",b1,b2,b3);
	}

    }

  if (dist_max>99999.)
    {
      if (*indglo==1)
	  printf("\n %%%% ERREUR CRROCT : des points du maillage solide n'ont pas de correspondant\n");
      else
	  printf("\n %%%% ERREUR CRROCT : des points du maillage fluide n'ont pas de correspondant\n");
	
      printf("                    sur le maillage de rayonnement \n");
      printf("                    Verifier les references et le fichier de donnees\n");
      exit(0);
    }

  dist_moy /= *ngl1; dist_var= dist_var/ *ngl1-(dist_moy*dist_moy);
  printf("\n              Distance de correspondance\n"); 
  printf("                               - maximale : %12.5e\n",dist_max); 
  printf("                               - moyenne  : %12.5e\n",dist_moy); 
  printf("                               - variance : %12.5e\n",dist_var); 
  tuer_tree(arbre,8);


  vmin=0;  nbhisto=10;  interv=dist_max/(nbhisto);
  thisto=(int *)malloc(nbhisto*sizeof(int));
  if (thisto==NULL) 
    {printf(" ERREUR crroct : probleme d'allocation memoire\n");
     exit(0);}
  histog (*ngl1,distance,vmin,dist_max,thisto,nbhisto);
  printf("              Histogramme de la distance (nombre de points=%5d)\n",*ngl1);
  printf("                       Intervalle                  nb_points    Pourcentage\n");
  for (i=0;i<nbhisto;i++) 
    {printf("                 %12.5e - %12.5e        %5d         %5.2f\n",
      i*interv,(i+1)*interv,thisto[i],(double)thisto[i]/ *ngl1);
    }

  free(distance);

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | soutri                                                               |
  |         Calcul du sous-triangle                                      |
  |         \                                                            |
  |         | \                                                          |
  |         |    \                                                       |
  |         | (4)  \               Numerotation locale des noeuds        |
  |         |        \             et des sous-triangles                 |
  |       6 |\-------- \ 5                                               |
  |         |  \ (2) |   \                                               |
  |         |(1) \   | (3) \                                             |
  |         |      \ |       \                                           |
  |         |------------------\                                         |
  |        1         4          2                                        |
  |======================================================================| */
proc(void soutri,void SOUTRI) (double xx,double yy,double zz,
            double x4,double y4,double z4,
	    double x5,double y5,double z5,double x6,double y6,double z6,
	    int *numtri)
{
    double  x45,y45,z45,x46,y46,z46,v45n,v46n,aa;
    double  xnn,xn,yn,zn,xe1,ye1,ze1,v46e1,xe2,ye2,ze2,e2n;
    double  x4new,y4new,x5new,y5new,x6new,y6new,xxnew,yynew;
    double  a1,b1,c1,a2,b2,c2,a3,b3,c3;
    double  x4546,y4546,z4546;

    x45 = x5 - x4; y45 = y5 - y4; z45 = z5 - z4;
    x46 = x6 - x4; y46 = y6 - y4; z46 = z6 - z4;

    v45n = sqrt ( x45*x45 + y45*y45 + z45*z45 );
    v46n = sqrt ( x46*x46 + y46*y46 + z46*z46 );

    x4546 =   y45*z46 - z45*y46;
    y4546 = - x45*z46 + z45*x46;
    z4546 =   x45*y46 - y45*x46;

    xnn = sqrt( x4546*x4546 + y4546*y4546 + z4546*z4546);
    xn = x4546 / xnn;  yn = y4546 / xnn;  zn = z4546 / xnn;
    xe1 = x45 / v45n;  ye1 = y45 / v45n;  ze1 = z45 / v45n;

    v46e1 = x46*xe1 + y46*ye1 + z46*ze1;

    xe2 = x46 - v46e1*xe1;
    ye2 = y46 - v46e1*ye1;
    ze2 = z46 - v46e1*ze1;
   
    e2n = sqrt ( xe2*xe2 + ye2*ye2 + ze2*ze2 );
    xe2 /= e2n;  ye2 /= e2n;  ze2 /= e2n;

   /* coord des noeuds dans le nouveau repere
     ------------------------------------------ */
    x4new = 0.;  y4new = 0.;
    x5new = v45n;  y5new = 0.;
    x6new = x46*xe1 + y46*ye1 + z46*ze1; 
    y6new = x46*xe2 + y46*ye2 + z46*ze2;

    xxnew = (xx-x4)*xe1 + (yy-y4)*ye1 + (zz-z4)*ze1;
    yynew = (xx-x4)*xe2 + (yy-y4)*ye2 + (zz-z4)*ze2;

    /* equations des droites du triangle
     ------------------------------------ */


    if (y6new<0.) {a1=0.;  b1=1.;  c1=0.;}
    else {a1=0.;  b1=-1.;  c1= 0.;}

    a2 = - y6new;  b2 = x6new - x5new;  c2 = y6new * x5new;
    if ((a2*x4new + b2*y4new + c2)>0.) {a2=-a2;b2=-b2;c2=-c2;}

    aa = sqrt (a2*a2 + b2*b2);
    a2 /= aa;  b2 /= aa;  c2 /= aa;

    a3=-y6new;  b3=x6new;  c3=0.;
    if ((a3*x5new + b3*y5new + c3)>0.) {a3=-a3;b3=-b3;}


   /* position du point par rapport a ces 3 droites
     ---------------------------------------------- */

    if ((a3*xxnew + b3*yynew + c3) > 0.) *numtri=1;
    else if ((a1*xxnew + b1*yynew + c1) > 0.) *numtri=3;
    else if ((a2*xxnew + b2*yynew + c2) > 0.) *numtri=4;
    else *numtri=2;
}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | bary3d                                                               |
  |         Calcul des coefficients barycentriques                       |
  |======================================================================| */

void bary3d(double xx,double yy,double zz,
	    double xa,double ya,double za,double xb,double yb,double zb,
	    double xc,double yc,double zc,
	    double *xl1,double *xl2,double *xl3)
{
  
  double deno,deno1,deno2,deno3,un;
  int n;

  un=1.;
  deno = deno1 = determ (xa,ya,un,xb,yb,un,xc,yc,un);
  deno2 = determ (ya,za,un,yb,zb,un,yc,zc,un);
  deno3 = determ (xa,za,un,xb,zb,un,xc,zc,un);
  n=1; if (abs(deno2)>abs(deno)) {deno=deno2;n=2;}
  if (abs(deno3)>abs(deno)) {deno=deno3;n=3;}

  if (n==1)
    {
      *xl1  = determ (xx,yy,un,xb,yb,un,xc,yc,un);
      *xl2  = determ (xa,ya,un,xx,yy,un,xc,yc,un);
    }
  else if (n==2)
    {
	  *xl1  = determ (yy,zz,un,yb,zb,un,yc,zc,un);
	  *xl2  = determ (ya,za,un,yy,zz,un,yc,zc,un);
    }
  else
    {
	  *xl1  = determ (xx,zz,un,xb,zb,un,xc,zc,un);
	  *xl2  = determ (xa,za,un,xx,zz,un,xc,zc,un);
    }

  if (abs(deno) > 1e-10)
    {*xl1=*xl1/deno;  *xl2=*xl2/deno;  *xl3=1.-*xl1-*xl2;}
  else
    {*xl1 = 0.; *xl2 = 0. ;  *xl3 = 1. ;}
   

}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | determ                                                               |
  |         Calcul d'un determinant                                      |
  |======================================================================| */
double determ(double x1,double y1,double z1,
	      double x2,double y2,double z2,
	      double x3,double y3,double z3)
  {
    return(x1*y2*z3 + x2*y3*z1 + y1*z2*x3-z1*y2*x3 - y1*x2*z3 - z2*y3*x1);
  }
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cal_dmin                                                             |
  |         Calcul du point qui realise la distance minimale             |
  |                                                                      |
  |======================================================================| */
void cal_dmin(double xp1,double yp1,double zp1,
	      double *xa,double *ya,double *za,double *xb,double *yb,double *zb,
	      double *xc,double *yc,double *zc,
	      int nlonv,double *dmin,double *xmin,double *ymin,
	      double *zmin,int *nelmin,
	      int *lco,int *icode)
{

  int i;
  double  xx[N64],yy[N64],dist[N64],xdmi[N64],ydmi[N64],zdmi[N64];
  double  xab[N64],yab[N64],zab[N64],xac[N64],yac[N64],zac[N64];
  double  abn[N64],acn[N64],xabac[N64],yabac[N64],zabac[N64];
  double  xe1[N64],ye1[N64],ze1[N64],xe2[N64],ye2[N64],ze2[N64];
  double  ace1[N64],e2n[N64],xh[N64];
  double  xanew[N64],yanew[N64],xbnew[N64],ybnew[N64],xcnew[N64],ycnew[N64];
  double  xn[N64],yn[N64],zn[N64],xp[N64],yp[N64];
  double  a1[N64],b1[N64],c1[N64],a2[N64],b2[N64],c2[N64];
  double  a3[N64],b3[N64],c3[N64],d1[N64],d2[N64],d3[N64];
  double  cond12[N64],cond21[N64],cond13[N64];
  double  cond31[N64],cond23[N64],cond32[N64],deno[N64];
  double  xnn[N64];


  *dmin=1.e10;
      
  for (i=0;i<nlonv;i++)
    {
      xab[i] = xb[i]-xa[i]; yab[i]=yb[i]-ya[i]; zab[i]=zb[i]-za[i];
      xac[i] = xc[i]-xa[i]; yac[i]=yc[i]-ya[i]; zac[i]=zc[i]-za[i];

      abn[i] = sqrt ( xab[i]*xab[i] + yab[i]*yab[i] + zab[i]*zab[i] );
      acn[i] = sqrt ( xac[i]*xac[i] + yac[i]*yac[i] + zac[i]*zac[i] );

      xabac[i] =   yab[i]*zac[i] - zab[i]*yac[i];
      yabac[i] = - xab[i]*zac[i] + zab[i]*xac[i];
      zabac[i] =   xab[i]*yac[i] - yab[i]*xac[i];

      xnn[i] = sqrt( xabac[i]*xabac[i] + yabac[i]*yabac[i] + zabac[i]*zabac[i]);
      xn[i]  = xabac[i]/xnn[i]; yn[i] = yabac[i]/xnn[i]; zn[i] = zabac[i]/xnn[i];

      xe1[i] = xab[i]/abn[i]; ye1[i] = yab[i]/abn[i];  ze1[i] = zab[i]/abn[i];

      ace1[i]= xac[i]*xe1[i] + yac[i]*ye1[i] + zac[i]*ze1[i];

      xe2[i] = xac[i] - ace1[i]*xe1[i];
      ye2[i] = yac[i] - ace1[i]*ye1[i];
      ze2[i] = zac[i] - ace1[i]*ze1[i];
   
      e2n[i] = sqrt ( xe2[i]*xe2[i] + ye2[i]*ye2[i] + ze2[i]*ze2[i] );
      xe2[i] = xe2[i]/e2n[i]; ye2[i] = ye2[i]/e2n[i]; ze2[i] = ze2[i]/e2n[i];

      xp[i] = (xp1-xa[i])*xe1[i] + (yp1-ya[i])*ye1[i]  + (zp1-za[i])*ze1[i];
      yp[i] = (xp1-xa[i])*xe2[i] + (yp1-ya[i])*ye2[i]  + (zp1-za[i])*ze2[i];

      xh[i] = (xp1-xa[i])*xn[i] + (yp1-ya[i])*yn[i]  + (zp1-za[i])*zn[i];

      xanew[i] = 0.; yanew[i] = 0.;
      xbnew[i] = abn[i]; ybnew[i] = 0.;
      xcnew[i] = xac[i]*xe1[i] + yac[i]*ye1[i] + zac[i]*ze1[i];
      ycnew[i] = xac[i]*xe2[i] + yac[i]*ye2[i] + zac[i]*ze2[i];
    }


  for (i=0;i<nlonv;i++)
    {
      if (lco[i]) 
	{

	  if (ycnew[i]<0) {a1[i]=0; b1[i]=1.; c1[i]=0.;}
	  else {a1[i] =0.; b1[i]=-1.; c1[i]=0.;}

	  a2[i]=-ycnew[i]; b2[i] = xcnew[i]-xbnew[i]; c2[i]=ycnew[i]*xbnew[i];

	  if ((a2[i]*xanew[i] + b2[i]*yanew[i] + c2[i])>0.) 
	    {a2[i]=-a2[i];b2[i]=-b2[i]; c2[i]=-c2[i];}

	  xx[i] = sqrt (a2[i]*a2[i] + b2[i]*b2[i]);
	  a2[i] /= xx[i]; b2[i] /= xx[i]; c2[i] /= xx[i];

	  a3[i] = - ycnew[i]; b3[i]=xcnew[i]; c3[i]=0.;

	  if ((a3[i]*xbnew[i] + b3[i]*ybnew[i] + c3[i])>0.)
	    {a3[i]=-a3[i]; b3[i]=-b3[i];}
	      
	  xx[i] = sqrt ( a3[i]*a3[i] + b3[i]*b3[i] );
	  a3[i] /= xx[i]; b3[i] /= xx[i];

	  d1[i] = a1[i]*xp[i] + b1[i]*yp[i] + c1[i];                        
	  d2[i] = a2[i]*xp[i] + b2[i]*yp[i] + c2[i];                      
	  d3[i] = a3[i]*xp[i] + b3[i]*yp[i] + c3[i];

	  cond12[i] = d1[i] - d2[i]*(a2[i]*a1[i] + b2[i]*b1[i]);
	  cond21[i] = d2[i] - d1[i]*(a1[i]*a2[i] + b1[i]*b2[i]);
	  cond13[i] = d1[i] - d3[i]*(a3[i]*a1[i] + b3[i]*b1[i]);
	  cond31[i] = d3[i] - d1[i]*(a1[i]*a3[i] + b1[i]*b3[i]);
	  cond23[i] = d2[i] - d3[i]*(a3[i]*a2[i] + b3[i]*b2[i]);
	  cond32[i] = d3[i] - d2[i]*(a2[i]*a3[i] + b2[i]*b3[i]);
	}
    }


  for (i=0;i<nlonv;i++)
    {
      if (lco[i]) 
	{
	  if (d1[i]<=0. && d2[i]<=0. && d3[i]<=0.) 
	    {xx[i]=xp[i]; yy[i]=yp[i]; dist[i]=abs(xh[i]);}

	  else if (d1[i]>0. && cond21[i]<=0. && cond31[i]<=0.) 
	    {xx[i]=xp[i]-d1[i]*a1[i];yy[i]=yp[i]-d1[i]*b1[i];
	     dist[i] = sqrt (xh[i]*xh[i] + d1[i]*d1[i]);}

	  else if (d2[i]>0. && cond12[i]<=0. && cond32[i]<=0.)
	    {xx[i]=xp[i]-d2[i]*a2[i]; yy[i]=yp[i]-d2[i]*b2[i];
	     dist[i] = sqrt (xh[i]*xh[i] + d2[i]*d2[i]);}
 
	  else if (d3[i]>0. && cond13[i]<=0. && cond23[i]<=0.) 
	    {xx[i]=xp[i]-d3[i]*a3[i]; yy[i]=yp[i]-d3[i]*b3[i];
  	     dist[i] = sqrt (xh[i]*xh[i] + d3[i]*d3[i]);}

          else if ( cond23[i]>0. && cond32[i]>0. &&
		    (d1[i]-(cond23[i]*(a1[i]*a2[i]+b1[i]*b2[i])
			    +cond32[i]*(a1[i]*a3[i]+b1[i]*b3[i]))/
		     (1.-(a2[i]*a3[i]+b2[i]*b3[i])*(a2[i]*a3[i]+b2[i]*b3[i])))<=0. )
	    {deno[i]= 1.-(a2[i]*a3[i]+b2[i]*b3[i])*(a2[i]*a3[i]+b2[i]*b3[i]);
	     xx[i]=xp[i]-(cond23[i]*a2[i]+cond32[i]*a3[i]) / deno[i];
	     yy[i]=yp[i]-(cond23[i]*b2[i]+cond32[i]*b3[i]) / deno[i];
	     dist[i]= sqrt ( xh[i]*xh[i] + 
                            (xp[i]-xx[i])*(xp[i]-xx[i]) 
			     + (yp[i]-yy[i])*(yp[i]-yy[i]) );}

	  else if (cond13[i]>0. && cond31[i]>0. &&
                   (d2[i]-(cond13[i]*(a2[i]*a1[i]+b2[i]*b1[i])
			   +cond31[i]*(a2[i]*a3[i]+b2[i]*b3[i]))/
		    (1.-(a1[i]*a3[i]+b1[i]*b3[i])*(a1[i]*a3[i]+b1[i]*b3[i])))<=0. )
	    {deno[i]=1.-(a1[i]*a3[i]+b1[i]*b3[i])*(a1[i]*a3[i]+b1[i]*b3[i]);
	     xx[i]=xp[i]- (cond13[i]*a1[i]+cond31[i]*a3[i]) / deno[i];
	     yy[i]=yp[i]- (cond13[i]*b1[i]+cond31[i]*b3[i]) / deno[i];
	     dist[i]= sqrt ( xh[i]*xh[i] +  (xp[i]-xx[i])*(xp[i]-xx[i]) 
			     + (yp[i]-yy[i])*(yp[i]-yy[i]) );}

	  else if (cond21[i]>0. && cond12[i]>0. &&
		   (d3[i]-(cond12[i]*(a3[i]*a1[i]+b3[i]*b1[i])
			   +cond21[i]*(a3[i]*a2[i]+b3[i]*b2[i]))
		    /(1-(a1[i]*a2[i]+b1[i]*b2[i])*(a1[i]*a2[i]+b1[i]*b2[i])))<=0.)
	    {deno[i]= 1.-(a1[i]*a2[i]+b1[i]*b2[i])*(a1[i]*a2[i]+b1[i]*b2[i]);
	     xx[i]=xp[i]- (cond12[i]*a1[i]+cond21[i]*a2[i]) / deno[i];
	     yy[i]=yp[i]- (cond12[i]*b1[i]+cond21[i]*b2[i]) / deno[i];
	     dist[i]=sqrt ( xh[i]*xh[i] + 
			      (xp[i]-xx[i])*(xp[i]-xx[i]) 
			      + (yp[i]-yy[i])*(yp[i]-yy[i]) );}
	  else
	    icode[i] = 1;


	  xdmi[i] = xa[i] + xx[i]*xe1[i] + yy[i]*xe2[i];
	  ydmi[i] = ya[i] + xx[i]*ye1[i] + yy[i]*ye2[i];
	  zdmi[i] = za[i] + xx[i]*ze1[i] + yy[i]*ze2[i];

	}
    }


  for (i=0;i<nlonv;i++)
    if (lco[i] && dist[i]<*dmin) 
      {
	*dmin= dist[i];*nelmin = i;
	*xmin=xdmi[i]; *ymin=ydmi[i]; *zmin=zdmi[i];
      }

}
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | histog                                                               |
  |         calculs d'histogrammes                                       |
  |======================================================================| */

void histog (int nbre,double *tab,double vmin, double vmax,
             int *thisto,int nbhisto)
{
  int i,n;
  double x,interv;

  for (i=0;i<nbhisto;i++) thisto[i]=0;
  interv=vmax-vmin;
  if (interv<1.e-16)
    {thisto[0]=nbre;}
  else
    for (i=0;i<nbre;i++)
      {
        x=(tab[i]-vmin)*nbhisto/interv;
        n=(int)x; if (n==nbhisto) n--;
        thisto[n]+=1;
      }

}
      
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | boite : calcul de la boite englobante                                |
  |                                                                      |
  |======================================================================| */

void boite2(int ndim,int npoins,double *coords, int nbcouf, double *coordf,
	    double dim_boite[])
{
  int i,npoins2,nbcouf2;
  double xmin,xmax,ymin,ymax,zmin,zmax,dx,dy,dz;

  npoins2 = 2*npoins; nbcouf2=2*nbcouf;

    xmin =  1.E10; ymin=  1.E6 ; zmin=  1.E6;
    xmax = -1.E10; ymax= -1.E6 ; zmax= -1.E6;
    
    for (i=0;i<npoins;i++)
    {
       xmin = min(*(coords+i),xmin);
       ymin = min(*(coords+i+npoins),ymin);
       zmin = min(*(coords+i+npoins2),zmin);
       xmax = max(*(coords+i),xmax);
       ymax = max(*(coords+i+npoins),ymax);
       zmax = max(*(coords+i+npoins2),zmax);
    }

    for (i=0;i<nbcouf;i++)
    {
       xmin = min(*(coordf+i),xmin);
       ymin = min(*(coordf+i+nbcouf),ymin);
       zmin = min(*(coordf+i+nbcouf2),zmin);
       xmax = max(*(coordf+i),xmax);
       ymax = max(*(coordf+i+nbcouf),ymax);
       zmax = max(*(coordf+i+nbcouf2),zmax);
    }


    dx = xmax-xmin; dy=ymax-ymin; dz=zmax-zmin;
    xmin -= (dx*0.01); ymin -= (dy*0.01); zmin -= (dz*0.01);
    xmax += (dx*0.01); ymax += (dy*0.01); zmax += (dz*0.01); 


    dx = xmax-xmin; dy=ymax-ymin; dz=zmax-zmin;
    if (dx<1.e-10) xmax+=1.e-4;
    if (dy<1.e-10) ymax+=1.e-4;
    if (dz<1.e-10) zmax+=1.e-4;

    xmin -= (dx*0.01); ymin -= (dy*0.01); zmin -= (dz*0.01);
    xmax += (dx*0.01); ymax += (dy*0.01); zmax += (dz*0.01); 

    dim_boite[0]=xmin; dim_boite[1]=xmax; 
    dim_boite[2]=ymin; dim_boite[3]=ymax; 
    dim_boite[4]=zmin; dim_boite[5]=zmax; 

/*    printf(" *** boite : boite englobante\n");
    printf("                    xmin = %f  xmax = %f \n",xmin,xmax);
    printf("                    ymin = %f  ymax = %f \n",ymin,ymax);
    printf("                    zmin = %f  zmax = %f \n",zmin,zmax);
*/    
}
      
