C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SOLRAY,SSI=0
                        SUBROUTINE SOLRAY
C                       *****************
C
C      ---------------------------------------
     * (NDIM,NPOINS,TMPS,NBRAYS,NRAYTS,VRAYTS)
C      ---------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNES DU SOLIDE AU TABLEAU VRAYTS            *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MODE     !  E ! D  ! SENS DE L'INTERPOLATION                      !
C !           !    !    !   = 1 PASSAGE SOLIDE --> FLUIDE              !
C !           !    !    !   = 2 PASSAGE FLUIDE --> SOLIDE              !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBRAYS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDE AVEC RAYT            !
C !  NRAYTS   ! TE ! D  ! NUMERO DES NOEUDS SOLIDES AVEC RAYT          !
C !  VRAYTS   ! TR !D M ! VALEUR AUX NOEUDS SOLIDES AVEC RAYT          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NDIM,NPOINS,NBRAYS,NRAYTS(NBRAYS)
      DOUBLE PRECISION TMPS(NPOINS),VRAYTS(NBRAYS,2)
C
C..Variables internes
      INTEGER N,NG
C
C***********************************************************************
C
C
C
C      1- PASSAGE DU SOLIDE VERS LE RAYONNEMENT
C      ========================================
C
       DO 100 N=1,NBRAYS
C
        NG = NRAYTS(N)
C
        VRAYTS(N,1) = TMPS(NG)
C
  100  CONTINUE
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,1010)
          DO 110 N=1,NBRAYS
             WRITE(NFECRA,1020) N,VRAYTS(N,1)
 110      CONTINUE
        ENDIF
C
C
C-------
C FORMAT
C-------
C
 1010 FORMAT(/,' *** SOLRAY : PASSAGE DES DONNEES DU SOLIDE',
     &         ' VERS LE RAYONNEMENT',/,
     &          9X,' N       VRAYTS(N,1) ')
 1020 FORMAT(5X,3X,I8,6X,E25.10)
C
C----
C FIN
C----
      END
          
