//Filename: hardware_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef HARDWARE_INFO_H
#define HARDWARE_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring motc1 = "";
Glib::ustring motc2 = "";
Glib::ustring motc3 = "";
Glib::ustring idec = "";
Glib::ustring vgac = "";
Glib::ustring souc1 = "";
Glib::ustring souc2 = "";
Glib::ustring ethc1 = "";
Glib::ustring ethc2 = "";

bool sbinpath = true;
Glib::ustring lspci_path1 = "/sbin/lspci";
Glib::ustring lspci_path2 = "lspci";

//lspci path check
void Lspci() {
	
  //check for the lspci
  std::fstream fin;
  fin.open("/bin/lspci",std::ios::in);
  if(fin.is_open()) {
    sbinpath = false;
  }
  fin.close();
	fin.open("/usr/bin/lspci",std::ios::in);
  if(fin.is_open()) {
    sbinpath = false;
  }
  fin.close();
}

//motherboard chipset
void Motherboard() {
	
	Lspci();
	Glib::ustring path;
	Glib::ustring grep_bridge = " | grep bridge";
	if (sbinpath == true)
		path = lspci_path1 + grep_bridge;
	else
		path = lspci_path2 + grep_bridge;
	
	FILE *file;

	char mot1[150];
	char mot2[150];
	char mot3[150];
	file = popen(path.c_str(), "r");
	fgets(mot1, 150, file);
	fgets(mot2, 150, file);
	fgets(mot3, 150, file);
	mot1[strlen(mot1)-1] = ' ';
	mot2[strlen(mot2)-1] = ' ';
	mot3[strlen(mot3)-1] = ' ';
	
	if (strstr(mot1, "Host bridge")) {
		motc1 = mot1;
		motc1.erase(0, 21);
	}
	
    if (strstr(mot2, "PCI bridge")) {
		motc2 = mot2;
		motc2.erase(0, 20);
	}
   
    if (strstr(mot3, "ISA bridge")) {
		motc3 = mot3;
		motc3.erase(0, 20);
	}
	
	pclose(file);
}

//IDE interface
void Idec() {
	
	Lspci();
	Glib::ustring path;
	Glib::ustring grep_ide = " | grep IDE";
	if (sbinpath == true)
		path = lspci_path1 + grep_ide;
	else
		path = lspci_path2 + grep_ide;
	
	FILE *file;
	
	char ide[150];
	file = popen(path.c_str(), "r");
	fgets(ide, 150, file);
	ide[strlen(ide)-1] = ' ';
   
	if (strstr(ide, "IDE")) {
		idec = ide;
		idec.erase(0, 23);
	}
	
	pclose(file);
}

//VGA controller
void Vgac() {
	
	Lspci();
	Glib::ustring path;
	Glib::ustring grep_vga = " | grep VGA";
	if (sbinpath == true)
		path = lspci_path1 + grep_vga;
	else
		path = lspci_path2 + grep_vga;
	
	FILE *file;
	
	char vga[150];
	file = popen(path.c_str(), "r");
	fgets(vga, 150, file);
	vga[strlen(vga)-1] = ' ';
	
	if (strstr(vga, "VGA")) {
		vgac = vga;
		vgac.erase(0, 35);
	}
	
	pclose(file);
}  

//sound card
void Soundc() {
	
	Lspci();
	Glib::ustring path;
	Glib::ustring grep_audio = " | grep audio";
	if (sbinpath == true)
		path = lspci_path1 + grep_audio;
	else
		path = lspci_path2 + grep_audio;
	
	FILE *file;
	
	char sou1[150];
	char sou2[150];
	file = popen(path.c_str(), "r");
	fgets(sou1, 150, file);
	fgets(sou2, 150, file);
	sou1[strlen(sou1)-1] = ' ';
	sou2[strlen(sou2)-1] = ' ';
	
	if (strstr(sou1, "audio")) {
		souc1 = sou1;
		souc1.erase(0, 37);
	}
   
    if (strstr(sou2, "audio")) {
		souc2 = sou2;
		souc2.erase(0, 37);
	}
	
	pclose(file);
}  

//Ethernet card
void Eth() {
	
	Lspci();
	Glib::ustring path;
	Glib::ustring grep_eth = " | grep Ethernet";
	if (sbinpath == true)
		path = lspci_path1 + grep_eth;
	else
		path = lspci_path2 + grep_eth;
	
	FILE *file;
	
	char eth1[150];
	char eth2[150];
	file = popen(path.c_str(), "r");
	fgets(eth1, 150, file);
	fgets(eth2, 150, file);
	eth1[strlen(eth1)-1] = ' ';
	eth2[strlen(eth2)-1] = ' ';
	
	if (strstr(eth1, "Ethernet")) {
		ethc1 = eth1;
		ethc1.erase(0, 29);
	}
   
    if (strstr(eth2, "Ethernet")) {
		ethc2 = eth2;
		ethc2.erase(0, 29);
	}

	pclose(file);
}


#endif //FILESYSTEM_INFO_H

//ghaefb
