//Filename: savetofile.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef SAVETOFILE_H
#define SAVETOFILE_H

#include <iostream>
#include <fstream>
#include <gtkmm/filechooserdialog.h>
#include "system_info.h"
#include "cpu_info.h"
#include "memory_info.h"
#include "ide_info.h"
#include "hardware_info.h"
#include "other_info.h"
#include "nvidia_info.h"


void Savetofile(Gtk::FileChooserDialog *filechooserdialog1, Glib::ustring sysinfo_version1) {
	
	int result = filechooserdialog1->run();

	//Handle the response:
	switch(result) {
		case(Gtk::RESPONSE_OK): {
			
		Glib::ustring str = filechooserdialog1->get_filename();
		locale_from_utf8(str);
		const char *filename = str.c_str();
			
		
		std::ofstream filesave(filename);
		
		filesave << "File generated by Sysinfo version " << sysinfo_version1;
		filesave << "\nYour system/computer information at: " << timedate;
			
		filesave << "\n\n\nSYSTEM INFORMATION";
		filesave << "\n - Operating system type -> [";
		locale_from_utf8(ostype);
		const char *ostype1 = ostype.c_str();
		filesave << ostype1 << "]";
		filesave << "\n - Distribution release -> [";
		locale_from_utf8(release);
		const char *release1 = release.c_str();
		filesave << release1 << "]";
		filesave << "\n - Kernel version -> [";
		locale_from_utf8(kerv);
		const char *kerv1 = kerv.c_str();
		filesave << kerv1 << "]";
		filesave << "\n - Kernel build time and date -> [";
		locale_from_utf8(kerd);
		const char *kerd1 = kerd.c_str();
		filesave << kerd1 << "]";
		filesave << "\n - Computer hostname -> [";
		locale_from_utf8(hostname);
		const char *hostname1 = hostname.c_str();
		filesave << hostname1 << "]";
		filesave << "\n - Computer domainname -> [";
		locale_from_utf8(domainname);
		const char *domainname1 = domainname.c_str();
		filesave << domainname1 << "]";
		filesave << "\n\nSome program versions";
		filesave << "\n - GNOME version installed -> [";
		locale_from_utf8(gversion);
		const char *gversion1 = gversion.c_str();
		filesave << gversion1 << "]";
		filesave << "\n - GCC version installed -> [";
		locale_from_utf8(gccv);
		const char *gccv1 = gccv.c_str();
		filesave << gccv1 << "]";
		filesave << "\n - Xorg version installed -> [";
		locale_from_utf8(xorgv);
		const char *xorgv1 = xorgv.c_str();
		filesave << xorgv1 << "]";
		filesave << "\n\nUptime";
		filesave << "\n - System running -> [";
		locale_from_utf8(uptime);
		const char *uptime1 = uptime.c_str();
		filesave << uptime1 << "]";
		
		filesave << "\n\n\nCPU INFORMATION";
		filesave << "\n - Vendor identification -> [";
		locale_from_utf8(cpuinfo1);
		const char *cpuinfo11 = cpuinfo1.c_str();
		filesave << cpuinfo11 << "]";
		filesave << "\n - Model name -> [";
		locale_from_utf8(cpuinfo2);
		const char *cpuinfo21 = cpuinfo2.c_str();
		filesave << cpuinfo21 << "]";
		filesave << "\n - Raw frequency -> [";
		locale_from_utf8(cpuinfo3);
		const char *cpuinfo31 = cpuinfo3.c_str();
		filesave << cpuinfo31 << "]";
		filesave << "\n - Cache size -> [";
		locale_from_utf8(cpuinfo4);
		const char *cpuinfo41 = cpuinfo4.c_str();
		filesave << cpuinfo41 << "]";
		filesave << "\n - Model number -> [";
		locale_from_utf8(cpuinfo5);
		const char *cpuinfo51 = cpuinfo5.c_str();
		filesave << cpuinfo51 << "]";
		filesave << "\n - Family number -> [";
		locale_from_utf8(cpuinfo6);
		const char *cpuinfo61 = cpuinfo6.c_str();
		filesave << cpuinfo61 << "]";
		filesave << "\n - Stepping -> [";
		locale_from_utf8(cpuinfo7);
		const char *cpuinfo71 = cpuinfo7.c_str();
		filesave << cpuinfo71 << "]";
		filesave << "\n - BogoMIPS -> [";
		locale_from_utf8(cpuinfo8);
		const char *cpuinfo81 = cpuinfo8.c_str();
		filesave << cpuinfo81 << "]";
		
		filesave << "\n\n\nMEMORY INFORMATION";
		filesave << "\n - Total memory - RAM -> [";
		locale_from_utf8(meminfo1);
		const char *meminfo11 = meminfo1.c_str();
		filesave << meminfo11 << "]";
		filesave << "\n - Swap memory -> [";
		locale_from_utf8(meminfo6);
		const char *meminfo61 = meminfo6.c_str();
		filesave << meminfo61 << "]";
		
		filesave << "\n\n\nIDE INFORMATION";
		filesave << "\nPrimary Master (hda) - " << hdamedia;
		filesave << "\n - Model name -> [";
		locale_from_utf8(hdamodel);
		const char *hdamodel1 = hdamodel.c_str();
		filesave << hdamodel1 << "]";
		filesave << "\n - Capacity -> [";
		locale_from_utf8(hdacapa);
		const char *hdacapa1 = hdacapa.c_str();
		filesave << hdacapa1 << "]";
		filesave << "\n - Cache -> [";
		locale_from_utf8(hdacache);
		const char *hdacache1 = hdacache.c_str();
		filesave << hdacache1 << "]";
		filesave << "\n\nPrimary Slave (hdb) - " << hdbmedia;
		filesave << "\n - Model name -> [";
		locale_from_utf8(hdbmodel);
		const char *hdbmodel1 = hdbmodel.c_str();
		filesave << hdbmodel1 << "]";
		filesave << "\n - Capacity -> [";
		locale_from_utf8(hdbcapa);
		const char *hdbcapa1 = hdbcapa.c_str();
		filesave << hdbcapa1 << "]";
		filesave << "\n - Cache -> [";
		locale_from_utf8(hdbcache);
		const char *hdbcache1 = hdbcache.c_str();
		filesave << hdbcache1 << "]";
		filesave << "\n\nSecondary Master (hdc) - " << hdcmedia;
		filesave << "\n - Model name -> [";
		locale_from_utf8(hdcmodel);
		const char *hdcmodel1 = hdcmodel.c_str();
		filesave << hdcmodel1 << "]";
		filesave << "\n - Capacity -> [";
		locale_from_utf8(hdccapa);
		const char *hdccapa1 = hdccapa.c_str();
		filesave << hdccapa1 << "]";
		filesave << "\n - Cache -> [";
		locale_from_utf8(hdccache);
		const char *hdccache1 = hdccache.c_str();
		filesave << hdccache1 << "]";
		filesave << "\n\nSecondary Slave (hdd) - " << hddmedia;
		filesave << "\n - Model name -> [";
		locale_from_utf8(hddmodel);
		const char *hddmodel1 = hddmodel.c_str();
		filesave << hddmodel1 << "]";
		filesave << "\n - Capacity -> [";
		locale_from_utf8(hddcapa);
		const char *hddcapa1 = hddcapa.c_str();
		filesave << hddcapa1 << "]";
		filesave << "\n - Cache -> [";
		locale_from_utf8(hddcache);
		const char *hddcache1 = hddcache.c_str();
		filesave << hddcache1 << "]";
		
		filesave << "\n\n\nHARDWARE INFORMATION";
		filesave << "\nMotherboard chipset";
		filesave << "\n - Host Bridge -> [";
		locale_from_utf8(motc1);
		const char *motc11 = motc1.c_str();
		filesave << motc11 << "]";
		filesave << "\n - PCI Bridge -> [";
		locale_from_utf8(motc2);
		const char *motc21 = motc2.c_str();
		filesave << motc21 << "]";
		filesave << "\n - ISA Bridge -> [";
		locale_from_utf8(motc3);
		const char *motc31 = motc3.c_str();
		filesave << motc31 << "]";
		filesave << "\n\nIDE interface";
		filesave << "\n - String -> [";
		locale_from_utf8(idec);
		const char *idec1 = idec.c_str();
		filesave << idec1 << "]";
		filesave << "\n\nVGA controller";
		filesave << "\n - Graphic card -> [";
		locale_from_utf8(vgac);
		const char *vgac1 = vgac.c_str();
		filesave << vgac1 << "]";
		filesave << "\n\nSound card/s";
		if (souc1 != "") {
		filesave << "\n - Card #1 -> [";
		locale_from_utf8(souc1);
		const char *souc11 = souc1.c_str();
		filesave << souc11 << "]"; }
		if (souc2 != "") {
		filesave << "\n - Card #2 -> [";
		locale_from_utf8(souc2);
		const char *souc21 = souc2.c_str();
		filesave << souc21 << "]"; }
		filesave << "\n\nEthernet card/s";
		if (ethc1 != "") {
		filesave << "\n - Card #1 -> [";
		locale_from_utf8(ethc1);
		const char *ethc11 = ethc1.c_str();
		filesave << ethc11 << "]"; }
		if (ethc2 != "") {
		filesave << "\n - Card #2 -> [";
		locale_from_utf8(ethc2);
		const char *ethc21 = ethc2.c_str();
		filesave << ethc21 << "]"; }
		
		
		filesave << "\n\n\nOTHER INFORMATION";
		filesave << "\nSound card";
		filesave << "\n - Model name -> [";
		locale_from_utf8(sound1);
		const char *sound11 = sound1.c_str();
		filesave << sound11 << "]";
		filesave << "\n - Details -> [";
		locale_from_utf8(sound2);
		const char *sound21 = sound2.c_str();
		filesave << sound21 << "]";
		filesave << "\n\nNvidia Graphic card";
		filesave << "\n - Model name -> [";
		locale_from_utf8(nvi_mod);
		const char *nvi_mod1 = nvi_mod.c_str();
		filesave << nvi_mod1 << "]";
		filesave << "\n - AGP rate -> [";
		locale_from_utf8(nvi_agp);
		const char *nvi_agp1 = nvi_agp.c_str();
		filesave << nvi_agp1 << "]";
		filesave << "\n - Faste writes -> [";
		locale_from_utf8(nvi_fw);
		const char *nvi_fw1 = nvi_fw.c_str();
		filesave << nvi_fw1 << "]";
		filesave << "\n - SBA -> [";
		locale_from_utf8(nvi_sba);
		const char *nvi_sba1 = nvi_sba.c_str();
		filesave << nvi_sba1 << "]";
		filesave << "\n - Driver details -> [";
		locale_from_utf8(nvi_ver);
		const char *nvi_ver1 = nvi_ver.c_str();
		filesave << nvi_ver1 << "]";
		filesave << "\n - Screen resolution -> [";
		locale_from_utf8(sw);
		locale_from_utf8(sh);
		const char *sw1 = sw.c_str();
		const char *sh1 = sh.c_str();
		filesave << sw1 << "x" << sh1 << "]";
		filesave << "\n\nInput devices";
		if (inp1 != "") {
		filesave << "\n - Device #1 -> [";
		locale_from_utf8(inp1);
		const char *inp11 = inp1.c_str();
		filesave << inp11 << "]"; }
		if (inp2 != "") {
		filesave << "\n - Device #2 -> [";
		locale_from_utf8(inp2);
		const char *inp21 = inp2.c_str();
		filesave << inp21 << "]"; }
		if (inp3 != "") {
		filesave << "\n - Device #3 -> [";
		locale_from_utf8(inp3);
		const char *inp31 = inp3.c_str();
		filesave << inp31 << "]"; }
		if (inp4 != "") {
		filesave << "\n - Device #4 -> [";
		locale_from_utf8(inp4);
		const char *inp41 = inp4.c_str();
		filesave << inp41 << "]"; }
		if (inp5 != "") {
		filesave << "\n - Device #5 -> [";
		locale_from_utf8(inp5);
		const char *inp51 = inp5.c_str();
		filesave << inp51 << "]"; }
		if (inp6 != "") {
		filesave << "\n - Device #6 -> [";
		locale_from_utf8(inp6);
		const char *inp61 = inp6.c_str();
		filesave << inp61 << "]"; }
		
		
		filesave << "\n";
			
		filechooserdialog1->hide();
	  	break;
	}
	case(Gtk::RESPONSE_CANCEL): {
		filechooserdialog1->hide();
		break;
	}
	default: {
		break;
	}
  }
}


#endif // SAVETOFILE_H

//ghaefb
