# -*- RPM-SPEC -*-
Summary: A utility for graphically configuring Logical Volumes
Name: system-config-lvm
Version: 1.1.15
Release: 1%{?dist}
URL: http://www.redhat.com/ 
Source0: %{name}-%{version}.tar.gz
License: GPLv2
Group: Applications/System
BuildArch: noarch
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Requires: usermode-gtk, /sbin/chkconfig
Requires: gnome-python2, pygtk2, pygtk2-libglade, gnome-python2-canvas 
Requires: gnome-python2-gnome, gnome-python2-bonobo
Requires: urw-fonts
Requires: lvm2 >= 2.00.20
Requires: python >= 2.3
BuildRequires: perl(XML::Parser) gettext intltool
BuildRequires: desktop-file-utils

%description
system-config-lvm is a utility for graphically configuring Logical Volumes

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install

desktop-file-install --vendor system --delete-original		\
  --dir %{buildroot}%{_datadir}/applications			\
  --remove-category Application					\
 --remove-category SystemSetup					\
  --remove-category X-Red-Hat-Base				\
  --add-category Settings					\
  --add-category System						\
  %{buildroot}%{_datadir}/applications/system-config-lvm.desktop

%find_lang %name

%clean
rm -rf %{buildroot}

#Replace the files line with the one commented out when translations are done
%files -f %{name}.lang
#%files

%defattr(-,root,root)
%doc COPYING
#%doc docs/ReleaseNotes
#%doc docs/html/*
%{_sbindir}/*
%{_bindir}/*
%{_datadir}/applications/system-config-lvm.desktop
%{_datadir}/system-config-lvm
%config(noreplace) %{_sysconfdir}/pam.d/system-config-lvm
%config(noreplace) %{_sysconfdir}/security/console.apps/system-config-lvm

%changelog
* Thu Sep 02 2010 Marek Grac <mgrac@redhat.com> - 1.1.15-1
- remove dependency on urw-fonts
- Resolves: #618207 - Unable to add new entry to /etc/fstab

* Wed Aug 11 2010 David Malcolm <dmalcolm@redhat.com> - 1.1.14-3
- recompiling .py files against Python 2.7 (rhbz#623401)

* Mon Jun 14 2010 Marek Grac <mgrac@redhat.com> - 1.1.14-2
- Resolves: #597593 - Cannot modify existing volume

* Tue Apr 27 2010 Marek Grac <mgrac@redhat.com> - 1.1.13-1
- Resolves: #584985 - Modification of volume size fails
- Resolves: #571302 - extending a LV creates a duplicate entry
- Resolves: #564554 - Deprecation warning when run from terminal
- Resolves: #578827 - Localization was initialized too late

* Wed Feb 17 2010 Marek Grac <mgrac@redhat.com> - 1.1.12-2
- Resolves: #565924 - requires gnome-python2-gnome and gnome-python2-bonobo

* Wed Feb 10 2010 Marek Grac <mgrac@redhat.com> - 1.1.12
- Resolves: #514268 - corrupts data when the extending device is remote
- Resolves: #523058 - system-config-lvm has wrong icon
- Resolves: #548057 - s-c-lvm should not change order in /etc/fstab 

* Mon Dec 14 2009 Marek Grac <mgrac@redhat.com> - 1.1.11
- Resolves: #455945 - resizing a lv results in the fstab entry being altered
- Resolves: #475434 - removing swap entries from fstab
- Resolves: #522200 - system-config-lvm crashes at startup

* Mon Sep 14 2009 Marek Grac <mgrac@redhat.com> - 1.1.10
- Resolves: #522315 - Fails when using pvcreate
- Resolves: #522448 - Request for rebuilding

* Fri Aug 21 2009 Marek Grac <mgrac@redhat.com> - 1.1.9
- Bugfix #474996: Unable to start without cluster.conf

* Thu Aug 20 2009 Marek Grac <mgrac@redhat.com> - 1.1.8-1
- Updated translations for several languages (transifex)
- Resolves: #243646 - Unable to modify logical partition with or_IN locale
- Resolves: #513322 - LVM volume cannot be created with Japanese locale
- Resolves: #243790 - Cannot delete LVM snapshot
- Resolves: #508898 - Bad label in left tree view
- Resolves: #508904 - (partially) add missing space '2TB' -> '2 TB'

* Wed Aug 12 2009 Marek Grac <mgrac@redhat.com> - 1.1.7-2
- Updated translations for several languages (transifex)
- Resolves: #432065 - Add ext4 and xfs functionality
- Resolves: #466812 - missing files from POTFILES.in (again)
- Resolves: #443581 - Use human readable sizing units
- Resolves: #443579 - traceback trying to add volume to VG with no selection
- Resolves: #474996 - extremely slow start with cluster.conf
- Resolves: #486699 - crashes when "command_names = 1" in lvm.conf
- Resolves: #466899 - system-config-lvm online resize fix

* Tue Aug 11 2009 Marek Grac <mgrac@redhat.com> - 1.1.6-2
- Updated translations for Spanish and Polish (transifex)
- Resolves: #494127 - system-config-lvm crashes on lvs with corelog
- Resolves: #475997 - crashed with 'IndexError: list index out of range'
- Resolves: #432065 - Add ext4 and xfs functionality
- Resolves: #447886, #466812 - minor l10n problems
 
* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.1.4-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Tue Jun 30 2009 Jeremy Katz <katzj@redhat.com> - 1.1.4-6
- Remove superfluous dependency on rhpl (#508951)

* Wed Feb 25 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.1.4-5.1
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Mon Dec 01 2008 Ignacio Vazquez-Abrams <ivazqueznet+rpm@gmail.com> - 1.1.4-4.1
- Rebuild for Python 2.6

* Mon Oct 27 2008 Matthias Clasen  <mclasen@redhat.com> 1.1.4-3.1
- Require usermode-gtk

* Fri Oct 10 2008 Matthias Clasen  <mclasen@redhat.com> 1.1.4-3.0
- Fix up BuildRequires

* Thu Oct  9 2008 Matthias Clasen  <mclasen@redhat.com> 1.1.4-2.0
- Properly install the desktop file (#442910)

* Tue Apr 25 2008 Jim Parsons <jparsons@redhat.com> 1.1.4-1.0
- Build for fedora

* Tue Mar 25 2008 Ryan McCabe <rmccabe@redhat.com> 1.1.3-2.0
- Fix for bz247325
- Restore missing translations.

* Wed Feb 06 2008 Ryan McCabe <rmccabe@redhat.com> 1.1.3-1.0
- Fix for bz332651

* Fri Sep 28 2007 Ryan McCabe <rmccabe@redhat.com> 1.1.2-1.0
- Update the spec, configure.in, and Makefile.am files
- Some other minor build tweaks
- Bump the version number

* Tue May 01 2007 Stanko Kupcevic <kupcevic@redhat.com> 1.1.1-1.0
- Update pam file
- Update translation files

* Mon Jan 22 2007 Stanko Kupcevic <kupcevic@redhat.com> 1.0.22-1.0
- Fixed 223518 (s-c-lvm fails to probe CS5 properly)
- fixes bz223518

* Mon Dec 18 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.21-1.0
- Fixed 216569 (some messages not localized)
- Fixed 218126 (Can't resize ext3 fs online)
- fixes bz216569, bz218126

* Mon Oct 16 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.20-1.0
- Updated translation files

* Mon Jul 10 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.19-1.0
- Version bump

* Thu Jun 01 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.18-1.0
- Version bump

* Fri May 12 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.17-1.0
- Fixes for 175077, 171117, 175131, 176967, enable mirroring, 159455, 159456

* Thu Feb 16 2006 Jim Parsons <jparsons@redhat.com> 1.0.16-1.0
- Disabled mirroring support in UI.

* Mon Feb 14 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.14-1.0
- Fixes for bz180281, 159457, 180269. Mirroring support available with
  constants in lvmui_constants file by setting MIRRORING_UI_SUPPORT to True

* Fri Feb 10 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.13-1.0
- Fix failure to display all unused space

* Mon Feb 06 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.12-1.0
- Under certain conditions, labels might show partially

* Fri Feb 03 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.11-1.0
- Fixes for bz175077,169860,178128,161917,171117,175131,178195 

* Thu Jan 05 2006 Stanko Kupcevic <kupcevic@redhat.com> 1.0.10-1.0
- Fix for bz176967

* Fri Dec 2 2005 Jim Parsons <jparsons@redhat.com> 1.0.9-1.0
- Removed cLVM test. 

* Mon Nov 14 2005 Jim Parsons <jparsons@redhat.com> 1.0.8-1.0
- Fixes for bz171744,171746,171747,171751,171753,171754,171755,171758,159457

* Mon Sep 26 2005 Jim Parsons <jparsons@redhat.com> 1.0.7-1.0
- Version bump.

* Mon Sep 26 2005 Jim Parsons <jparsons@redhat.com> 1.0.6-1.0
- Version bump for FC.

* Wed Sep 13 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.5-1.0
- Fix for bz167671.

* Wed Sep 08 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.4-1.0
- Fix for bz167662, 167643.

* Mon Aug 15 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.3-1.0
- Fix for bz159457: Temporary removal of mirroring support.

* Tue Aug 02 2005 Jim Parsons <jparsons@redhat.com> 1.0.2-1.0
- Major new release that supports snapshotting, mirroring, and resizing.

* Mon Jul 26 2005 Stanko Kupcevic <kupcevic@redhat.com> 0.9.52-1.0
- Alpha release: Strings, minor bugs, GFS, GFS2, mirrors on diff HDs

* Fri Jul 15 2005 Stanko Kupcevic <kupcevic@redhat.com> 0.9.51-1.0
- Alpha release: mirroring, multipath, GPT, zoom, ...

* Tue Jun 21 2005 Stanko Kupcevic <kupcevic@redhat.com> 0.9.50-1.0
- Alpha release: snapshotting, resizing, lv properties

* Thu May 26 2005 Jim Parsons <jparsons@redhat.com> 0.9.33-1.0
- Version bump for rhel

* Thu May 26 2005 Jim Parsons <jparsons@redhat.com> 0.9.32-1.0
- Fix for 158872; x86_64 pam file path

* Mon May 23 2005 Jim Parsons <jparsons@redhat.com> 0.9.31-1.0
- Version bump for RHEL4

* Mon May 23 2005 Jim Parsons <jparsons@redhat.com> 0.9.30-1.0
- Fixed bz157744

* Tue May 17 2005 Jim Parsons <jparsons@redhat.com> 0.9.29-1.0
- Version Bump

* Tue May 17 2005 Jim Parsons <jparsons@redhat.com> 0.9.28-1.0
- Version Bump

* Tue May 17 2005 Jim Parsons <jparsons@redhat.com> 0.9.27-1.0
- Fix for bz154458,153042,155438,157743

* Thu May 05 2005 Jim Parsons <jparsons@redhat.com> 0.9.26-1.0
- Fix for bz156957

* Thu Apr 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.25-1.0
- Version bump.

* Thu Apr 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.24-1.0
- Changed permissions on Icon file.

* Thu Apr 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.23-1.0
- Subtle change to .desktop file moves app launcher to system settings

* Wed Apr 06 2005 Jim Parsons <jparsons@redhat.com> 0.9.22-1.0
- Version Bump.

* Wed Apr 06 2005 Jim Parsons <jparsons@redhat.com> 0.9.21-1.0
- Changed path to lvm command for Fedora.

* Mon Feb 21 2005 Jim Parsons <jparsons@redhat.com> 0.9.20-1.0
- Added desktop icon file.

* Mon Feb 21 2005 Jim Parsons <jparsons@redhat.com> 0.9.19-1.0
- Added desktop file.

* Wed Nov 24 2004 Jim Parsons <jparsons@redhat.com> 0.9.18-1.0
- Adjustments to configure.in so this builds in fedora as well as RHEL.

* Tue Nov 23 2004 Jim Parsons <jparsons@redhat.com> 0.9.17-1.0
- Fixes for bz140413 and bz 140562

* Tue Nov 23 2004 Jim Parsons <jparsons@redhat.com> 0.9.16-1.0
- Strips whitespace off of all incoming command handler args.

* Tue Nov 23 2004 Jim Parsons <jparsons@redhat.com> 0.9.15-1.0
- Fixes for two small nits.

* Mon Nov 22 2004 Jim Parsons <jparsons@redhat.com> 0.9.14-1.0
- Fixes for bz140413, 140386, 140355, 140359, 140419, 138103, 140529.

* Thu Nov 18 2004 Jim Parsons <jparsons@redhat.com> 0.9.12-1.0
- Fix for bz137041, 139711 plus require for new RHPL pkg.

* Tue Nov 16 2004 Jim Parsons <jparsons@redhat.com> 0.9.11-1.0
- Fix for bz138019 -- extent segs correct for stripe corner case

* Mon Nov 15 2004 Jim Parsons <jparsons@redhat.com> 0.9.10-1.0
- Fixes for bz137291, 138008, and 137122

* Thu Nov 11 2004 Jim Parsons <jparsons@redhat.com> 0.9.9-1.0
- Fixes for bz137111, 138887, 138006,138097. Also removed fstab checkbox
  and added it as a feature at 138831 for next release.

* Wed Nov 10 2004 Jim Parsons <jparsons@redhat.com> 0.9.8-1.0
- Fixes for bz137930, 137872, 137292, 137052, 137054

* Tue Nov 9 2004 Jim Parsons <jparsons@redhat.com> 0.9.7-1.0
- Improved handling of garbage in the size string -- try catch in place
  now that traps for ValueError 
- Improved handling of sizes/units for new LV creation
- Now 'Unused' sections in Logical View of VGs, are unselectable. Also,
  if there are no LVs associated with a VG, the Logical view buttonpanel 
  button for "Remove selected extents" is set to not be sensitive, as 
  there is nothing to remove from this case.
- Revamped PV removal code, so that proper checking is done before moving
  extents.
- Added new method that checks if dm-mirror mod is loaded in kernel. If not,
  an appropriate error message is generated.
- Fixed tree selection mechanism by preventing multiple VG selection.
- Handle delete-event on VG creation dialog, so it is hidden.
- Fixed bz137099, 137071, 137869, 137434, 138085

* Mon Nov 1 2004 Jim Parsons <jparsons@redhat.com> 0.9.6-1.0
- Changed gtk.mainloop to gtk.main to address bz137288. 

* Mon Nov 1 2004 Jim Parsons <jparsons@redhat.com> 0.9.5-1.0
- Added Menubar to address bz137293. 

* Fri Oct 29 2004 Jim Parsons <jparsons@redhat.com> 0.9.4-1.0
- Fixes for bz137190 empty vg name field validation, 
- bz137048 removes resizable checkbox for vgcreate, 
- bz137208 unique vg name checking fixed, 
- bz137107 remove autobackup checkbox, 
- bz137231 warn on extend vg when init'ing a new entity. 

* Tue Oct 26 2004 Jim Parsons <jparsons@redhat.com> 0.9.3-1.0
- Version bump. 

* Tue Oct 26 2004 Jim Parsons <jparsons@redhat.com> 0.9.2-1.0
- Fixed bz137118 warningMessage error. This is a critical mustfix. 

* Wed Oct 20 2004 Jim Parsons <jparsons@redhat.com> 0.9.1-2.5
- Fixed size selection issue, bz136217. 

* Wed Sep 01 2004 Jim Parsons <jparsons@redhat.com> 0.9.1-1
- Initial copy
