// start of definition 
if (!window.TabbrowserOverlay) {
	
// static class "TabbrowserOverlay" 
var TabbrowserOverlay =
{
	lastSent_bookmarks_command : 0,
	lastSent_bookmarks_click   : 0,
	lastSent_history_command   : 0,
	lastSent_history_click     : 0,

	get service()
	{
		return TabbrowserService;
	},
	
	onBeforeInit : function() 
	{
		var nodes, i;


		window.__tabextensions__goQuitApplication = window.goQuitApplication;
		window.goQuitApplication = this.goQuitApplication;

		if (this.service.isNewTypeBrowser) { // Firefox
			if (this.service.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith;
			}

			if ('ctrlNumberTabSelection' in window)
				window.ctrlNumberTabSelection = this.ctrlNumberTabSelection;
		}
		else {
			if (this.service.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith_old;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith_old;
			}
		}

		window.BrowserOpenTab = this.BrowserOpenTab;

		// for Netscape 7
		nodes = this.service.browsers;
		for (i = 0; i < nodes.length; i++)
			nodes[i].newTab = this.BrowserOpenTab;

		if (window.BrowserCloseTabOrWindow) {
			window.BrowserCloseTabOrWindow = this.BrowserCloseTabOrWindow;
		}



		// Link Click
		if ('contentAreaClick' in window) {
			window.__tabextensions__contentAreaClick = window.contentAreaClick;
			window.contentAreaClick = this.contentAreaClick;
			if (this.service.browser)
				this.service.browser.hookContentAreaClick = true;
		}
		if ('handleLinkClick' in window) {
			window.__tabextensions__handleLinkClick = window.handleLinkClick;
			window.handleLinkClick = this.handleLinkClick;
		}
		// Mail&News (1.4 or later)
		if ('messagePaneOnClick' in window) {
			document.getElementById('messagepane').removeEventListener('click', messagePaneOnClick, true);
			window.__tabextensions__messagePaneOnClick = window.messagePaneOnClick;
			window.messagePaneOnClick = this.messagePaneOnClick;
			document.getElementById('messagepane').addEventListener('click', window.messagePaneOnClick, true);
		}



		// Toolbar Items
		if (this.service.isNewTypeBrowser) {
			nodes = document.getElementsByTagName('toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].__tabextensions__insertItem = nodes[i].insertItem;
				nodes[i].insertItem = this.insertItem;
				nodes[i].addEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
			}
		}



		// Location Bar
		if ('BrowserLoadURL' in window) {
			window.__tabextensions__BrowserLoadURL = window.BrowserLoadURL;
			window.BrowserLoadURL = this.BrowserLoadURL;

			if (this.service.isNewTypeBrowser) {
				window.__tabextensions__handleURLBarCommand = window.handleURLBarCommand;
				window.handleURLBarCommand = this.handleURLBarCommand;
			}
		}



		// Bookmarks
		window.OpenBookmarkURL = this.openBookmarkURL;
		window.OpenBookmarkGroupFromResource = this.service.openBookmarkGroup;
		window.addBookmarkForTabBrowser = this.addBookmarkForTabBrowser;
		if ('BookmarksUtils' in window) {
			BookmarksUtils.__tabextensions__addBookmark = BookmarksUtils.addBookmark;
			BookmarksUtils.addBookmark = this.addBookmark;
			BookmarksUtils.__tabextensions__createBookmark = BookmarksUtils.createBookmark;
			BookmarksUtils.createBookmark = this.createBookmark;
			BookmarksUtils.addBookmarkForTabBrowser = this.addBookmarkForTabBrowser;
		}
		if ('BookmarksMenu' in window) {
			BookmarksMenu.__tabextensions__loadBookmark = BookmarksMenu.loadBookmark;
			BookmarksMenu.loadBookmark = this.loadBookmark;
			BookmarksMenu.__tabextensions__loadBookmarkMiddleClick = BookmarksMenu.loadBookmarkMiddleClick;
			BookmarksMenu.loadBookmarkMiddleClick = this.loadBookmarkMiddleClick;
		}
		if ('BookmarksCommand' in window) {
			BookmarksCommand.__tabextensions__openBookmark = BookmarksCommand.openBookmark;
			BookmarksCommand.openBookmark = this.BookmarksCommandOpenBookmark;
			BookmarksCommand.__tabextensions__createContextMenu = BookmarksCommand.createContextMenu;
			BookmarksCommand.createContextMenu = this.BookmarksCommandCreateContextMenu;
		}

		if (this.service.isNewTypeBrowser) { // Firefox
			if ('BookmarksCommand' in window)
				BookmarksCommand.openGroupBookmark = this.openGroupBookmark;

			nodes = document.getElementsByTagName('bookmarks-toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].toolbar.setAttribute('oncommand', 'TabbrowserOverlay.openBookmarkURL(event.originalTarget, this.database, event, this);');
				nodes[i].toolbar.setAttribute('onclick', 'TabbrowserOverlay.openBookmarkURL(event.originalTarget, this.database, event, this);');
			}
		}

		nodes = document.getElementsByTagNameNS(this.service.XULNS, 'bookmarks-tree');
		for (i = 0; i < nodes.length; i++)
		{
			if ('openItemClick' in nodes[i]) {
				nodes[i].__tabextensions__openItemKey  = nodes[i].openItemKey;
				nodes[i].__tabextensions__openItemClick = nodes[i].openItemClick;
			}
			nodes[i].openItemKey   = this.openBookmarkItemClickOrKey;
			nodes[i].openItemClick = this.openBookmarkItemClickOrKey;

			// old implementation
			nodes[i].__tabextensions__openItem = nodes[i].openItem;
			nodes[i].openItem = (this.service.isNewTypeBrowser) ? this.openBookmarkItemClickOrKey : this.openBookmarkItem ; // Firefox

			if (!nodes[i].tree.getAttribute('onclick'))
				nodes[i].tree.setAttribute('onclick', 'if (event.button != 1) return; '+nodes[i].tree.getAttribute('ondblclick'));

			nodes[i].validOpenClickConditions = this.validOpenClickConditions;
		}

		// Bookmarks and Text Zoom
		if ('ZoomManager' in window) {
			ZoomManager.prototype.__defineSetter__(
				'textZoom',
				function(aZoom)
				{
					// implementations in original code
					if (aZoom < this.MIN || aZoom > this.MAX)
						throw Components.results.NS_ERROR_INVALID_ARG;

					getMarkupDocumentViewer().textZoom = aZoom / 100;

					// TBE extra feature
					try {
						var TS = TabbrowserService;
						var b  = TS.browser;
						var t  = b.mCurrentTab;
						if (!t.mTabInfo.bookmarkID ||
							t.mTabInfo.bookmarkURI != t.mTabInfo.loadingURI ||
							!TS.isBookmarked(t.mTabInfo.bookmarkID))
							t.mTabInfo.textZoomURI = null;
						else
							b.setTextZoomFor(t, aZoom, t.mTabInfo.loadingURI);
					}
					catch(e) {
					}
				}
			);
		}




		// History
		if ('gHistoryTree' in window && !this.service.isNewTypeBrowser) {
			if ('OpenURL' in window) {
				window.__tabextensions__OpenURL = window.OpenURL;
				window.OpenURL = this.OpenURL;
			}
			if ('historyOnClick' in window) {
				window.__tabextensions__historyOnClick = window.historyOnClick;
				window.historyOnClick = this.historyOnClick;
			}
		}
		if (this.service.isNewTypeBrowser && 'OpenURL' in window) {
			window.__tabextensions__OpenURL = window.OpenURL;
			window.OpenURL = this.OpenURL;
		}
		if ('gotoHistoryIndex' in window) {
//			window.__tabextensions__gotoHistoryIndex = window.gotoHistoryIndex;
			window.gotoHistoryIndex = this.gotoHistoryIndex;

			if (navigator.platform.indexOf('Mac') < 0) {
				var buttons = {
						back    : null,
						forward : null
					};

				nodes = document.getElementsByAttribute('oncommand', 'gotoHistoryIndex(event);');
				for (i = 0; i < nodes.length; i++)
				{
					nodes[i].addEventListener('click', gotoHistoryIndex, true);
					if (nodes[i].id == 'back-button')
						buttons.back = nodes[i];
					else if (nodes[i].id == 'forward-button')
						buttons.forward = nodes[i];
				}

				// back and forward buttons
				if (this.service.isNewTypeBrowser) {
					gTSToolbarItemsInsertedEventListener(null, 'back-button');
					gTSToolbarItemsInsertedEventListener(null, 'forward-button');
				}
				else {
					for (i in buttons) {
						if (buttons[i]) continue;

						buttons[i] = document.getElementById(i+'-button');
						if (buttons[i])
							buttons[i].addEventListener('click', gotoHistoryIndex, true);
					}
				}
			}
		}



		// JavaScript "window.open()"
		if (window.open && this.service.isBrowserWindow) {
			window.__tabextensions__open = window.open;
			window.open = eval(this.service.newWindowOpen.toSource());
			window.openBrowserTab = this.service.openBrowserTab;
			window.shouldOpenBrowserTab = this.service.shouldOpenBrowserTab;
			if (window.openDialog) {
				window.__tabextensions__openDialog = window.openDialog;
				window.openDialog = this.service.newOpenDialog;
			}
		}



		// Context Menu
		if ('nsContextMenu' in window) {
			nsContextMenu.prototype.__tabextensions__initItems = nsContextMenu.prototype.initItems;
			nsContextMenu.prototype.initItems = this.initItems;

			var contextmenu = document.getElementById('contentAreaContextMenu') || document.getElementById('messagePaneContext') ;
			contextmenu.addEventListener('popupshowing', this.onContentAreaContextMenuShowing, false);
		}



		// view source
		if ('BrowserViewSourceOfDocument' in window) {
			window.__tabextensions__BrowserViewSourceOfDocument = window.BrowserViewSourceOfDocument;
			window.BrowserViewSourceOfDocument = function(aDocument)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserService.viewSourceOf('document', aDocument) : __tabextensions__BrowserViewSourceOfDocument(aDocument);
			};
		}
		if ('BrowserViewSourceOfURL' in window) {
			window.__tabextensions__BrowserViewSourceOfURL = window.BrowserViewSourceOfURL;
			window.BrowserViewSourceOfURL = function(aURI, aCharset, aPageCookie)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserService.viewSourceOf('uri', aURI, aCharset, aPageCookie) : __tabextensions__BrowserViewSourceOfURL(aURI, aCharset, aPageCookie);
			};
		}
		if('nsContextMenu' in window) {
			nsContextMenu.prototype.__tabextensions__viewPartialSource = nsContextMenu.prototype.viewPartialSource;
			nsContextMenu.prototype.viewPartialSource = function(aContext)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserService.viewSourceOf('partial', aContext) : this.__tabextensions__viewPartialSource(aContext);
			};
		}



		// kill original confirming
		if ('WindowIsClosing' in window) {
			window.WindowIsClosing = function() { return true; };
		}
		if ('BrowserTryToCloseWindow' in window) {
			window.BrowserTryToCloseWindow = function() {
				if (TabbrowserService.onWindowClose()) {
					if ('BrowserCloseWindow' in window)
						window.BrowserCloseWindow();
					else
						window.close();
				}

				return true;
			};
		}
	},
 
	onBeforeDestruct : function() 
	{
		// Context Menu
		if ('nsContextMenu' in window) {
			var contextmenu = document.getElementById('contentAreaContextMenu') || document.getElementById('messagePaneContext') ;
			contextmenu.removeEventListener('popupshowing', this.onContentAreaContextMenuShowing, false);
		}

		if (this.service.isNewTypeBrowser) {
			var toolbars = document.getElementsByTagName('toolbar');
			for (i = 0; i < toolbars.length; i++)
				toolbars[i].removeEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
		}
	},
 
	// Links 
	
	contentAreaClick : function(aEvent, aFieldNormalClicks) 
	{
		// ignore clicks on XUL elements (Mozilla 1.4 or later?)
		if (aEvent.target.ownerDocument.defaultView == window)
			return true;

		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			nav  = TS.browserWindow,
			b    = (nav ? nav.TabbrowserService.browser : null ),
			node = (
					findParentNode(aEvent.target, 'a') ||
					findParentNode(aEvent.target, 'area') ||
					findParentNode(aEvent.target, 'link') ||
					null
				),
			parentEventListener = TS.findParentNodeByProp(aEvent.originalTarget, '__tabextensions__on'+aEvent.type, 'function');

		// ignore clicks not on a link
		if (!node || (aEvent.type == 'click' && aEvent.button > 1)) {
			if (parentEventListener)
				parentEventListener.__tabextensions__shouldStop = true;
			return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);
		}

		// ignore canceled events
		if (
			TS.getPref('javascript.enabled') &&
			Components.lookupMethod(node.ownerDocument.defaultView, 'top').call(node.ownerDocument.defaultView)
				.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
				.getInterface(Components.interfaces.nsIWebNavigation)
				.QueryInterface(Components.interfaces.nsIDocShell)
				.allowJavascript &&
			!('__tabextensions__allowed' in aEvent) &&
			TO.isClickEventCanceled(aEvent, aFieldNormalClicks)
			) {
			if (parentEventListener)
				parentEventListener.__tabextensions__shouldStop = true;
			return false;
		}



		// get URI, REFERRER, TARGET
		var linkInfo = TO.getLinkInfo(node);

		linkInfo.referrerBlocked = (b && b.mCurrentTab.mTabInfo.referrerBlocked) || (linkInfo.originalURI != linkInfo.uri) ;
		if (linkInfo.referrerBlocked)
			linkInfo.referrer = null;

		linkInfo.browser           = b;
		linkInfo.fieldNormalClicks = aFieldNormalClicks;


		// if there is no browser window...
		if (!b) {
			TS.markLinkVisited(linkInfo.uri, node);
			if (!linkInfo.uri.match(/^javascript:/)) {
				window.openDialog(
					TS.browserURI,
					'_blank',
					'chrome,all,dialog=no',
					linkInfo.uri,
					null,
					linkInfo.referrer
				);
				TS.stopEvent(aEvent, true);
			}
			else if (parentEventListener)
					parentEventListener.__tabextensions__shouldVoid = true;
			return true;
		}

try {
		TO.computeActionForLink(linkInfo, aEvent);
}
catch(e) { if (TS.debug) dump('contentAreaClick => computeActionForLink:\n'+e+'\n'); }

		// prevent to open new tab
		if (
			(
				linkInfo.causedByLocked ||
				linkInfo.causedByAlwaysNewTab ||
				linkInfo.causedByMiddleClick ||
				(linkInfo.newTypeBrowserOpenWindow && TS.winHookMode > 0)
			) &&
			TO.blockSameURLTab(linkInfo.uri, b)
			) {
			TS.stopEvent(aEvent, true);
			return true;
		}

try {
		var retVal = TO.doLinkAction(linkInfo, aEvent);
}
catch(e) { if (TS.debug) dump('contentAreaClick => doLinkAction:\n'+e+'\n'); }

		if (parentEventListener)
			parentEventListener.__tabextensions__shouldStop = true;

		return retVal;
	},
	
	// ignore canceled events 
	isClickEventCanceled : function(aEvent, aFieldNormalClicks)
	{
		var targetNode = this.service.findParentNodeByProp(aEvent.originalTarget, '__tabextensions__on'+aEvent.type, 'function');

		if (
			!targetNode ||
			targetNode.__tabextensions__isNotLink ||
			targetNode.__tabextensions__shouldStop
			)
			return false;


		// Mozilla fails to hand nsIDOMEvent object to callback function.
		// So we have to create a dummy object like the event object.
		var event = {
				__tabextensions__allowed : true
			};
		for (var i in aEvent)
		{
			try {
				event[i] = typeof aEvent[i] == 'function' ? function() {} : aEvent[i] ;
			}
			catch(e) {
			}
		}

		targetNode.__tabextensions__shouldStop = true;
//dump('stop event\n');

		window.setTimeout(
			function(aEvent, aFieldNormalClicks)
			{
				// wait the function is completely evaluated
				if ('__tabextensions__currentNode' in targetNode.ownerDocument.defaultView) {
					window.setTimeout(arguments.callee, 0, aEvent, aFieldNormalClicks);
					return;
				}

				var canceled = targetNode.__tabextensions__retVal;
//dump('returned value : '+(canceled === void(0) ? 'undefined' : canceled )+'\n');
				canceled = (canceled === void(0)) ? false : !canceled ;
				targetNode.__tabextensions__retVal = null;
				if (!canceled)
					contentAreaClick(aEvent, aFieldNormalClicks);
			},
			0,
			event,
			aFieldNormalClicks
		);

		return true;
	},
 
	blockSameURLTab : function(aURI, aTabBrowser) 
	{
		if (!this.service.preventSameURLTab) return false;

		var b = aTabBrowser || this.browser ;

		if (b.mCurrentTab.mTabInfo.loadingURI == aURI) return true;

		for (var i in b.mTabs)
		{
			if (b.mTabs[i].mTabInfo.loadingURI != aURI) continue;

			this.service.popupAlert(this.service.strbundle.GetStringFromName('status_same_uri_tab_exists'));

			if (!aLinkInfo.loadInBackground) {
				b.selectedTab = b.mTabs[i];
				b.scrollTabbarTo(b.selectedTab);
				b.setFocusInternal();
			}
			return true;
		}
		return false;
	},
 
	getLinkInfo : function(aLinkNode) 
	{
		// uri
		var uri = (
				aLinkNode.href ||
				aLinkNode.getAttributeNS(this.service.XHTMLNS, 'href') ||
				aLinkNode.getAttributeNS(this.service.XLinkNS, 'href') ||
				aLinkNode.getAttribute('href') ||
				''
			);
		var originalURI = uri;
		// for accesses from ime.nu(www.2ch.net), etc....
		var realURI = this.service.getRealURI(uri);
		if (realURI) uri = realURI;

		// referrer
		var w = aLinkNode.ownerDocument.defaultView;
		var sourceURI = Components.lookupMethod(w, 'location').call(w).href;

		// link target
		var nameInfo = this.getTargetForLink(aLinkNode);

		return {
			node        : aLinkNode,
			window      : w,

			uri         : uri,
			originalURI : originalURI,

			source      : sourceURI,
			referrer    : this.service.makeURIFromSpec(sourceURI),

			target      : nameInfo.target,
			realTarget  : nameInfo.realTarget
		};
	},
	
	getTargetForLink : function(aLinkNode) 
	{
		if (!aLinkNode) return { name : '', realName : '' };

		var realName = (
				aLinkNode.target ||
				(
					'getAttributeNS' in aLinkNode &&
					(
						aLinkNode.getAttributeNS(this.service.XHTMLNS, 'target') ||
						aLinkNode.getAttributeNS(this.service.XLinkNS, 'target')
					)
				) ||
				aLinkNode.getAttribute('target') ||
				''
			);

		var name = realName.replace(/^_(self|top|parent|content)$/i, '').replace(/^_main$/, '');

		// find "target" attribute of "base" element
		var base = aLinkNode.ownerDocument.getElementsByTagName('base');
		if (!base.length) base = aLinkNode.ownerDocument.getElementsByTagNameNS(this.service.XHTMLNS, 'base');
		if (!realName && base.length) {
			var tempRealName;
			for (var i = base.length-1; i > -1 ; i--)
				if ((tempRealName = (
						base[i].target ||
						base[i].getAttributeNS(this.XHTMLNS, 'target') ||
						base[i].getAttributeNS(this.XLinkNS, 'target') ||
						base[i].getAttribute('target') ||
						''
					))) {
					realName = tempRealName;
					name = realName.replace(/^_(self|top|parent|content)$/i, '').replace(/^_main$/, '');
				}
		}

		return { target : name, realTarget : realName };
	},
  
	computeActionForLink : function(aLinkInfo, aEvent) 
	{
		aLinkInfo.newTypeBrowserOpenWindow = false;
		if (
			this.service.isNewTypeBrowser &&
			(aEvent.type != 'click' || aEvent.button == 0) &&
			!aEvent.ctrlKey && !aEvent.metaKey &&
			(this.service.getPref('ui.key.saveLink.shift') ? aEvent.altKey : aEvent.shiftKey ) // save modifier
			)
			aLinkInfo.newTypeBrowserOpenWindow = true;


		aLinkInfo.causedByMiddleClick = (
				this.service.getPref('browser.tabs.opentabfor.middleclick') &&
				aEvent.type == 'click' &&
				(
					aEvent.button == 1 ||
					(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
				)
			);

		aLinkInfo.causedByLocked = (
				aLinkInfo.browser &&
				aLinkInfo.browser.localName == 'tabbrowser' &&
				aLinkInfo.browser.mCurrentTab.mTabInfo.locked &&
				aLinkInfo.browser.contentDocument &&
				aLinkInfo.browser.contentDocument.defaultView == Components.lookupMethod(aEvent.target.ownerDocument.defaultView, 'top').call(aEvent.target.ownerDocument.defaultView)
			);

		aLinkInfo.causedByAlwaysNewTab = (
				aLinkInfo.browser &&
				aLinkInfo.browser.currentURI.spec == 'about:blank'
			) ? false : this.service.getPref('browser.tabs.opentabfor.anylink') ;

		aLinkInfo.causedByOuterLink = this.service.getPref('browser.tabs.opentabfor.outerlink');
		if (aLinkInfo.causedByOuterLink) {
			if (this.service.isSameHost(aLinkInfo.uri, aLinkInfo.source))
				aLinkInfo.causedByOuterLink = false;
		}

		aLinkInfo.causedByTargetAttribute =
			(
				aLinkInfo.target &&
				(
					(
						this.service.winHookMode > 0 ||
						this.service.getPref('browser.tabs.opentabfor.linkclick')
					) &&
					!this.service.getPref('browser.block.target_new_window')
				) &&
				!this.service.getFrameByName(Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window), aLinkInfo.target)
			);

		// reverse behavior
		if (this.service.isNewTypeBrowser && aLinkInfo.newTypeBrowserOpenWindow &&
			!this.service.getPref('ui.key.saveLink.shift') &&
			aEvent.shiftKey &&
			(
				aLinkInfo.causedByLocked ||
				aLinkInfo.causedByAlwaysNewTab ||
				aLinkInfo.causedByTargetAttribute ||
				aLinkInfo.causedByMiddleClick ||
				this.service.winHookMode > 1
			)
			)
			aLinkInfo.newTypeBrowserOpenWindow = false;

		aLinkInfo.loadInBackground = this.service.getPref(aLinkInfo.causedByMiddleClick ? 'browser.tabs.extensions.loadInBackgroundMiddleClick' : 'browser.tabs.extensions.loadInBackgroundLinks' );
		if (aEvent.shiftKey && !aLinkInfo.newTypeBrowserOpenWindow)
			aLinkInfo.loadInBackground = !aLinkInfo.loadInBackground;
	},
 
	doLinkAction : function(aLinkInfo, aEvent) 
	{
		var uri  = aLinkInfo.uri;
		var node = aLinkInfo.node;
		var b    = aLinkInfo.browser;
		var nav  = this.service.browserWindow;

		var i;

		if (
			uri &&
			uri.match(/^javascript:/i) &&
			!uri.match(/^javascript:window.__tabextensions__LastEvent/i) &&
			!aLinkInfo.causedByLocked &&
			!aLinkInfo.causedByAlwaysNewTab &&
			!aLinkInfo.causedByMiddleClick &&
			(!aLinkInfo.newTypeBrowserOpenWindow || this.service.winHookMode < 1)
			) {
			uri = 'javascript:void(window.__tabextensions__LastEvent = (new Date()).getTime());'+uri.replace(/^javascript:/i, '');

			if (node.href)
				node.href = uri;
			else if (node.getAttributeNS(this.service.XHTMLNS, 'href'))
				node.setAttributeNS(this.service.XHTMLNS, 'xhtml:href', uri);
			else if (node.getAttributeNS(this.service.XLinkNS, 'href'))
				node.setAttributeNS(this.service.XLinkNS, 'xlink:href', uri);
			else
				node.setAttribute('href', uri);

			window.setTimeout(
				function()
				{
					if (
						!node ||
						!node.ownerDocument ||
						!node.ownerDocument.defaultView ||
						node.ownerDocument.defaultView.closed
						)
						return;

					uri = uri.replace(/^javascript:void([^;]+);/, 'javascript:');
					if (node.href)
						node.href = uri;
					else if (node.getAttributeNS(this.service.XHTMLNS, 'href'))
						node.setAttributeNS(this.service.XHTMLNS, 'xhtml:href', uri);
					else if (node.getAttributeNS(this.service.XLinkNS, 'href'))
						node.setAttributeNS(this.service.XLinkNS, 'xlink:href', uri);
					else
						node.setAttribute('href', uri);
				},
				100
			);
		}


		// sidebar features (Firefox)
		if (
			(aLinkInfo.target == '_search' || node.getAttribute('rel') == 'sidebar') &&
			!aLinkInfo.causedByMiddleClick &&
			!aEvent.shiftKey &&
			!aEvent.ctrlKey &&
			!aEvent.altKey &&
			!aEvent.metaKey
			)
			return __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);


		// If any link is opened in new tabs and the link middle-clicked, then open the link in same tab.
		if (
			!aLinkInfo.referrerBlocked &&
			(
				!uri || uri.match(/^mailto:/) ||
				( // Don't open new tab when the link aims to an existing frame
					aLinkInfo.causedByAlwaysNewTab &&
					/*enableExceptionForAlways &&*/
					!aLinkInfo.realTarget &&
					Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window) != aLinkInfo.window
				) ||
				(aEvent.type == 'click' && aEvent.button > 1)
			)
			)
			return __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);


		var postData = {};
		var convertedURI = ('getShortcutOrURI' in window) ? getShortcutOrURI(uri, postData) : uri ; // in Mail&Newsgroup, "getShortcutOrURI()" is not defined!!
		postData = 'value' in postData ? postData.value : null ;

		// If a tab (named by "TARGET") exists, then open the link in the tab.
		if (
			(
				aLinkInfo.causedByTargetAttribute &&
				!aLinkInfo.causedByMiddleClick
			) ||
			( // Don't open new tab when the link aims to an existing tab/frame
				aLinkInfo.causedByAlwaysNewTab && /*enableExceptionForAlways &&*/
				aLinkInfo.target &&
				!aLinkInfo.target.match(/^_blank$/i)
			)
			) {
			if (this.service.getFrameByName(Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window), aLinkInfo.target))
				return __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);

			var browser;
			for (i in b.mTabs)
			{
				browser = b.mTabs[i].mBrowser;
				if (
					b.mTabs[i].browserName != aLinkInfo.target &&
					browser.contentDocument.defaultView.name != aLinkInfo.target
					) continue;

				browser.webNavigation.loadURI(
					convertedURI,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
					aLinkInfo.referrer,
					postData,
					null
				);

				browser.contentDocument.defaultView.opener = aLinkInfo.window;
				if (
					aLinkInfo.target &&
					!String(aLinkInfo.target).match(/^_(self|top|parent|content|blank)$/i) &&
					aLinkInfo.target != '_main'
					)
					browser.contentDocument.defaultView.name = aLinkInfo.target;

				if (!aLinkInfo.loadInBackground) {
					b.selectedTab = b.mTabs[i];
					b.scrollTabbarTo(b.selectedTab);
					b.setFocusInternal();
				}

				(nav._content ? nav._content : nav ).focus();

				this.service.markLinkVisited(uri, node);

				// add the tab to the children list
				if (
					b.tabGroupsAvailable &&
					b.ownerDocument == document && // reject tabs opened by undocked sidebar and so on
					b.mTabs[i] != b.mCurrentTab // reject current tab
					)
					b.attachTabTo(b.mTabs[i], b.mCurrentTab, true);

				this.service.stopEvent(aEvent, true);
				return false;
			}
		}



		var newTabAction = (
				aLinkInfo.causedByLocked ||
				aLinkInfo.causedByAlwaysNewTab ||
				aLinkInfo.causedByOuterLink ||
				aLinkInfo.causedByTargetAttribute ||
				aLinkInfo.causedByMiddleClick
			);

		// for web panels (Sidebar)
		var forceToLoadInBrowser = (aLinkInfo.fieldNormalClicks && (!aLinkInfo.target || aLinkInfo.target == '_content'));


		// load URI
		if (
			(aLinkInfo.referrerBlocked || forceToLoadInBrowser) &&
			!newTabAction
			) {

			if (forceToLoadInBrowser) { // web panels (Sidebar)
				b.webNavigation.loadURI(
					convertedURI,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
					aLinkInfo.referrer,
					postData,
					null
				);
				this.service.markLinkVisited(uri, node);
			}
			else if (aEvent.shiftKey || aEvent.altKey)
				handleLinkClick(aEvent, uri, node);
			else { // block referrer
				if (aLinkInfo.target) {
					var w = aLinkInfo.realTarget ? (this.service.getFrameByName(Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window), aLinkInfo.realTarget, aLinkInfo.window) || aLinkInfo.window) : aLinkInfo.window ;
					var loc = Components.lookupMethod(w, 'location').call(w);
					loc.href = 'about:blank';
					loc.href = uri;
				}
				else {
					b.webNavigation.loadURI(
						convertedURI,
						Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
						null,
						postData,
						null
					);
				}
				this.service.markLinkVisited(uri, node);
			}

			this.service.stopEvent(aEvent);

			return false;
		}

		var info = {};
		if (postData)
			info.postData = b.readPostStream(postData);

		// open new tab
		if (
			newTabAction ||
			(aLinkInfo.newTypeBrowserOpenWindow && this.winHookMode > 0)
			) {

			if (
				uri.match(/^javascript:/i) ||
				( // reverse action by middle click when the default action is "open in new tab"
					!aLinkInfo.causedByLocked &&
					aLinkInfo.causedByAlwaysNewTab &&
					aLinkInfo.causedByMiddleClick
				)
				) {
				handleLinkClick(aEvent, uri, node);
				return true;
			}

			this.service.stopEvent(aEvent, true);

			// If the link has "TARGET", then the tab is named.
			info.browserName = (aLinkInfo.causedByTargetAttribute && !aLinkInfo.causedByMiddleClick) ? aLinkInfo.target : null ;

			if (this.service.getPref('browser.tabs.extensions.show_link_text_as_label')) {
				var label = this.service.getInnerTextOf(node) || '';
				info.fixedLabel = this.service.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, label).replace(/\s+/g, ' ');
				info.fixedLabelAutoDestroy = true;
				if (this.service.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
					info.fixedLabelOnLoad = label;
			}

			// inherit status
			if (
				b.ownerDocument == document && // reject tabs opened by undocked sidebar and so on
				(
					!this.service.getPref('browser.tabs.extensions.inherit.onlySameSite') ||
					this.service.isSameHost(uri, aLinkInfo.source)
				)
				) {
				var props = [];
				if(this.service.getPref('browser.tabs.extensions.inherit.textZoom'))
					props.push('textZoom');
				if (this.service.getPref('browser.tabs.extensions.inherit.locked'))
					props.push('locked');
				if (this.service.getPref('browser.tabs.extensions.inherit.referrerBlocked'))
					props.push('referrerBlocked');
				if (this.service.getPref('browser.tabs.extensions.inherit.allow'))
					props = props.concat([
							'allowPlugins',
							'allowJavascript',
							'allowMetaRedirects',
							'allowSubframes',
							'allowImages'
						]);
				if (props.length) {
					info.uri = uri;
					for (i in props)
						info[props[i]] = b.mCurrentTab[props[i]];
				}
			}

			// add the tab to the children list
			if (
				b.tabGroupsAvailable &&
				b.ownerDocument == document // reject tabs opened by undocked sidebar and so on
				) {
				for (i = 0; i < b.mTabs.length; i++)
					if (Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window).document == b.mTabs[i].mBrowser.contentDocument) {
						info.parentTab = b.mTabs[i].tabId;
						info.openedAutomatically = aLinkInfo.causedByTargetAttribute || aLinkInfo.causedByLocked || aLinkInfo.causedByAlwaysNewTab ;

						var openIn = this.service.getPref('browser.tabs.extensions.open_tab_in_link');
						if (openIn > -1)
							info.openIn = openIn;
					}
			}

			var newTab = b.addTabInternal(uri, aLinkInfo.referrer, info);

			if (aLinkInfo.causedByTargetAttribute) {
				newTab.mBrowser.contentDocument.defaultView.opener = aLinkInfo.window;
				if (
					aLinkInfo.target &&
					!String(aLinkInfo.target).match(/^_(self|top|parent|content|blank)$/i) &&
					aLinkInfo.target != '_main'
					)
					newTab.mBrowser.contentDocument.defaultView.name = aLinkInfo.target;
			}

			if (!aLinkInfo.loadInBackground) {
				b.selectedTab = newTab;
				b.scrollTabbarTo(b.selectedTab);
				b.setFocusInternal();
			}

			if (!this.service.loadInBackgroundWindow)
				(nav._content ? nav._content : nav ).focus();

			this.service.markLinkVisited(uri, node);

			return false;
		}


		var retVal = __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);

		// When the event object is a dummy, the default action of the links has been canceled. So, we have to load the page manually.
		if (retVal && '__tabextensions__allowed' in aEvent) {
			if (aLinkInfo.realTarget.match(/^_main$/))
				aLinkInfo.realTarget = 'top';
			else if (aLinkInfo.realTarget.match(/^_(self|top|parent|content)$/i))
				aLinkInfo.realTarget = RegExp.$1.toLowerCase();

			Components.lookupMethod(aLinkInfo.window, 'setTimeout').call(
				aLinkInfo.window,
				[
					'var w = window;',
					'var n = "', aLinkInfo.realTarget.replace(/\"/g, '\\"'), '";',
					'if (n) {',
						'while ((!(n in w) || w[n].constructor != "[Window]") && w != Components.lookupMethod(window, "top").call(window)) { w = w.parent; };',
						'if (n in w && w[n].constructor == "[Window]") w = w[n];',
					'};',
					'w.location.href = "', uri.replace(/\"/g, '\\"'), '";'
				].join(''),
				0
			);
		}

		return retVal;
	},
  
	handleLinkClick : function(aEvent, aURI, aNode) 
	{
		var retVal = __tabextensions__handleLinkClick(aEvent, aURI, aNode);

		var saveClick = (aEvent.button == 0 && (TabbrowserService.getPref('ui.key.saveLink.shift') ? aEvent.shiftKey : aEvent.altKey ));
		var nullClick = (aEvent.button == 0 && aEvent.altKey);

		if (aEvent.button < 2 &&
			(!retVal || (retVal && !saveClick && !nullClick)))
			TabbrowserService.markLinkVisited(aURI, aNode);

		return retVal;
	},
 
	messagePaneOnClick : function(aEvent) 
	{
		// ignore simple click, because new browser has been opened by customized contentAreaClick().
		var uri = hrefForClickEvent(aEvent);
		if (uri &&
			uri.match(/^(https?|ftp|file|gopher|chrome|resource|about):/i) &&
			aEvent.button == 0 &&
			!aEvent.metaKey &&
			!aEvent.ctrlKey &&
			!aEvent.shiftKey &&
			!aEvent.altKey) {
			TabbrowserService.stopEvent(aEvent);
		}

		window.__tabextensions__messagePaneOnClick(aEvent);
	},
  
	// Location Bar 
	
	BrowserLoadURL : function(aEvent, aPostData, aOriginalURI) 
	{
		var TS = TabbrowserService;

		var uri    = gURLBar.value;
		var usetab = false;
		var b      = TS.browser;
		var id     = aEvent ? aEvent.target.id : '' ;

		switch (id)
		{
			case 'search-bar':
				usetab = TS.getPref('browser.tabs.opentabfor.searchbar_always');
				break;

			default:
				usetab = TS.getPref('browser.tabs.opentabfor.urlbar_always');
				break;
		}

		var isNewType    = TS.isNewTypeBrowser;
		var newTabAction = TS.getPref('browser.tabs.opentabfor.urlbar') && (!aEvent ? false : (isNewType && aEvent.altKey) || (!isNewType && (aEvent.ctrlKey || aEvent.metaKey)) );

		// when ctrl or meta(command on Mac) is pressed, behavior is reversed.
		if (usetab &&
			newTabAction &&
			b.currentURI.spec != 'about:blank') {
			usetab       = false;
			newTabAction = false;
		}

		if (uri.match(/^view-source:/))
			return window.__tabextensions__BrowserLoadURL(aEvent);


		var uriWithKeyword = String(aOriginalURI) || uri;
		uri = getShortcutOrURI(uri, {});

		var info     = null,
			referrer = null;

		// when this is a keyword
		if (uri != uriWithKeyword) {
			var bookmarkRes = TS.getBookmarkResourceFromKeyword(uriWithKeyword.substring(0, uriWithKeyword.indexOf(' ')), uri);
			if (bookmarkRes) {
				id = bookmarkRes.Value;

				referrer = TS.getReferrerForBookmark(id) || null ;

				info = {
					uri        : uri,
					fixedLabel : TS.getFixedLabelForBookmark(id),
					textZoom   : TS.getTextZoomForBookmark(id),
					bookmarkID : id
				};

				if (!info.fixedLabel && TS.getPref('browser.tabs.extensions.show_link_text_as_label')) {
					var name = TS.getNameForBookmark(id) || '';
					info.fixedLabelAutoDestroy = true;
					info.fixedLabel = TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, name).replace(/\s+/g, ' ');
					if (TS.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
						info.fixedLabelOnLoad = name;
				}

				if (TS.shouldSaveBookmarksStatus)
					info = TS.loadBookmarkStatus(id, info);
			}
		}

		var t;
		if (TS.preventSameURLTab) {
			var testURI = TS.fixupURI(uri);
			if (testURI) uri = testURI;

			for (var i = 0; i < b.mTabs.length; i++)
			{
				if (b.mTabs[i].mTabInfo.loadingURI != uri) continue;

				t = b.mTabs[i];

				TS.popupAlert(TS.strbundle.GetStringFromName('status_same_uri_tab_exists'));

				t.mBrowser.webNavigation.loadURI(
					uri,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_REPLACE_HISTORY,
					referrer,
					aPostData || null,
					null
				);
				if (info)
					t.mBrowser.initTabWithTabInfo(t, info);
				break;
			}
		}

		if (
			(usetab || newTabAction) &&
			!b.mCurrentTab.isReallyBlank
			) {
			if (!t) {
				if (!info) info = {};
				if (aPostData)
					info.postData = b.readPostStream(aPostData);

				t = b.addTabInternal(uri, referrer, info);
				gURLBar.value = uri;
			}

			var loadInBackground = false;
			switch (id)
			{
				case 'search-bar':
					loadInBackground = TS.getPref('browser.tabs.extensions.loadInBackgroundSearchBar');
					break;

				default:
					loadInBackground = TS.getPref('browser.tabs.extensions.loadInBackgroundLocationBar');
					break;
			}

			if (aEvent.shiftKey) loadInBackground = !loadInBackground;

			if (!loadInBackground) {
				b.userTypedValue = null;
				b.selectedTab    = t;
				b.scrollTabbarTo(b.selectedTab);
			}
		}
		else {
			b.webNavigation.loadURI(
				uri,
				Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
				referrer,
				aPostData || null,
				null
			);
			if (info)
				b.initTabWithTabInfo(b.mCurrentTab, info);
		}

		if (aEvent) TS.stopEvent(aEvent);

		b.setFocusInternal();
		_content.focus();

		return true;
	},

 
	handleURLBarCommand : function(aEvent) 
	{
		var originalURI = gURLBar.value
		var postData = {};
		if ('canonizeUrl' in window) canonizeUrl(aEvent, postData);
		try {
			if ('addToUrlbarHistory' in window) addToUrlbarHistory();
		}
		catch(e) {
		}
		TabbrowserOverlay.BrowserLoadURL(
			aEvent,
			('value' in postData ? postData.value : null ),
			originalURI
		);
	},
  
	// Toolbars (Firefox) 
	
	insertItem : function(aId, aBeforeElt, aWrapper, aBeforePermanent) 
	{
		var ret = this.__tabextensions__insertItem(aId, aBeforeElt, aWrapper, aBeforePermanent);

		// dispatch "TSToolbarItemInserted" event
		var event = document.createEvent('Events');
		event.initEvent('TSToolbarItemInserted', false, true);
		event.targetItem = ret ? ret : null ;
		this.dispatchEvent(event);

		return ret;
	},
  
	// Bookmarks 
	
	openBookmarkURL : function(aNode, aDataSource, aEvent, aRoot) 
	{
		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			type = (aEvent ? aEvent.type : 'command' ),
			node = aNode;
		var url  = (node) ? node.id :
					(aEvent) ? aEvent.target.id :
					null ;

		if (
			aEvent && type == 'click' &&
			(aEvent.button != 1 || !TS.opentabforBookmarks)
			) return;

		// "Open in Tabs" in folders
		if (
			url == 'openintabs-menuitem' ||
			node.getAttribute('class') == 'openintabs-menuitem'
			) {
			TS.openBookmark(aEvent.target.parentNode.parentNode.id, aEvent, 'folder-as-group');
			return;
		}

		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}

		if (!TS.openBookmark(url, aEvent)) return;

		if (!node) return;
		var parent = node.parentNode;
		while (parent && parent != aRoot)
		{
			if ('hidePopup' in parent)
				parent.hidePopup();
			else if ('closePopup' in parent)
				parent.closePopup();

			parent = parent.parentNode;
		}
	},
 
	// open bookmark groups in Firefox 
	openGroupBookmark : function(aURI, aTargetBrowser)
	{
		var TS = TabbrowserService;
		var resource = TS.RDF.GetResource(aURI);

		if (aTargetBrowser == 'window') {
			var w = window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', null, null, null, resource);
			w.addEventListener(
				'load',
				function(aEvent)
				{
					aEvent.target.TabbrowserService.openBookmarkGroup(aEvent.target.arguments[3]);
				},
				false
			);
		}
		else
			TS.openBookmarkGroup(resource, TS.BookmarksDS);
	},
 
	// Bookmarks Tree 
	
	// in Bookmarks Tree 
	openBookmarkItem : function(aEvent, aInNewWindow, aOpenGroups)
	{
		var groupRes      = this.rdf.GetResource(this.NC_NS + 'FolderGroup');
		var groupTarget   = this.db.GetTarget(this.currentRes, groupRes, true);

		var TS = TabbrowserService;

		var browserWindow = TS.browserWindow;

		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		try {
			var usetab       = TS.opentabforBookmarks;
			var usetab_force = TS.getPref('browser.tabs.opentabfor.anybookmark');
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);

			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // "Open" or "Open in New Window" selected in the context menu
						(groupTarget && (!aOpenGroups || aEvent.detail > 1)) ||
						(!groupTarget && this.treeBoxObject.view.isContainer(this.treeBoxObject.view.selection.currentIndex)) ||
						aEvent.altKey || //  open property
						aInNewWindow //  open in window compulsory
					);

			// action to open the bookmark in new tab
			var openTabAction = ((usetab && !usetab_force && middleclick) || (usetab && middleclick && usetab_force && TS.shouldOpenBookmarkGroup(this.currentRes)));
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(usetab_force && !middleclick &&
						!TS.shouldOpenBookmarkGroup(this.currentRes) &&
							(
							browserWindow.TabbrowserService.browser.mCurrentBrowser.currentURI.spec != 'about:blank'// ||
//							!TS.getPref('browser.tabs.opentabfor.anybookmark_but')
							)
						)
					);

			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(this.currentRes))
				return TS.openBookmarkGroup(this.currentRes, this.db);

			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TS.isBookmarkFolder(this.currentRes) ||
				!aEvent // from the context menu
				)
				return this.__tabextensions__openItem(aEvent, aInNewWindow, aOpenGroups);

			var urlValue = db.GetTarget(this.currentRes, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TS.openBookmark(urlValue, aEvent, (otherAction || !openTabAction) ? 'current' : 'tab');
		}
		catch(e) {
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
	
	validOpenClickConditions : function(aEvent) 
	{
		if (
			aEvent.button > 1 ||
			aEvent.originalTarget.localName != 'treechildren' ||
			(aEvent.button == 1 && !TabbrowserService.opentabforBookmarks)
			)
			return false;

		var row = {};
		var col = {};
		var obj = {};
		this.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
		if (row.value == -1 || obj.value == 'twisty')
			return false;

		return true;
	},
  
	// in Bookmarks Tree (new implementation, Firefox) 
	openBookmarkItemClickOrKey : function(aEvent, aClickCount)
	{
		var TS = TabbrowserService;

		if (
			(aEvent && !this.validOpenClickConditions(aEvent)) ||
			(aClickCount != this.clickCount && aEvent && aEvent.button != 1)
			)
			return false;

		var browserWindow = TS.browserWindow;
		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		// for new implementation
		var sel = this._selection;
		var res = sel ? rdf.GetResource(sel.item[0].Value) : this.currentRes ;

		try {
			var usetab       = TS.opentabforBookmarks;
			var usetab_force = TS.getPref('browser.tabs.opentabfor.anybookmark');
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);

			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // "Open" or "Open in New Window" selected in the context menu
//						aEvent.detail > 1 ||
						(sel && sel.type[0] != 'Bookmark') || // new implementation
						( // old implementation: clicking folders
							this.treeBoxObject.view.selection &&
							this.treeBoxObject.view.isContainer(this.treeBoxObject.view.selection.currentIndex)
						) ||
						aEvent.altKey // open property
					);

			// action to open the bookmark in new tab
			var openTabAction = ((usetab && !usetab_force && middleclick) || (usetab && middleclick && usetab_force && TS.shouldOpenBookmarkGroup(res)));
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(usetab_force && !middleclick &&
						!TS.shouldOpenBookmarkGroup(res) &&
							(
							browserWindow.TabbrowserService.browser.mCurrentBrowser.currentURI.spec != 'about:blank'// ||
//							!TS.getPref('browser.tabs.opentabfor.anybookmark_but')
							)
						)
					);


			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(res))
				return TS.openBookmarkGroup(res, db);


			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TabbrowserService.isBookmarkFolder(res) ||
				!aEvent // from the context menu
				) {
				return ('__tabextensions__openItemClick' in this) ? (aEvent ? this.__tabextensions__openItemClick(aEvent, aClickCount) : this.__tabextensions__openItemKey() ) : this.__tabextensions__openItem(aEvent, aClickCount) ;
			}

			var urlValue = db.GetTarget(res, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TabbrowserService.openBookmark((sel ? sel.item[0].Value : urlValue ), aEvent, (otherAction || !openTabAction) ? 'current' : 'tab');
		}
		catch(e) {
//			alert(e); // In some environments, "Type Error: this.getBrowserForTab(aTab).currentURI has no properties" error appears (but works fine). Why?
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
  
	// BookmarksUtils 
	
	addBookmark : function(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel) 
	{
		// use fixed label instead of the title
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browsers : [] ;
		for (var i = 0; i < b.length; i++)
			if (b[i].mCurrentTab &&
				b[i].mCurrentTab.mTabInfo.loadingURI == aURI &&
				b[i].mCurrentTab.mTabInfo.fixedLabel)
				aTitle = b[i].mCurrentTab.mTabInfo.fixedLabel;

		this.__tabextensions__addBookmark(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel);
	},
 
	createBookmark : function(aName, aURI, aCharSet, aDefaultName) 
	{
		// use fixed label instead of the title (for drag'n'drop)
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browsers : [] ;
		var i, j;
		for (i = 0; i < b.length; i++)
			for (i = 0; i < b.length; i++)
				if (b[i].mCurrentTab &&
					b[i].mCurrentTab.mTabInfo.loadingURI == aURI &&
					b[i].mCurrentTab.mTabInfo.fixedLabel &&
					b[i].mCurrentTab.mTabInfo.fixedLabel == aDefaultName)
					aName = b[i].mCurrentTab.mTabInfo.fixedLabel;

		return this.__tabextensions__createBookmark(aName, aURI, aCharSet, aDefaultName);
	},
  
	// BookmarksMenu 
	
	loadBookmark : function(aEvent, aTarget, aDatabase) 
	{
		TabbrowserOverlay.openBookmarkURL(aTarget, aDatabase, aEvent, aEvent.currentTarget);
	},
 
	loadBookmarkMiddleClick : function(aEvent, aDatabase) 
	{
		TabbrowserOverlay.openBookmarkURL(aEvent.target, aDatabase, aEvent, aEvent.currentTarget);
	},

  
	// BookmarksCommand 
	
	BookmarksCommandOpenBookmark : function(aSelection, aOpenType, aDataSource) 
	{
		if (!aOpenType) return;

		var type;
		for (var i = 0; i < aSelection.length; i++)
		{
			type = aSelection.type[i];
			if (!type || type == 'Bookmark')
				TabbrowserService.openBookmark(aSelection.item[i].Value, null, aOpenType, aDataSource);
			else if (type.match(/^(FolderGroup|Folder|PersonalToolbarFolder)$/))
				TabbrowserService.openBookmarkGroup(aSelection.item[i].Value, aDataSource);
		}
	},
 
	BookmarksCommandCreateContextMenu : function(aEvent, aSelection) 
	{
		this.__tabextensions__createContextMenu(aEvent, aSelection);

		var TS    = TabbrowserService,
			popup = aEvent.target;

		var newTabItem = popup.getElementsByAttribute('command', 'cmd_bm_openinnewtab');
		if (!newTabItem.length)
			newTabItem = popup.getElementsByAttribute('cmd', 'http://home.netscape.com/NC-rdf#command?cmd=bm_openinnewtab');
		if (!newTabItem.length)
			return;

		var node;

		if (TS.getPref('browser.tabs.extensions.showNewActiveTabItem') &&
			TS.getPref('browser.tabs.extensions.loadInBackgroundBookmarks')) {
			node = popup.insertBefore(document.createElement('menuitem'), newTabItem[0].nextSibling);
			node.setAttribute('label', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_label'));
			node.setAttribute('accesskey', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_accesskey'));
			node.setAttribute('oncommand', 'TabbrowserService.openBookmark((\'BookmarksMenu\' in window ? BookmarksMenu._selection.item[0].Value : this.parentNode.parentNode._selection.item[0].Value ), null, \'newactivetab\');');
		}

		if (TS.getPref('browser.tabs.opentabfor.anybookmark')) {
			newTabItem[0].hidden = true;
			if (TS.getPref('browser.tabs.extensions.showThisTabItem')) {
				node = popup.insertBefore(document.createElement('menuitem'), newTabItem[0].nextSibling);
				node.setAttribute('label', TS.strbundle.GetStringFromName('openBookmarkInThisTab_label'));
				node.setAttribute('accesskey', TS.strbundle.GetStringFromName('openBookmarkInThisTab_accesskey'));
				node.setAttribute('oncommand', 'TabbrowserService.openBookmark((\'BookmarksMenu\' in window ? BookmarksMenu._selection.item[0].Value : this.parentNode.parentNode._selection.item[0].Value ), null, \'current\');');
			}
		}
		else {
			newTabItem[0].hidden = false;
		}
	},
  
	addBookmarkForTabBrowser : function(aTabBrowser, aSelect) 
	{
		var info = [];
		var currentInfo;

		var tabs = aTabBrowser.mTabs;
		var b;
		for (var i in tabs)
		{
			b = tabs[i].mBrowser;
			try {
				doc = b.contentDocument;
			}
			catch(e) {
				doc = null;
			}
			info[i] = {
				name    : (doc ? doc.title : '' ) || b.currentURI.spec,
				url     : b.currentURI.spec,
				charset : (doc ? doc.characterSet : null )
			};

			if (tabs[i] == aTabBrowser.selectedTab)
				currentInfo = info[i];
		}
		if (!TabbrowserService.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup' + (aSelect ? ',group' : ''),
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup' + (aSelect ? ',group' : ''),
				info
			);
	},
  
	// History 
	
	OpenURL : function(aWhereOrInNewTabFlag, aEvent) 
	{
		var inNewTab = (typeof aWhereOrInNewTabFlag != 'number') ? aWhereOrInNewTabFlag : (aWhereOrInNewTabFlag > 1) ;

		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = ('selection' in gHistoryTree.treeBoxObject ? gHistoryTree.treeBoxObject.selection : gHistoryTree.view.selection).count; // "view.selection" is for 1.8a or later. "treeBoxObject.selection" is for 1.7x.
		if (
			TS.browserWindow &&
			(
				(
					inNewTab &&
					TabbrowserService.getPref('browser.tabs.opentabfor.history')
				) ||
				(
					TabbrowserService.getPref('browser.tabs.opentabfor.anyhistory') &&
					(
						!TS.browserWindow.TabbrowserService.browser.mCurrentTab.isReallyBlank ||
						!TS.reuseCurrentBlankTab
					)
				)
			) &&
			count == 1 &&
			!isContainer(gHistoryTree, currentIndex)) {
			var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
			var uri = builder.getResourceAtIndex(currentIndex).Value;
			var b = TS.browserWindow.TabbrowserService.browser;
			var t = b.addTab(uri);
			if (!TS.getPref('browser.tabs.extensions.loadInBackgroundHistory')) {
				b.selectedTab = t;
				b.scrollTabbarTo(t);
				b.setFocusInternal();
			}

			if (!TS.loadInBackgroundWindow)
				TS.browserWindow.focus();

			return true;
		}

		return __tabextensions__OpenURL(aWhereOrInNewTabFlag, aEvent);
	},
 
	historyOnClick : function(aEvent) 
	{
		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = ('selection' in gHistoryTree.treeBoxObject ? gHistoryTree.treeBoxObject.selection : gHistoryTree.view.selection).count; // "view.selection" is for 1.8a or later. "treeBoxObject.selection" is for 1.7x.

		var b = TS.browserWindow ? TS.browserWindow.TabbrowserService.browser : null ;
		if (
			b &&
			(
				(
					aEvent.button == 1 &&
					TS.getPref('browser.tabs.opentabfor.history')
				) ||
				(
					aEvent.button == 0 &&
					!aEvent.shiftKey &&
					!aEvent.ctrlKey &&
					!aEvent.altKey &&
					!aEvent.metaKey &&
					TS.getPref('browser.tabs.opentabfor.anyhistory') &&
					(
						!b.mCurrentTab.isReallyBlank ||
						!TS.reuseCurrentBlankTab
					)
				)
			) &&
			count == 1 &&
			!isContainer(gHistoryTree, currentIndex)
			) {
			var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
			var uri = builder.getResourceAtIndex(currentIndex).Value;
			var t = b.addTab(uri);
			if (!TS.getPref('browser.tabs.extensions.loadInBackgroundHistory')) {
				b.selectedTab = t;
				b.scrollTabbarTo(t);
				b.setFocusInternal();
			}

			if (!TS.loadInBackgroundWindow)
				TS.browserWindow.focus();

			return;
		}
		__tabextensions__historyOnClick(aEvent);
	},
 
	gotoHistoryIndex : function(aEvent, aIndex, aNode) 
	{
		var index = aIndex || aEvent.target.getAttribute('index');
		if (!index) return false;

		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			node = aNode || aEvent.target;

		if (
			aEvent.type == 'click' &&
			(aEvent.button != 1 || !TS.getPref('browser.tabs.opentabfor.history'))
			) return false;


		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}


		try {
			var b = TS.browser;

			if (index == 'back')
				b.goBackGroup();
			else if (index == 'forward')
				b.goForwardGroup();
			else if (
				(
					TS.getPref('browser.tabs.opentabfor.anyhistory') &&
					(
						!b.mCurrentTab.isReallyBlank ||
						!TS.reuseCurrentBlankTab
					)
				) ||
				(
					TS.getPref('browser.tabs.opentabfor.history') &&
					(
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					)
				)
				) {
				var SH = null;
				try {
					SH = b.sessionHistory;
				}
				catch(ex) {
					return false;
				}

				var entry = SH.getEntryAtIndex(index, false);
				if (!entry) return false;

				entry = entry.QueryInterface(Components.interfaces.nsISHEntry);
				var t = b.addTab(entry.URI.spec, entry.referrerURI);

				if (!TS.getPref('browser.tabs.extensions.loadInBackgroundHistory')) {
					b.selectedTab = t;
					b.scrollTabbarTo(b.selectedTab);
					b.setFocusInternal();
				}
			}
			else
				b.webNavigation.gotoIndex(index);
		}
		catch(e) {
			return false;
		}


		if (node) {
			var parent = node;
			while (parent)
			{
				if ('hidePopup' in parent)
					parent.hidePopup();
				else if ('closePopup' in parent)
					parent.closePopup();

				parent = parent.parentNode;
			}
		}
		return true;
	},

  
	// nsContextMenu 
	
	initItems : function() 
	{
		this.__tabextensions__initItems();

		var TS = TabbrowserService;

		var b = /*TS.popupNodeOwnerBrowser ||*/ TS.browser ;

		var onLinks              = false,
			onLinksWithoutMailto = false,
			isSingleWindow       = false,
			tab                  = null,
			tabs                 = [];

		var showOpenInActiveTab = TS.getPref('browser.tabs.extensions.showNewActiveTabItem') && TS.getPref('browser.tabs.extensions.loadInBackgroundLinks');
		var showOpenInThisTab = TS.getPref('browser.tabs.extensions.showThisTabItem') && (
			TS.getPref('browser.tabs.opentabfor.anylink') ||
			(TS.getPref('browser.tabs.opentabfor.outerlink') && this.link && !TS.isSameHost(this.linkURL(), this.link.ownerDocument.defaultView.location.href)) ||
			(
				(
					TS.winHookMode > 0 ||
					TS.getPref('browser.tabs.opentabfor.linkclick')
				) &&
				!TS.getPref('browser.block.target_new_window') &&
				TabbrowserOverlay.getTargetForLink(this.link).name
			)
		);
		var showOpenAllLinksInTabs = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInTabs');
		var showOpenAllLinksInGroup = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInGroup');
		var showBookmarkAllLinksAsGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkAllLinksAsGroup');
		var showBookmarkTabGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkTabGroup');

		if (showOpenAllLinksInTabs ||
			showOpenAllLinksInGroup ||
			showBookmarkAllLinksAsGroup) {
			try {
				var links = TS.getSelectionLinks();
				onLinks = (links.length > 1);

				for (var i = links.length-1; i > -1; i--)
					if (links[i].uri.match(/^mailto:/))
						links.splice(1, 1);
				onLinksWithoutMailto = (links.length > 1);

				isSingleWindow = TS.winHookMode == 2;

				tab  = (b) ? b.mCurrentTab : null ;
				if (tab) {
					if (!tab.hasChildTabs() && tab.parentTab)
						tab = tab.parentTab;
					tabs = tab.allChildTabs;
					tabs.unshift(tab);
				}
			}
			catch(e) {
				alert(e);
			}
		}


		this.showItem('context-openlink', (this.onSaveableLink || ( this.inDirList && this.onLink )) && !isSingleWindow);

		this.showItem('context-openLinkInNewActiveTab', this.onLink && showOpenInActiveTab);
		this.showItem('context-openLinkInThisTab', this.onLink && showOpenInThisTab);

		this.showItem('context-sep-openAllLinksInGroup', onLinks && !this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInTabs', onLinks && !this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInGroup', onLinks && !this.onLink && showOpenAllLinksInGroup && TS.isGroupMode);

		this.showItem('context-openAllLinksInTabs-onLink', onLinks && this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInGroup-onLink', onLinks && this.onLink && showOpenAllLinksInGroup && TS.isGroupMode);
		this.showItem('context-sep-open', (onLinks && this.onLink && (showOpenAllLinksInTabs || showOpenAllLinksInGroup)) || this.onSaveableLink || ( this.inDirList && this.onLink ) );


		this.showItem('context-sep-bookmarkAllLinksAsGroup', onLinksWithoutMailto && showBookmarkAllLinksAsGroup);
		this.showItem('context-bookmarkAllLinksAsGroup', onLinksWithoutMailto && !this.onLink && showBookmarkAllLinksAsGroup);
		this.showItem('context-bookmarkAllLinksAsGroup-onLink', onLinksWithoutMailto && this.onLink && showBookmarkAllLinksAsGroup);

		this.showItem('context-bookmarkTabGroup', b && TS.browser.tabGroupsAvailable && !(this.isTextSelected || this.onTextInput) && tabs.length > 1 && showBookmarkTabGroup);
	},
 
	onContentAreaContextMenuShowing : function(aEvent) 
	{
		var TS = TabbrowserService;
		if (!TS) return true;

		var b = TS.browser; //TS.popupNodeOwnerBrowser;
		if (!b || !b.isBlank) return true;

		// popup a small menu instead of the normal
		aEvent.preventDefault();

		var p = b.mCurrentTab.mBrowser;
		TS.popupMenu('tabextensions-blankWindow-contextMenu', b.mMouseDownX-p.boxObject.screenX, b.mMouseDownY-p.boxObject.screenY, p);

		return false;
	},
  
	// General Functions 
	
	BrowserOpenTab : function() 
	{
		if ('gInPrintPreviewMode' in window && window.gInPrintPreviewMode)
			return;

		var TS = TabbrowserService;
		var b  = TS.browser;

		// 0 = blank, 1 = home, 2 = last, -1 = inherit
		var startup = TS.getPref('browser.tabs.loadOnNewTab');
		if (startup === null) // for 1.4a or earlier
			startup = TS.getPref('browser.tabs.extensions.startup.page');

		if (startup == -1 ||
			startup == 100) /* old implementation (for 1.4a or earlier) */
			startup = (TS.isNewTypeBrowser) ? 1 : TS.getPref('browser.startup.page') ;

		var uri = 'about:blank';

		var replaceURI = null;
		switch (startup)
		{
			default:
			case 0:
				if (!TS.getPref('browser.tabs.extensions.clear_location_bar'))
					replaceURI = b.currentURI.spec;
				else
					replaceURI = '';
				break;

			case 1:
				uri = 'getHomePage' in window ? getHomePage() :
						'gHomeButton' in window && 'getHomePage' in gHomeButton ? gHomeButton.getHomePage() :
						'about:blank' ;
				if (typeof uri != 'string')
					uri = uri[0];
				if (TS.isNewTypeBrowser && uri.match(/.\|./))
					uri = uri.split('|')[0];

				if (uri == 'about:blank' &&
					TS.getPref('browser.tabs.extensions.clear_location_bar'))
					replaceURI = '';

				break;

			case 2:
				uri = b.currentURI.spec;
				break;
		}

		b.selectedTab = b.addTab(uri);
		b.scrollTabbarTo(b.selectedTab);

		window.setTimeout(TabbrowserOverlay.BrowserOpenTabCallBack, 0, replaceURI, uri);
	},
	BrowserOpenTabCallBack : function(aShouldBeDisplayedURI, aLoadedURI)
	{
		if (aShouldBeDisplayedURI !== null)
			gURLBar.value = aShouldBeDisplayedURI;

		var navBar = document.getElementById('nav-bar');
		if (aLoadedURI == 'about:blank' &&
			!navBar.hidden &&
			window.locationbar.visible)
			window.setTimeout('Components.lookupMethod(gURLBar, \'focus\').call(gURLBar);', 0);
		else
			gBrowser.setFocusInternal();
	},
 
	BrowserCloseTabOrWindow : function() 
	{
		var browser = TabbrowserService.browser;
		var lastTabClosing = TabbrowserService.getPref('browser.tabs.extensions.last_tab_closing');
		if (
			browser &&
			browser.localName == 'tabbrowser' &&
			(
				browser.mTabs.length > 1 ||
				(
					(lastTabClosing == 1 || lastTabClosing == 3) &&
					!browser.mCurrentTab.isReallyBlank
				)
			)
			) {
			browser.removeCurrentTab();
			return;
		}

		if (!TabbrowserService.getPref('browser.tabs.extensions.close_only_tab'))
			BrowserCloseWindow();
	},
 
	openNewTabWith_old : function(aURI, aShouldSendReferrer, aReverseBackgroundPref) 
	{
		urlSecurityCheck(aURI, document);

		var loadInBackground = TabbrowserService.loadInBackground;
		if (aReverseBackgroundPref)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, TabbrowserService.getLastActiveLink(), !loadInBackground);
	},
	
	openNewTabWith : function(aURI, aLinkNode, aEventOrFlag, aSecurityCheckOrEvent) 
	{ // OrFlag/OrEvent is for 0.4 before
		if (typeof aSecurityCheckOrEvent == 'boolean' &&
			aSecurityCheckOrEvent)
			urlSecurityCheck(aURI, document);

		var event = (typeof aEventOrFlag == 'object') ? aEventOrFlag : aSecurityCheckOrEvent ;

		var loadInBackground = aLinkNode ? TabbrowserService.getPref('browser.tabs.extensions.loadInBackgroundLinks') : TabbrowserService.loadInBackground ;
		if (event && event.shiftKey)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, aLinkNode, !loadInBackground);
	},
  
	openNewWindowWith_old : function(aURI, aShouldSendReferrer) 
	{
		urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = aShouldSendReferrer && TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer);

		TabbrowserService.markLinkVisited(aURI, TabbrowserService.getLastActiveLink());
	},
	
	openNewWindowWith : function(aURI, aLinkNode, aSecurityCheck) 
	{
		if (aSecurityCheck)
			urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer);

		TabbrowserService.markLinkVisited(aURI, aLinkNode);
	},
  
	// Tab Selection 
	ctrlNumberTabSelection : function(aEvent)
	{
		if (aEvent.altKey && aEvent.keyCode == KeyEvent.DOM_VK_RETURN) { // for WinXP
			aEvent.preventDefault();
			return;
		}

		var index = aEvent.charCode - 49,
			b     = TabbrowserService.browser;

		if (
			(navigator.platform.match(/mac/i) ? !aEvent.metaKey : !aEvent.ctrlKey ) ||
//			!(TabbrowserService.isNewTypeBrowser || aEvent.shiftKey) || // firebird:ctrl+num, mozilla:ctrl+shift+num
			index < 0 || index > 9 || index >= b.mTabs.length // out of range
			)
			return;

		var oldTab = b.selectedTab;
		var newTab = b.mTabs[index];
		if (newTab != oldTab) {
			oldTab.selected = false;
			b.selectedTab = newTab;
			b.scrollTabbarTo(b.selectedTab);
			b.setFocusInternal();
		}

		TabbrowserService.stopEvent(aEvent);

		return;
	},
 
	goQuitApplication : function() 
	{
		var w = TabbrowserService.browserWindows;
		for (var i in w)
			w[i].TabbrowserService.onQuit = true;

		window.__tabextensions__goQuitApplication();
	}
   
}; 

 
// Event Listeners 
	
var gTSToolbarItemsInsertedEventListener = function(aEvent, aId) 
{
	if (!aEvent && !aId) return;

	var node = aId ? document.getElementById(aId) : aEvent.targetItem ;
	if (!node) return;

	switch (node.id)
	{
		case 'back-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

		case 'forward-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

		default:
			break;
	}
};
   
// end of definition 

if (!window.TabbrowserServiceModules)
	window.TabbrowserServiceModules = [];

TabbrowserServiceModules.push(TabbrowserOverlay);
}
 
