var gExceptions;

var gExceptionsList;
var gListShouldAcceptWindowOpen;
var gURIBox;
var gAddButton;
var gRemoveButton;
var gRemoveAllButton;

function init()
{
	gListShouldAcceptWindowOpen = ('arguments' in window && window.arguments.length > 1) ? window.arguments[1] : (TabbrowserService.opentabforJS || TabbrowserService.winHookMode > 0) ;

	gExceptionsList  = document.getElementById('exceptions');
	gURIBox          = document.getElementById('URIBox');
	gAddButton       = document.getElementById('addButton');
	gRemoveButton    = document.getElementById('removeButton');
	gRemoveAllButton = document.getElementById('removeAllButton');

	document.documentElement.addEventListener('keypress', onReturnHit, true);

	window.sizeToContent();
	window.setTimeout(initWithDelay, 0);
}
function initWithDelay()
{
	if ('arguments' in window &&
		window.arguments[0])
		gURIBox.value = window.arguments[0];

	initList();
}


function initList(aListShouldAcceptWindowOpen)
{
	var shouldAcceptWindowOpen = (aListShouldAcceptWindowOpen !== void(0)) ? aListShouldAcceptWindowOpen : gListShouldAcceptWindowOpen ;
	gExceptions = shouldAcceptWindowOpen ? TabbrowserService.JSWindowOpenExceptionsWhite : TabbrowserService.JSWindowOpenExceptionsBlack ;

	initMessages(shouldAcceptWindowOpen);

	while (gExceptionsList.hasChildNodes())
		gExceptionsList.removeChild(gExceptionsList.lastChild);

	var item;
	var node;
	for (var i = 0; i < gExceptions.length; i++)
	{
		node = gExceptions.item(i);

		item = document.createElement('listitem');
		item.setAttribute('label', gExceptions.getData(node, 'Rule'));
		gExceptionsList.appendChild(item);
	}

	gRemoveButton.disabled = true;
	gRemoveAllButton.disabled = !gExceptionsList.hasChildNodes();
}

function initMessages(aShouldAcceptWindowOpen)
{
	var type = aShouldAcceptWindowOpen ? 'white' : 'black' ;
	window.title = document.getElementById('labelTitle-'+type).getAttribute('label');

	var desc = document.getElementById('description');
	if (desc.hasChildNodes()) desc.removeChild(desc.firstChild);
	desc.appendChild(document.createTextNode(document.getElementById('labelDesc-'+type).getAttribute('label')));

	var note = document.getElementById('note');
	if (note.hasChildNodes()) note.removeChild(note.firstChild);
	note.appendChild(document.createTextNode(document.getElementById('labelNote-'+type).getAttribute('label')));

	window.sizeToContent();
}


function addURI()
{
	var uri = gURIBox.value;
	if (!uri) return;

	gExceptions.setData(uri, 'Rule', uri);
	gURIBox.value = '';
	initList();
}

function removeURI()
{
	if (!gExceptionsList.selectedItem) return;

	var uri = gExceptionsList.selectedItem.getAttribute('label');

	gExceptions.removeData(uri);
	initList();
}

function removeAllURIs()
{
	gExceptions.clearData();
	initList();
}




function onSelect()
{
	gRemoveButton.disabled = !gExceptionsList.selectedItem;
}

function onReturnHit(aEvent)
{
	var focusedElement = document.commandDispatcher.focusedElement;

	if (!focusedElement ||
		(aEvent.keyCode != aEvent.DOM_VK_ENTER &&
		aEvent.keyCode != aEvent.DOM_VK_RETURN)) return;

	aEvent.preventBubble();
	if (focusedElement == gURIBox.inputField)
		gAddButton.doCommand();
}
