#ifndef TAG_MENU_H
#define TAG_MENU_H

/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <gtkmm/menu.h>
#include "TagcollDocument.h"

class TagMenu : public Gtk::Menu
{
public:
	typedef SigC::Signal1<void, std::string> type_signal_selected;

protected:
	type_signal_selected _signal_selected;

	/*
	void on_filter_changed();
	void on_document_changed();
	bool on_event(GdkEvent* e, int list);

	void on_canceled() Se  intercettabile
	*/

	void populateWith(const OpSet<std::string>& tags) throw ();
	void populateWith(const OpSet<std::string>& tags, const std::string& facet) throw ();

public:
	TagMenu() throw () : Gtk::Menu() {}
	virtual ~TagMenu() {}

	type_signal_selected signal_selected() throw () { return _signal_selected; }

	void do_selected(std::string tag);

	void populateAll(const TagcollDocument<std::string>& doc) throw ();
	void populateAvailable(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags) throw ();
	void populateAvailable(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags, const std::string& facet) throw ();
	void populateUnselected(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags) throw ();
};

// vim:set ts=4 sw=4:
#endif
