#ifndef TAG_MENU_H
#define TAG_MENU_H

/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <gtkmm/menu.h>
#include <tagcoll/Tag.h>
#include <tagcoll/TagSet.h>

#include <vector>

template<class DOC>
class TagMenu : public Gtk::Menu
{
public:
	typedef SigC::Signal1<void, Tagcoll::Tag> type_signal_selected;

protected:
	type_signal_selected _signal_selected;

	/*
	void on_filter_changed();
	void on_document_changed();
	bool on_event(GdkEvent* e, int list);

	void on_canceled() Se  intercettabile
	*/

	void populateWith(const Tagcoll::TagSet& tags) throw ();
	void populateWith(const Tagcoll::TagSet& tags, const Tagcoll::Facet& facet) throw ();

public:
	TagMenu() throw () : Gtk::Menu() {}
	virtual ~TagMenu() {}

	type_signal_selected signal_selected() throw () { return _signal_selected; }

	void do_selected(Tagcoll::Tag tag);

	// Populate with all tags
	void populateAll(const DOC& doc) throw ();
	// Populate with all companion tags of the given tag set
	void populateAvailable(const DOC& doc, const Tagcoll::TagSet& selectedTags) throw ();
	// Populate with all companion tags of the tags with which the given packages have been tagged
	//void populateAvailable(const DOC& doc, const std::vector<std::string>& items) throw ();
	// Populate with all companion tags of the given tag set in the given facet
	void populateAvailable(const DOC& doc, const Tagcoll::TagSet& selectedTags, const Tagcoll::Facet& facet) throw ();
	// Populate with all tags except the ones in selectedTags
	void populateUnselected(const DOC& doc, const Tagcoll::TagSet& selectedTags) throw ();
	// Populate with all tags except the ones in selectedTags
	void populateUnselected(const DOC& doc, const Tagcoll::TagSet& selectedTags, const Tagcoll::Facet& facet) throw ();
};

// vim:set ts=4 sw=4:
#endif
