#ifndef TAGCOLLEDIT_SERIALIZER_H
#define TAGCOLLEDIT_SERIALIZER_H

/*
 * Serializer for the Debtags tag collection
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <tagcoll/Serializer.h>
#include "Tag.h"

namespace Tagcoll
{

/**
 * Serialize Tags to and from Strings
 */
template<>
class Serializer<std::string, Tag>
{
protected:
	FacetSet& _voc;

public:
	Serializer(FacetSet& voc) throw () : _voc(voc) {}

	/**
	 * Convert a TAG to a string
	 */
	std::string tagToString(const Tag& tag) throw ();

	/**
	 * Convert an ITEM to a string
	 */
	std::string itemToString(const std::string& item) throw () { return item; }

	/**
	 * Convert a string to a TAG
	 */
	Tag stringToTag(const std::string& tag) throw ();

	/**
	 * Convert a string to an ITEM
	 */
	std::string stringToItem(const std::string& item) throw () { return item; }

	/**
	 * Convert TAGs to strings
	 */
	OpSet<std::string> tagsToStrings(const OpSet<Tag>& tag) throw ();

	/**
	 * Convert ITEMs to strings
	 */
	OpSet<std::string> itemsToStrings(const OpSet<std::string>& items) throw () { return items; }

	/**
	 * Convert strings to TAGs
	 */
	OpSet<Tag> stringsToTags(const OpSet<std::string>& tags) throw ();

	/**
	 * Convert strings to ITEMs
	 */
	OpSet<std::string> stringsToItems(const OpSet<std::string>& items) throw () { return items; }
};

};

// vim:set ts=4 sw=4:
#endif
