/******************************************************************************
*                                                                             *
*  TakTuk, a middleware for adaptive large scale parallel remote executions   *
*  deployment. Perl implementation, copyright(C) 2006 Guillaume Huard.        *
*                                                                             *
*  This program is free software; you can redistribute it and/or modify       *
*  it under the terms of the GNU General Public License as published by       *
*  the Free Software Foundation; either version 2 of the License, or          *
*  (at your option) any later version.                                        *
*                                                                             *
*  This program is distributed in the hope that it will be useful,            *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
*  GNU General Public License for more details.                               *
*                                                                             *
*  You should have received a copy of the GNU General Public License          *
*  along with this program; if not, write to the Free Software                *
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA *
*                                                                             *
*  Contact: Guillaume.Huard@imag.fr                                           *
*           ENSIMAG - Laboratoire ID                                          *
*           51 avenue Jean Kuntzmann                                          *
*           38330 Montbonnot Saint Martin                                     *
*                                                                             *
******************************************************************************/

#include <taktuk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main()
  {
    char buffer[1024];
    int length;
    char sample_string[128] = "Salut  toi de ";
    char *rank_string;
    int rank, result;

    if ((rank_string = getenv("TAKTUK_RANK")) != NULL)
      {
        rank = atoi(rank_string);
        strcat(sample_string,rank_string);
        length = strlen(sample_string)+1;
      }
    else
      {
        fprintf(stderr,"TAKTUK_RANK not defined, do you use TakTuk ?\n");
        return 1;
      }
    printf("I'm process %d\n", rank);

    if (rank == 1)
      {
        result = taktuk_send("2", sample_string, length);
        if (result < 0)
          {
            printf("Error in %d : %s\n", rank, taktuk_error_msg(taktuk_error));
          }
      }
    else if (rank == 2)
      {
        fflush(stdout);
        result = taktuk_recv(NULL, buffer, 1024, 0);
        if (result < 0)
          {
            printf("Error in %d : %s\n", rank, taktuk_error_msg(taktuk_error));
          }
        else
          {
            printf("Received : %s\n", buffer);
          }
      }
    else
      {
        printf("Got nothing to do\n");
      }
    return 0;
  }
