/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "tpa-errors.h"

GQuark
tpa_error_quark (void)
{
  static GQuark quark = 0;
  if (!quark)
    quark = g_quark_from_static_string ("TpaError");
  return quark;
}

const gchar
*tpa_error_string (TpaError error)
{
    switch (error)
    {
        case TPA_ERROR_NONE:
            return "";
            break;
        case TPA_ERROR_CHANNEL_BANNED:
            return "Banned";
            break;
        case TPA_ERROR_CHANNEL_FULL:
            return "Channel Full";
            break;
        case TPA_ERROR_CHANNEL_INVITE_ONLY:
            return "Channel Invite Only";
            break;
        case TPA_ERROR_DISCONNECTED:
            return "Disconnected";
            break;
        case TPA_ERROR_INVALID_ARGUMENT:
            return "Invalid Argument";
            break;
        case TPA_ERROR_INVALID_HANDLE:
            return "Invalid Handle";
            break;
        case TPA_ERROR_NETWORK_ERROR:
            return "Network Error";
            break;
        case TPA_ERROR_NOT_AVAILABLE:
            return "Not Available";
            break;
        case TPA_ERROR_NOT_IMPLEMENTED:
            return "Not Implemented";
            break;
        case TPA_ERROR_PERMISSION_DENIED:
            return "Permition Denied";
            break;
    }

    return NULL;
}
