/*
 * Tapioca library
 * Copyright (C) 2007 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_AUDIO_STREAM_H__
#define __TPA_AUDIO_STREAM_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-stream.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_AUDIO_STREAM \
    (tpa_audio_stream_get_type())
#define TPA_AUDIO_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_AUDIO_STREAM, TpaAudioStream))
#define TPA_AUDIO_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_AUDIO_STREAM, TpaAudioStreamClass))
#define TPA_IS_AUDIO_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_AUDIO_STREAM))
#define TPA_IS_AUDIO_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_AUDIO_STREAM))
#define TPA_AUDIO_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_AUDIO_STREAM, TpaAudioStreamClass))
#define TPA_AUDIO_STREAM_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_AUDIO_STREAM, TpaAudioStreamPrivate))


typedef struct _TpaAudioStream TpaAudioStream;
typedef struct _TpaAudioStreamClass TpaAudioStreamClass;
typedef struct _TpaAudioStreamPrivate TpaAudioStreamPrivate;

struct _TpaAudioStreamClass {
    TpaStreamClass parent_class;
};

struct _TpaAudioStream {
    TpaStream parent;
    TpaAudioStreamPrivate *priv;
};

GType tpa_audio_stream_get_type   (void);
void  tpa_audio_stream_set_volume (TpaAudioStream *self,
                                   guint value);
guint tpa_audio_stream_get_volume (TpaAudioStream *self);
void  tpa_audio_stream_mute_in    (TpaAudioStream *self,
                                   gboolean value);
void  tpa_audio_stream_mute_out   (TpaAudioStream *self,
                                   gboolean value);
G_END_DECLS

#endif /* #ifndef __TPA_AUDIO_STREAM_H__*/

