/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CHANNEL_H__
#define __TPA_CHANNEL_H__

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-bindings.h>

#include <tapioca/client/tpa-channel-target.h>
#include <tapioca/client/tpa-user-contact.h>
#include <tapioca/client/tpa-contact-group.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CHANNEL \
    (tpa_channel_get_type())
#define TPA_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CHANNEL, TpaChannel))
#define TPA_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CHANNEL, TpaChannelClass))
#define TPA_IS_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CHANNEL))
#define TPA_IS_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CHANNEL))
#define TPA_CHANNEL_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CHANNEL, TpaChannelClass))
#define TPA_CHANNEL_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CHANNEL, TpaChannelPrivate))

typedef struct _TpaChannel TpaChannel;
typedef struct _TpaChannelClass TpaChannelClass;
typedef struct _TpaChannelPrivate TpaChannelPrivate;

struct _TpaChannelClass {
    TpaObjectClass parent_class;
};

struct _TpaChannel {
    TpaObject parent;
    TpaChannelPrivate *priv;
};

GType               tpa_channel_get_type                (void);
TpaChannelTarget *  tpa_channel_get_target              (TpaChannel *self);
TpaChannelType      tpa_channel_get_channel_type        (TpaChannel *self);
TpaUserContact *    tpa_channel_get_owner               (TpaChannel *self);
void                tpa_channel_close                   (TpaChannel *self);
void                tpa_channel_join                    (TpaChannel *self);
gboolean            tpa_channel_has_joined              (TpaChannel *self);
gboolean            tpa_channel_has_group_support       (TpaChannel *self);
TpaContactGroup *   tpa_channel_get_contact_group       (TpaChannel *self);

G_END_DECLS

#endif /* #ifndef __TPA_CHANNEL_H__*/
