/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <time.h>

#include "tpa-contact-group.h"

#define DEBUG_DOMAIN TPA_DOMAIN_CHANNEL

#include <tapioca/base/tpa-debug.h>
#include <tapioca/base/tpa-channel-bindings.h>
#include <tapioca/base/tpa-signals-marshal.h>

struct _TpaContactGroupPrivate {
    DBusGProxy *proxy;
    gboolean disposed;
};


G_DEFINE_TYPE(TpaContactGroup, tpa_contact_group, G_TYPE_OBJECT)

static void
tpa_contact_group_dispose (GObject *object)
{
    TpaContactGroup *self = TPA_CONTACT_GROUP (object);

    if (self->priv->disposed)
       /* If dispose did already run, return. */
       return;

    /* Make sure dispose does not run twice. */
    self->priv->disposed = TRUE;

    G_OBJECT_CLASS (tpa_contact_group_parent_class)->dispose (object);
}

static void
tpa_contact_group_class_init (TpaContactGroupClass *klass)
{
    GObjectClass *gobject_class;

    gobject_class = (GObjectClass *) klass;
    tpa_contact_group_parent_class = g_type_class_peek_parent (klass);

    g_type_class_add_private (klass, sizeof (TpaContactGroupPrivate));

    gobject_class->dispose = tpa_contact_group_dispose;

}

static void
tpa_contact_group_init (TpaContactGroup *self)
{
    self->priv = TPA_CONTACT_GROUP_GET_PRIVATE (self);
    self->priv->proxy = NULL;
}

void
tpa_contact_group_invite (TpaContactGroup *self)
{
    return;
}

gboolean
tpa_contact_group_can_invite (TpaContactGroup *self)
{
    return FALSE;
}

void
tpa_contact_group_expel (TpaContactGroup *self)
{
    return;
}

gboolean
tpa_contact_group_can_expel (TpaContactGroup *self)
{
    return FALSE;
}

GPtrArray *
tpa_contact_group_get_contacts (TpaContactGroup *self)
{
    return NULL;
}

GPtrArray *
tpa_contact_group_get_pending_contacts (TpaContactGroup *self)
{
    return NULL;
}

