/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 * @author  Marcio Macedo <marcio.macedo@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "tpa-handle-factory.h"

struct _TpaHandleFactoryPrivate
{
    gboolean disposed;
};

G_DEFINE_TYPE(TpaHandleFactory, tpa_handle_factory, TPA_TYPE_OBJECT)

//static gboolean tpa_initialized = FALSE;

static void
tpa_handle_factory_dispose (GObject *object)
{
    TpaHandleFactory *self = TPA_HANDLE_FACTORY (object);

    if (self->priv->disposed)
       /* If dispose did already run, return. */
       return;

    /* Make sure dispose does not run twice. */
    self->priv->disposed = TRUE;

    G_OBJECT_CLASS (tpa_handle_factory_parent_class)->dispose (object);
}

static void
tpa_handle_factory_class_init (TpaHandleFactoryClass *klass)
{
    GObjectClass *gobject_class;

    gobject_class = (GObjectClass *) klass;
    tpa_handle_factory_parent_class = g_type_class_peek_parent (klass);

    g_type_class_add_private (klass, sizeof (TpaHandleFactoryPrivate));

    gobject_class->dispose = tpa_handle_factory_dispose;
}

static void
tpa_handle_factory_init (TpaHandleFactory *self)
{
    self->priv = TPA_HANDLE_FACTORY_GET_PRIVATE (self);
    self->priv->disposed = FALSE;
}

TpaHandleFactory* tpa_handle_factory_new (TpaObject *object)
{
    TpaHandleFactory *self;

    self = TPA_HANDLE_FACTORY (g_object_new (TPA_TYPE_HANDLE_FACTORY, "object", object, NULL));

    return self;
}

TpaHandle*
tpa_handle_factory_create_handle (TpaHandleFactory *self,
                                  TpaHandleType handle_type,
                                  const gchar* handle_name)
{
    TpaHandle *handle;
    g_assert(self);
    handle = tpa_handle_new (TPA_OBJECT (self), handle_type, handle_name);

    return handle;
}

TpaHandle*
tpa_handle_factory_create_handle_by_id (TpaHandleFactory *self,
                                        TpaHandleType handle_type,
                                        guint handle_id)
{
    TpaHandle *handle;
    g_assert(self);
    handle = tpa_handle_new_by_id (TPA_OBJECT (self), handle_type, handle_id);

    return handle;
}
