/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_OBJECT_H__
#define __TPA_OBJECT_H__

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-bindings.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_OBJECT \
    (tpa_object_get_type())
#define TPA_OBJECT(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_OBJECT, TpaObject))
#define TPA_OBJECT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_OBJECT, TpaObjectClass))
#define TPA_IS_OBJECT(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_OBJECT))
#define TPA_IS_OBJECT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_OBJECT))
#define TPA_OBJECT_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_OBJECT, TpaObjectClass))
#define TPA_OBJECT_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_OBJECT, TpaObjectPrivate))

typedef struct _TpaObject TpaObject;
typedef struct _TpaObjectClass TpaObjectClass;
typedef struct _TpaObjectPrivate TpaObjectPrivate;

struct _TpaObjectClass {
    GObjectClass parent_class;
};

struct _TpaObject {
    GObject parent;
    gchar *name;
    GHashTable *proxies;
    TpaObjectPrivate *priv;
};

GType               tpa_object_get_type                (void);
DBusGProxy *        tpa_object_get_proxy               (TpaObject *self,
                                                        const gchar *name);
GPtrArray *         tpa_object_get_all_proxies         (TpaObject *self);
void                tpa_object_add_proxy               (TpaObject *self,
                                                        DBusGProxy *proxy);
void                tpa_object_add_proxy_with_name     (TpaObject *self,
                                                        const gchar *name,
                                                        DBusGProxy *proxy);
void                tpa_object_remove_proxy            (TpaObject *self,
                                                        const gchar *name);
gboolean            tpa_object_has_proxy               (TpaObject *self,
                                                        const gchar *name);
void                tpa_object_connect_signal          (TpaObject *self,
                                                        const gchar *name,
                                                        const gchar *signal_name,
                                                        GCallback callback,
                                                        gpointer data);

G_END_DECLS

#endif /* #ifndef __TPA_OBJECT_H__*/
