/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONNECTION_PRIVATE_H__
#define __TPA_CONNECTION_PRIVATE_H__

gboolean    tpa_connection_connect      (GObject *obj,
                                         GError **error);
gboolean    tpa_connection_disconnect   (GObject *obj,
                                         GError **error);
gboolean    tpa_connection_get_interfaces
                                        (GObject *obj,
                                         gchar ***ret,
                                         GError **error);
gboolean    tpa_connection_get_protocol (GObject *obj,
                                         gchar **ret,
                                         GError **error);
gboolean    tpa_connection_get_self_handle
                                        (GObject *obj,
                                         guint *ret,
                                         GError **error);
gboolean    tpa_connection_get_status   (GObject *obj,
                                         TpaConnectionStatus *ret,
                                         GError **error);
gboolean    tpa_connection_hold_handles (GObject *obj,
                                         TpaConnectionHandleType handle_type,
                                         const GArray *handles,
                                         DBusGMethodInvocation *context);
gboolean    tpa_connection_inspect_handles
                                        (GObject *obj,
                                         guint handle_type,
                                         const GArray *handles,
                                         gchar **ret,
                                         GError **error);
gboolean    tpa_connection_list_channels
                                        (GObject *obj,
                                         GPtrArray **ret,
                                         GError **error);
gboolean    tpa_connection_release_handles
                                        (GObject *obj,
                                         TpaConnectionHandleType handle_type,
                                         const GArray *handles,
                                         DBusGMethodInvocation *context);
gboolean    tpa_connection_request_channel
                                        (GObject *obj,
                                         const gchar *type,
                                         TpaConnectionHandleType handle_type,
                                         guint handle,
                                         gboolean suppress_handler,
                                         DBusGMethodInvocation *context);
gboolean    tpa_connection_request_handles
                                        (GObject *obj,
                                         TpaConnectionHandleType handle_type,
                                         const gchar **names,
                                         DBusGMethodInvocation *context);

#endif /* #ifndef __TPA_CONNECTION_PRIVATE_H__*/
