/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MANAGER_H__
#define __TPA_MANAGER_H__

#include <glib-object.h>

#include "tpa-connection-manager.h"

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaManager TpaManager;
typedef struct _TpaManagerClass TpaManagerClass;
typedef struct _TpaManagerPrivate TpaManagerPrivate;

struct _TpaManagerClass {
    GObjectClass parent_class;
};

struct _TpaManager {
    GObject parent;
    TpaManagerPrivate *priv;
};

GType tpa_manager_get_type(void);

/* TYPE MACROS */
#define TPA_TYPE_MANAGER \
  (tpa_manager_get_type())
#define TPA_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_MANAGER, TpaManager))
#define TPA_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_MANAGER, TpaManagerClass))
#define TPA_IS_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_MANAGER))
#define TPA_IS_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_MANAGER))
#define TPA_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_MANAGER, TpaManagerClass))


TpaManager* tpa_manager_new                     (GType object_type,
                                                 const gchar *name,
                                                 const gchar **protocols);
void        tpa_manager_unref                   (TpaManager *self);
gboolean    tpa_manager_register                (TpaManager *self,
                                                 const gchar *name);
void        tpa_manager_add_param               (TpaManager *self,
                                                 const gchar *name,
                                                 guint flag,
                                                 const gchar *type,
                                                 gpointer value);
#define     tpa_manager_add_string_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "s", value))
#define     tpa_manager_add_int16_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "n", value))
#define     tpa_manager_add_int_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "i", value))
#define     tpa_manager_add_uint16_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "q", value))
#define     tpa_manager_add_uint_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "u", value))
#define     tpa_manager_add_boolean_param(self, name, flag, value) \
    (tpa_manager_add_param (self, name, flag, "b", value))
void        tpa_manager_add_account             (TpaManager *self,
                                                 GObject *account);
void        tpa_manager_remove_account          (TpaManager *self,
                                                 GObject *account);

G_END_DECLS

#endif /* #ifndef __TPA_MANAGER_H__*/
