/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include "QtTapioca/ChannelTarget"
#include "QtTapioca/Handle"

namespace QtTapioca {

class ChannelTargetPrivate {
public:
    ChannelTargetPrivate(Handle *h)
        : handle(h)
    {
        uri = handle->inspect();
    }
    ~ChannelTargetPrivate()
    {
        delete handle;
    }

    Handle *handle;
    QString uri;
};

};

using namespace QtTapioca;

ChannelTarget::ChannelTarget(Handle *handle, QObject *parent)
    : QObject(parent),
      d(new ChannelTargetPrivate(handle))
{
}

ChannelTarget::~ChannelTarget()
{
    delete d;
}

QString ChannelTarget::uri() const
{
    return d->uri;
}

Handle *ChannelTarget::handle() const
{
    return d->handle;
}
