/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input filtering base class
 */

#include <ac/ctype.h>
#include <ac/string.h>

#include <mem.h>
#include <tar/input/filter_base.h>


tar_input_filter_base::~tar_input_filter_base()
{
	delete fp;
}


tar_input_filter_base::tar_input_filter_base(tar_input *arg)
	: fp(arg)
{
}


int
tar_input_filter_base::read_data(void *buffer, int maxlen)
{
	return fp->read_data(buffer, maxlen);
}


void
tar_input_filter_base::read_data_padding()
{
	fp->read_data_padding();
}


int
tar_input_filter_base::read_header(tar_header &h)
{
	return fp->read_header(h);
}


void
tar_input_filter_base::read_header_padding()
{
	fp->read_header_padding();
}


const char *
tar_input_filter_base::filename()
	const
{
	return fp->filename();
}


tar_input_filter_base::tar_input_filter_base()
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_filter_base::tar_input_filter_base(const tar_input_filter_base &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_filter_base &
tar_input_filter_base::operator = (const tar_input_filter_base &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
	return *this;
}
