/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/user_name.cc
 */

#ifndef COMMON_TAR_INPUT_USER_NAME_H
#define COMMON_TAR_INPUT_USER_NAME_H

#include <rcstring.h>
#include <tar/input/filter_base.h>

class tar_input_user_name:
	public tar_input_filter_base
{
public:
	virtual ~tar_input_user_name();
	tar_input_user_name(tar_input *, const rcstring &);
	virtual int read_header(tar_header &);

private:
	rcstring name;

	tar_input_user_name();
	tar_input_user_name(const tar_input_user_name &);
	tar_input_user_name &operator = (const tar_input_user_name &);
};

#endif /* COMMON_TAR_INPUT_USER_NAME_H */
