/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar output tar bsd
 */

#include <ac/string.h>

#include <error.h>
#include <tar/format.h>
#include <tar/output/tar/bsd.h>


tar_output_tar_bsd::~tar_output_tar_bsd()
{
}


tar_output_tar_bsd::tar_output_tar_bsd()
{
	::fatal("%s: %d: default contstructor is private (bug)",
		__FILE__, __LINE__);
}


tar_output_tar_bsd::tar_output_tar_bsd(file_output *arg)
	: tar_output_tar_base(arg)
{
}


tar_output_tar_bsd::tar_output_tar_bsd(const tar_output_tar_bsd &arg)
	: tar_output_tar_base(arg)
{
	::fatal("%s: %d: copy constructor is private (bug)",
		__FILE__, __LINE__);
}


tar_output_tar_bsd &
tar_output_tar_bsd::operator = (const tar_output_tar_bsd &)
{
	::fatal("%s: %d: assignment operator is private (bug)",
		__FILE__, __LINE__);
	return *this;
}


void
tar_output_tar_bsd::write_header(const tar_header &h)
{
	char block[TBLOCK];
	memset(block, 0, sizeof(block));
	header_ty *hp = (header_ty *)block;

	if (h.name.length() < 1)
		fatal("filename \"%s\" too short", h.name.to_c_string());
	if (h.name.length() > sizeof(hp->name))
	{
		fatal
		(
			"filename \"%s\" too long (by %d)",
			h.name.to_c_string(),
			h.name.length() - sizeof(hp->name)
		);
	}
	hp->name_set(h.name);

	hp->mode_set(h.mode);
	hp->uid_set(h.user_id);
	hp->gid_set(h.group_id);
	hp->size_set(h.size);
	hp->mtime_set(h.mtime);

	hp->linkflag_set(LF_NORMAL);
	switch (h.type)
	{
	case tar_header::type_normal:
		hp->linkflag_set(LF_NORMAL);
		break;

	case tar_header::type_normal_contiguous:
		hp->linkflag_set(LF_CONTIG);
		break;

	case tar_header::type_directory:
		hp->linkflag_set(LF_NORMAL);
		hp->name_set(h.name + "/");
		break;

	case tar_header::type_link_hard:
		hp->linkflag_set(LF_LINK);
		break;

	case tar_header::type_link_symbolic:
		hp->linkflag_set(LF_SYMLINK);
		break;

	case tar_header::type_fifo:
		hp->linkflag_set(LF_FIFO);
		break;

	case tar_header::type_device_block:
		fatal
		(
		    "\"%s\" block special devices not supported by this format",
			h.name.to_c_string()
		);
		break;

	case tar_header::type_device_character:
		fatal
		(
		"\"%s\" character special devices not supported by this format",
			h.name.to_c_string()
		);
		break;

	case tar_header::type_socket:
		fatal
		(
			"\"%s\" named sockets not supported by this format",
			h.name.to_c_string()
		);
		break;
	}

	if
	(
		h.type == tar_header::type_link_hard
	||
		h.type == tar_header::type_link_symbolic
	)
	{
		if (h.linkname.length() < 1)
		{
			fatal
			(
				"linkname \"%s\" too short",
				h.linkname.to_c_string()
			);
		}
		if (h.linkname.length() > sizeof(hp->linkname))
		{
			fatal
			(
				"linkname \"%s\" too long (by %d)",
				h.linkname.to_c_string(),
				h.linkname.length() - sizeof(hp->linkname)
			);
		}
		hp->linkname_set(h.linkname);
	}

	hp->chksum_set(hp->calculate_checksum());

	write_data(block, sizeof(block));
}
